/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sync.ws.jaxws;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.sync.auth.entity.AccessTokenEntity;
import org.eclipse.higgins.sync.auth.exceptions.AuthenticationException;
import org.eclipse.higgins.sync.bean.CardSyncFacadeBean;
import org.eclipse.higgins.sync.to.AccessTokenTO;
import org.eclipse.higgins.sync.to.AuthCredentialTO;
import org.eclipse.higgins.sync.to.BaseTO;
import org.eclipse.higgins.sync.to.CaptchaTO;
import org.eclipse.higgins.sync.to.CardCategoryTO;
import org.eclipse.higgins.sync.to.CardCredentialTO;
import org.eclipse.higgins.sync.to.CardExtensionTO;
import org.eclipse.higgins.sync.to.CardHistoryTO;
import org.eclipse.higgins.sync.to.CardTO;
import org.eclipse.higgins.sync.to.CardsTO;
import org.eclipse.higgins.sync.to.ClaimTO;
import org.eclipse.higgins.sync.to.ClaimTypeTO;
import org.eclipse.higgins.sync.to.ClaimUiDescriptorTO;
import org.eclipse.higgins.sync.to.CmdExecStatusTO;
import org.eclipse.higgins.sync.to.CmdExecStatusesTO;
import org.eclipse.higgins.sync.to.CommandTO;
import org.eclipse.higgins.sync.to.CommandsTO;
import org.eclipse.higgins.sync.to.CrdFileTO;
import org.eclipse.higgins.sync.to.CrdsFileTO;
import org.eclipse.higgins.sync.to.CredentialDescriptorTO;
import org.eclipse.higgins.sync.to.EndpointReferenceTO;
import org.eclipse.higgins.sync.to.FileTO;
import org.eclipse.higgins.sync.to.MCardTO;
import org.eclipse.higgins.sync.to.PCardTO;
import org.eclipse.higgins.sync.to.PinCredentialTO;
import org.eclipse.higgins.sync.to.RevisionTO;
import org.eclipse.higgins.sync.to.StsPrivacyPolicyTO;
import org.eclipse.higgins.sync.to.TokenServiceTO;
import org.eclipse.higgins.sync.to.UseAlwaysTO;
import org.eclipse.higgins.sync.to.UserProfileTO;
import org.eclipse.higgins.sync.to.UsernamePasswordAuthCredentialTO;
import org.eclipse.higgins.sync.to.UsernamePasswordCredentialTO;
import org.eclipse.higgins.sync.to.WebFormTO;
import org.eclipse.higgins.sync.ws.exception.CardSyncException;
import org.eclipse.higgins.sync.ws.utilities.WSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(name="CardSyncJAXWS", serviceName="CardSyncWS", portName="CardSyncPort", targetNamespace="http://www.eclipse.org/higgins/cardsync/2009/")
@XmlSeeAlso(value={AccessTokenTO.class, UsernamePasswordAuthCredentialTO.class, CardCategoryTO.class, CardTO.class, CredentialDescriptorTO.class, PCardTO.class, TokenServiceTO.class, UserProfileTO.class, AuthCredentialTO.class, CardCredentialTO.class, ClaimTO.class, EndpointReferenceTO.class, PinCredentialTO.class, UseAlwaysTO.class, WebFormTO.class, BaseTO.class, CardExtensionTO.class, ClaimTypeTO.class, MCardTO.class, RevisionTO.class, CaptchaTO.class, CardHistoryTO.class, ClaimUiDescriptorTO.class, CommandTO.class, StsPrivacyPolicyTO.class, UsernamePasswordCredentialTO.class, CardsTO.class, FileTO.class, CrdFileTO.class, CrdsFileTO.class, CmdExecStatusTO.class, CommandTO[].class})
public class CardSyncWS {
    private static final Log LOG = LogFactory.getLog(CardSyncWS.class);
    @Resource
    WebServiceContext wsContext;
    WSUtils wsUtils = new WSUtils();
    private final CardSyncFacadeBean cardSyncBean = new CardSyncFacadeBean();

    private WSUtils getWsUtils() {
        return this.wsUtils;
    }

    private AccessTokenEntity getAccessToken() throws AuthenticationException {
        return this.cardSyncBean.getAccessToken(this.getWsUtils().getAuthTokenId(this.wsContext.getMessageContext()));
    }

    @WebMethod
    public CardTO createCard(@WebParam(name="cardTO") CardTO cardTO) throws CardSyncException {
        try {
            return this.cardSyncBean.persistCard(this.getAccessToken(), cardTO);
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
            throw this.getWsUtils().buildSoapFault(e);
        }
    }

    @WebMethod
    public UserProfileTO createUserProfile(@WebParam(name="userProfileTO") UserProfileTO userProfileTO) throws CardSyncException {
        try {
            return this.cardSyncBean.createUserProfile(userProfileTO);
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
            throw this.getWsUtils().buildSoapFault(e);
        }
    }

    @WebMethod
    public void deleteCard(@WebParam(name="cardId") String id) throws CardSyncException {
        try {
            this.cardSyncBean.deleteCard(this.getAccessToken(), id);
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
            throw this.getWsUtils().buildSoapFault(e);
        }
    }

    @WebMethod
    public void deleteUserProfile() throws CardSyncException {
        try {
            this.cardSyncBean.deleteUserProfile(this.getAccessToken());
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
            throw this.getWsUtils().buildSoapFault(e);
        }
    }

    @WebMethod
    public CardTO getCard(@WebParam(name="cardId") String id) throws CardSyncException {
        try {
            return this.cardSyncBean.getCard(this.getAccessToken(), id);
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
            throw this.getWsUtils().buildSoapFault(e);
        }
    }

    @WebMethod
    public CardsTO getCards() throws CardSyncException {
        try {
            List cards = this.cardSyncBean.getCards(this.getAccessToken());
            return new CardsTO().setCards(cards.toArray(new CardTO[cards.size()]));
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
            throw this.getWsUtils().buildSoapFault(e);
        }
    }

    @WebMethod
    public RevisionTO getRootRevision(List<String> resourceTypeList) throws CardSyncException {
        try {
            return this.cardSyncBean.getRootRevision(this.getAccessToken(), resourceTypeList);
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
            throw this.getWsUtils().buildSoapFault(e);
        }
    }

    @WebMethod
    public UserProfileTO getUserProfile() throws CardSyncException {
        try {
            return this.cardSyncBean.getUserProfile(this.getAccessToken());
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
            throw this.getWsUtils().buildSoapFault(e);
        }
    }

    @WebMethod
    public CardsTO importFromCrd(@WebParam(name="fileTO") FileTO fileTO) throws CardSyncException {
        try {
            List cards = this.cardSyncBean.importFromCrd(this.getAccessToken(), fileTO);
            return new CardsTO().setCards(cards.toArray(new CardTO[cards.size()]));
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
            throw this.getWsUtils().buildSoapFault(e);
        }
    }

    @WebMethod
    public AccessTokenTO signIn(@WebParam(name="authCredentialTO") AuthCredentialTO authCredentialTO) throws CardSyncException {
        try {
            return this.cardSyncBean.createAccessToken(authCredentialTO);
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
            throw this.getWsUtils().buildSoapFault(e);
        }
    }

    @WebMethod
    public void signOut() throws CardSyncException {
        try {
            this.cardSyncBean.deleteAccessToken(this.getWsUtils().getAuthTokenId(this.wsContext.getMessageContext()));
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
            throw this.getWsUtils().buildSoapFault(e);
        }
    }

    @WebMethod
    public CardTO updateCard(@WebParam(name="cardTO") CardTO cardTO) throws CardSyncException {
        try {
            return this.cardSyncBean.persistCard(this.getAccessToken(), cardTO);
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
            throw this.getWsUtils().buildSoapFault(e);
        }
    }

    @WebMethod
    public UserProfileTO updateUserProfile(@WebParam(name="userProfileTO") UserProfileTO userProfileTO) throws CardSyncException {
        try {
            return this.cardSyncBean.updateUserProfile(this.getAccessToken(), userProfileTO);
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
            throw this.getWsUtils().buildSoapFault(e);
        }
    }

    @WebMethod
    public CmdExecStatusesTO execCommands(@WebParam(name="arrayOfCommandTO") CommandsTO commandsTO, @WebParam(name="resourceTypes") String[] resourceTypeList) throws CardSyncException {
        try {
            return this.cardSyncBean.execCommands(this.getAccessToken(), commandsTO, Arrays.asList(resourceTypeList));
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
            throw this.getWsUtils().buildSoapFault(e);
        }
    }

    @WebMethod
    public CommandsTO getCommandLog(@WebParam(name="clientRootRevisionTO") RevisionTO clientRootRevisionTO, @WebParam(name="resourceTypes") String[] resourceTypeList) throws CardSyncException {
        try {
            return this.cardSyncBean.getCommandLog(this.getAccessToken(), clientRootRevisionTO, null != resourceTypeList ? Arrays.asList(resourceTypeList) : null);
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
            throw this.getWsUtils().buildSoapFault(e);
        }
    }
}

