/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sync.ws.rest;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.sync.auth.exceptions.AuthenticationException;
import org.eclipse.higgins.sync.meta.exceptions.ResourceMetaDataException;
import org.eclipse.higgins.sync.to.BaseTO;
import org.eclipse.higgins.sync.to.CardTO;
import org.eclipse.higgins.sync.to.CardsTO;
import org.eclipse.higgins.sync.to.FileTO;
import org.eclipse.higgins.sync.to.ResourceTO;
import org.eclipse.higgins.sync.ws.rest.BaseRes;

@Path(value="/Cards")
@Produces(value={"application/xml"})
@Consumes(value={"application/xml"})
public class ICardRes
extends BaseRes {
    @POST
    @Path(value="/card")
    @Produces(value={"application/xml"})
    public ResourceTO createCard(@HeaderParam(value="Authorization") String accessTokenId, ResourceTO resourceTO) throws AuthenticationException, ResourceMetaDataException, CardException {
        return new ResourceTO().setResource((BaseTO)this.cardSyncBean.persistCard(this.cardSyncBean.getAccessToken(accessTokenId), (CardTO)resourceTO.getResource()));
    }

    @POST
    @Produces(value={"application/xml"})
    public CardsTO importFromCrd(@HeaderParam(value="Authorization") String accessTokenId, FileTO fileTO) throws AuthenticationException, ResourceMetaDataException, CardException {
        List cards = this.cardSyncBean.importFromCrd(this.cardSyncBean.getAccessToken(accessTokenId), fileTO);
        return new CardsTO().setCards(cards.toArray(new CardTO[cards.size()]));
    }

    @GET
    @Produces(value={"application/xml"})
    public CardsTO getCards(@HeaderParam(value="Authorization") String accessTokenId) throws AuthenticationException, ResourceMetaDataException, CardException {
        List cards = this.cardSyncBean.getCards(this.cardSyncBean.getAccessToken(accessTokenId));
        return new CardsTO().setCards(cards.toArray(new CardTO[cards.size()]));
    }

    @DELETE
    @Produces(value={"application/xml"})
    @Path(value="/card")
    public void deleteCard(@HeaderParam(value="Authorization") String accessTokenId, @QueryParam(value="id") String id) throws AuthenticationException, ResourceMetaDataException, CardException {
        this.cardSyncBean.deleteCard(this.cardSyncBean.getAccessToken(accessTokenId), id);
    }

    @GET
    @Path(value="/card")
    @Produces(value={"application/xml"})
    public ResourceTO getCard(@HeaderParam(value="Authorization") String accessTokenId, @QueryParam(value="id") String id) throws AuthenticationException, ResourceMetaDataException, CardException {
        return new ResourceTO().setResource((BaseTO)this.cardSyncBean.getCard(this.cardSyncBean.getAccessToken(accessTokenId), id));
    }

    @PUT
    @Path(value="/card")
    @Produces(value={"application/xml"})
    public ResourceTO updateCard(@HeaderParam(value="Authorization") String accessTokenId, ResourceTO resourceTO) throws AuthenticationException, ResourceMetaDataException, CardException {
        return new ResourceTO().setResource((BaseTO)this.cardSyncBean.persistCard(this.cardSyncBean.getAccessToken(accessTokenId), (CardTO)resourceTO.getResource()));
    }
}

