/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.user.idas.account;

import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.idas.api.EntityExistsException;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityTypeAssertion;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.user.account.Account;
import org.eclipse.higgins.user.account.IUserAccountService;
import org.eclipse.higgins.user.account.exception.ConfigurationException;
import org.eclipse.higgins.user.account.exception.UserAccountException;
import org.eclipse.higgins.user.account.exception.UserAlreadyExistsException;
import org.eclipse.higgins.user.account.exception.UserNotFoundException;
import org.eclipse.higgins.user.idas.util.IdasCtxUris;
import org.eclipse.higgins.user.idas.util.IdasUtils;
import org.eclipse.higgins.user.profile.exception.UserProfileException;

public class AccountService
implements IUserAccountService,
IConfigurableComponent {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$user$idas$account$AccountService == null ? (class$org$eclipse$higgins$user$idas$account$AccountService = AccountService.class$("org.eclipse.higgins.user.idas.account.AccountService")) : class$org$eclipse$higgins$user$idas$account$AccountService));
    private boolean isConfigured = false;
    private IdASRegistry registry;
    private String contextId;
    private String userName;
    private String userPassword;
    static /* synthetic */ Class class$org$eclipse$higgins$user$idas$account$AccountService;

    public Account getAccount(Serializable userId) throws UserAccountException {
        if (userId == null) {
            throw new UserAccountException("Parameter \"userId\" is null");
        }
        String uId = userId.toString();
        IContext context = null;
        try {
            context = this.getContext();
            IEntity ds = context.getEntity(uId);
            if (ds == null) {
                throw new UserNotFoundException("User not found by Id = " + userId);
            }
            URI type = ds.getModel().getType();
            if (!IdasCtxUris.UP_UserProfile.equals(type)) {
                throw new UserAccountException("Unexpected type of user profile entity:" + type.toString());
            }
            Account account = this.initAccountFromEntity(ds);
            return account;
        }
        catch (UserAccountException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UserAccountException((Throwable)e);
        }
        finally {
            this.closeContext(context);
        }
    }

    private Account initAccountFromEntity(IEntity ds) throws IdASException {
        Account acc = new Account();
        acc.setId(ds.getEntityID());
        acc.setLogin((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_loginName));
        ByteBuffer passBuf = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_authPasswordHash);
        acc.setPasswordHash(passBuf != null ? passBuf.array() : null);
        ByteBuffer newPassBuf = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_newAuthPasswordHash);
        acc.setNewPasswordHash(newPassBuf != null ? newPassBuf.array() : null);
        acc.setPasswordIsapMd5(IdasUtils.getSimpleValueDataAsByteArray((IHasAttributes)ds, IdasCtxUris.UP_passwordIsapMd5));
        acc.setPassphraseHash((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_passphraseHash));
        acc.setPasswordResetCode((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_passwordResetCode));
        acc.setResetCodeDate((Date)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_resetCodeDate));
        acc.setPrivateUserINumber((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_privateUserINumber));
        acc.setCreated((Date)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_created));
        return acc;
    }

    public Account createAccount(Serializable userId, Account account) throws UserAccountException {
        String uId = userId != null ? userId.toString() : null;
        IContext context = null;
        try {
            context = this.getContext();
            IEntity ds = context.addEntity(IdasCtxUris.UP_UserProfile, uId);
            Date createdDate = new Date();
            ds.getAttribute(IdasCtxUris.UP_created).addSimpleValue(ITypedValue.DATE_TYPE_URI, (Object)createdDate);
            this.saveAccountToEntity(ds, account);
            context.applyUpdates();
            account.setId(ds.getEntityID());
            account.setCreated(createdDate);
            Account account2 = account;
            return account2;
        }
        catch (EntityExistsException e) {
            throw new UserAlreadyExistsException("Account already exists, id = " + uId);
        }
        catch (Exception e) {
            this.cancelUpdates(context);
            throw new UserAccountException((Throwable)e);
        }
        finally {
            this.closeContext(context);
        }
    }

    private void saveAccountToEntity(IEntity ds, Account account) throws IdASException {
        ds.getAttribute(IdasCtxUris.UP_loginName).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)account.getLogin());
        ds.getAttribute(IdasCtxUris.UP_modified).addSimpleValue(ITypedValue.DATETIME_TYPE_URI, (Object)new Date());
        ds.getAttribute(IdasCtxUris.UP_authPasswordHash).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)this.wrapBytes(account.getPasswordHash()));
        ds.getAttribute(IdasCtxUris.UP_newAuthPasswordHash).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)this.wrapBytes(account.getNewPasswordHash()));
        ds.getAttribute(IdasCtxUris.UP_passwordIsapMd5).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)this.wrapBytes(account.getPasswordIsapMd5()));
        ds.getAttribute(IdasCtxUris.UP_passphraseHash).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)account.getPassphraseHash());
        ds.getAttribute(IdasCtxUris.UP_passwordResetCode).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)account.getPasswordResetCode());
        ds.getAttribute(IdasCtxUris.UP_resetCodeDate).addSimpleValue(ITypedValue.DATETIME_TYPE_URI, (Object)account.getResetCodeDate());
        ds.getAttribute(IdasCtxUris.UP_privateUserINumber).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)account.getPrivateUserINumber());
    }

    private ByteBuffer wrapBytes(byte[] data) {
        if (data != null && data.length > 0) {
            return ByteBuffer.wrap(data);
        }
        return null;
    }

    public void deleteAccount(Serializable userId) throws UserAccountException {
        if (userId == null) {
            throw new UserAccountException("Parameter \"userId\" is null");
        }
        String uId = userId.toString();
        IContext context = null;
        try {
            context = this.getContext();
            IEntity ds = context.getEntity(uId);
            if (ds == null) {
                throw new UserNotFoundException("User not found by Id = " + userId);
            }
            URI type = ds.getModel().getType();
            if (!IdasCtxUris.UP_UserProfile.equals(type)) {
                throw new UserAccountException("Unexpected type of user profile entity:" + type.toString());
            }
            ds.remove();
            this.deleteAllCategories(uId, context);
            context.applyUpdates();
        }
        catch (UserAccountException e) {
            this.cancelUpdates(context);
            throw e;
        }
        catch (Exception e) {
            this.cancelUpdates(context);
            throw new UserAccountException((Throwable)e);
        }
        finally {
            this.closeContext(context);
        }
    }

    private void deleteAllCategories(String userId, IContext context) throws IdASException, UserProfileException {
        IFilter filter = context.buildFilter();
        IFilterAttributeAssertion fas = context.buildAttributeAssertion();
        fas.includeSubtypes(true);
        fas.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
        fas.setID(IdasCtxUris.CC_userIdentifier);
        ISimpleValue val = context.buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, (Object)userId);
        fas.setAssertionValue((IValue)val);
        filter.setAssertion((IFilterAssertion)fas);
        Iterator subjList = context.getEntities(filter);
        while (subjList.hasNext()) {
            IEntity subj = (IEntity)subjList.next();
            subj.remove();
        }
    }

    public boolean existsAccount(String userLogin) throws UserAccountException {
        return this.getAccountId(userLogin) != null;
    }

    public Serializable getAccountId(String userLogin) throws UserAccountException {
        IContext context = null;
        try {
            context = this.getContext();
            IEntity ent = this.getEntityByLogin(context, userLogin);
            if (ent != null) {
                String string = ent.getEntityID();
                return string;
            }
            Serializable serializable = null;
            return serializable;
        }
        catch (Exception e) {
            throw new UserAccountException((Throwable)e);
        }
        finally {
            this.closeContext(context);
        }
    }

    public List getAccounts() throws UserAccountException {
        IContext context = null;
        try {
            context = this.getContext();
            Iterator itr = this.getAllEntities(context);
            ArrayList<Account> res = new ArrayList<Account>();
            while (itr.hasNext()) {
                IEntity ent = (IEntity)itr.next();
                Account acc = this.initAccountFromEntity(ent);
                res.add(acc);
            }
            ArrayList<Account> arrayList = res;
            return arrayList;
        }
        catch (Exception e) {
            throw new UserAccountException((Throwable)e);
        }
        finally {
            this.closeContext(context);
        }
    }

    private Iterator getAllEntities(IContext context) throws IdASException {
        IFilter filter = context.buildFilter();
        IFilterEntityTypeAssertion fas = context.buildEntityTypeAssertion();
        fas.setAssertionValue(IdasCtxUris.UP_UserProfile);
        filter.setAssertion((IFilterAssertion)fas);
        return context.getEntities(filter);
    }

    private IEntity getEntityByLogin(IContext context, String login) throws IdASException, UserAccountException {
        IFilter filter = context.buildFilter();
        IFilterAttributeAssertion fas = context.buildAttributeAssertion();
        fas.includeSubtypes(true);
        fas.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
        fas.setID(IdasCtxUris.UP_loginName);
        ISimpleValue val = context.buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, (Object)login);
        fas.setAssertionValue((IValue)val);
        filter.setAssertion((IFilterAssertion)fas);
        Iterator subjList = context.getEntities(filter);
        if (subjList.hasNext()) {
            IEntity res = (IEntity)subjList.next();
            if (subjList.hasNext()) {
                throw new UserAccountException("More than one account with the same login exists : " + login);
            }
            return res;
        }
        return null;
    }

    public Account modifyAccount(Account account) throws UserAccountException {
        if (account == null) {
            throw new UserAccountException("Parameter \"account\" is null");
        }
        String uId = account.getId();
        if (uId == null) {
            throw new UserAccountException("User account object can not be saved because its id is null");
        }
        IContext context = null;
        try {
            context = this.getContext();
            IEntity ds = context.getEntity(uId);
            if (ds == null) {
                throw new UserAlreadyExistsException("Can not find user account by id = " + uId);
            }
            URI type = ds.getModel().getType();
            if (!IdasCtxUris.UP_UserProfile.equals(type)) {
                throw new UserAccountException("Unexpected type of user profile entity:" + type.toString());
            }
            this.saveAccountToEntity(ds, account);
            context.applyUpdates();
            Account account2 = account;
            return account2;
        }
        catch (UserAccountException e) {
            throw e;
        }
        catch (Exception e) {
            this.cancelUpdates(context);
            throw new UserAccountException((Throwable)e);
        }
        finally {
            this.closeContext(context);
        }
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws Exception {
        this.registry = IdASRegistry.getInstance();
        Object ctxObj = mapComponentSettings.get("contextId");
        if (!(ctxObj instanceof String)) {
            throw new ConfigurationException("\"contextId\" xsd:string not found");
        }
        this.contextId = (String)ctxObj;
        Object userObj = mapComponentSettings.get("user");
        if (!(userObj instanceof String)) {
            throw new ConfigurationException("\"user\" xsd:string not found");
        }
        this.userName = (String)userObj;
        Object passObj = mapComponentSettings.get("password");
        if (!(passObj instanceof String)) {
            throw new ConfigurationException("\"password\" xsd:string not found");
        }
        this.userPassword = (String)passObj;
        this.isConfigured = true;
    }

    public ISettingDescriptor getComponentDescriptor() {
        return null;
    }

    private IContext getContext() throws IdASException, UserAccountException {
        if (!this.isConfigured) {
            throw new UserAccountException("IdAS based user profile service was not configured");
        }
        IContext ctx = this.registry.createContext(this.contextId);
        ctx.open((IAuthNMaterials)new AuthNNamePasswordMaterials(ctx, this.userName, this.userPassword));
        return ctx;
    }

    private void closeContext(IContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (IdASException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    private void cancelUpdates(IContext ctx) throws UserAccountException {
        try {
            if (ctx != null) {
                ctx.cancelUpdates();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserAccountException((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

