/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.user.idas.loginModule;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.user.account.callback.IsapMd5PasswordCallback;
import org.eclipse.higgins.user.idas.util.IdasCtxUris;
import org.eclipse.higgins.user.idas.util.IdasUtils;
import org.eclipse.higgins.user.login.UserIdentifierPrincipal;
import org.eclipse.higgins.user.login.exception.ConfigurationException;

public class IsapMd5PasswordModule
implements LoginModule {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$user$idas$loginModule$IsapMd5PasswordModule == null ? (class$org$eclipse$higgins$user$idas$loginModule$IsapMd5PasswordModule = IsapMd5PasswordModule.class$("org.eclipse.higgins.user.idas.loginModule.IsapMd5PasswordModule")) : class$org$eclipse$higgins$user$idas$loginModule$IsapMd5PasswordModule));
    private static final String CONTEXT_ID = "contextId";
    private static final String USER_NAME = "user";
    private static final String PASSWORD = "password";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map options;
    private IEntity userEntity;
    private String username;
    private byte[] isapMd5password;
    static /* synthetic */ Class class$org$eclipse$higgins$user$idas$loginModule$IsapMd5PasswordModule;

    public boolean abort() throws LoginException {
        log.trace((Object)"IsapMd5PasswordModule.abort()");
        return false;
    }

    public boolean commit() throws LoginException {
        String userId;
        log.trace((Object)"IsapMd5PasswordModule.commit()");
        if (this.userEntity == null) {
            return false;
        }
        try {
            userId = this.userEntity.getEntityID();
        }
        catch (IdASException e) {
            log.error((Object)e, (Throwable)e);
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
        UserIdentifierPrincipal id = new UserIdentifierPrincipal((Serializable)((Object)userId));
        this.subject.getPrincipals().add((Principal)id);
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
    }

    private Object getOption(String propertyName) throws Exception {
        if (this.options.containsKey(propertyName)) {
            return this.options.get(propertyName);
        }
        String errorMsg = "Options map does not contain " + propertyName + " property for LoginModule " + (class$org$eclipse$higgins$user$idas$loginModule$IsapMd5PasswordModule == null ? (class$org$eclipse$higgins$user$idas$loginModule$IsapMd5PasswordModule = IsapMd5PasswordModule.class$("org.eclipse.higgins.user.idas.loginModule.IsapMd5PasswordModule")) : class$org$eclipse$higgins$user$idas$loginModule$IsapMd5PasswordModule).getName();
        throw new ConfigurationException(errorMsg);
    }

    private IContext openContext() throws Exception {
        String contextId = (String)this.getOption(CONTEXT_ID);
        String userName = (String)this.getOption(USER_NAME);
        String password = (String)this.getOption(PASSWORD);
        IdASRegistry registry = IdASRegistry.getInstance();
        IContext ctx = registry.createContext(contextId);
        AuthNNamePasswordMaterials credential = new AuthNNamePasswordMaterials(ctx, userName, password);
        ctx.open((IAuthNMaterials)credential);
        return ctx;
    }

    private IEntity getUserByLogin(IContext ctx, String login) throws LoginException {
        try {
            IFilter filter = ctx.buildFilter();
            IFilterAttributeAssertion fas = ctx.buildAttributeAssertion();
            fas.includeSubtypes(false);
            fas.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
            fas.setID(IdasCtxUris.UP_loginName);
            ISimpleValue val = ctx.buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, (Object)login);
            fas.setAssertionValue((IValue)val);
            filter.setAssertion((IFilterAssertion)fas);
            Iterator subjList = ctx.getEntities(filter);
            IEntity subj = null;
            if (subjList.hasNext()) {
                subj = (IEntity)subjList.next();
                if (subjList.hasNext()) {
                    throw new LoginException("More than one user account entity found by login ");
                }
            }
            return subj;
        }
        catch (IdASException e) {
            log.error((Object)e, (Throwable)e);
            LoginException newEx = new LoginException();
            newEx.initCause(e);
            throw newEx;
        }
    }

    public boolean login() throws LoginException {
        boolean bl;
        log.trace((Object)"IsapMd5PasswordModule.login()");
        IContext ctx = null;
        NameCallback loginCallback = new NameCallback("user name: ");
        IsapMd5PasswordCallback passCallback = new IsapMd5PasswordCallback();
        Callback[] callbacks = new Callback[]{loginCallback, passCallback};
        try {
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (UnsupportedCallbackException e) {
                log.debug((Object)e, (Throwable)e);
                boolean bl2 = false;
                this.closeContext(ctx);
                return bl2;
            }
            this.username = loginCallback.getName();
            this.isapMd5password = passCallback.getPasswordIsapMd5();
            if (this.isapMd5password == null || this.isapMd5password.length == 0) {
                boolean e = false;
                return e;
            }
            ctx = this.openContext();
            this.userEntity = this.getUserByLogin(ctx, this.username);
            if (this.userEntity == null) {
                boolean e = false;
                this.closeContext(ctx);
                return e;
            }
            byte[] realPassword = null;
            ByteBuffer buf = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)this.userEntity, IdasCtxUris.UP_passwordIsapMd5);
            if (buf != null) {
                realPassword = buf.array();
            }
            bl = Arrays.equals(realPassword, this.isapMd5password);
            this.closeContext(ctx);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            LoginException newEx = new LoginException();
            newEx.initCause(e);
            throw newEx;
        }
        finally {
            this.closeContext(ctx);
        }
        return bl;
    }

    public boolean logout() throws LoginException {
        return true;
    }

    private void closeContext(IContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (IdASException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

