/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.user.idas.loginModule;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.user.account.utils.PasswordUtils;
import org.eclipse.higgins.user.idas.util.IdasCtxUris;
import org.eclipse.higgins.user.idas.util.IdasUtils;
import org.eclipse.higgins.user.login.UserIdentifierPrincipal;
import org.eclipse.higgins.user.login.exception.ConfigurationException;

public class UserNamePasswordModuleOld
implements LoginModule {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$user$idas$loginModule$UserNamePasswordModuleOld == null ? (class$org$eclipse$higgins$user$idas$loginModule$UserNamePasswordModuleOld = UserNamePasswordModuleOld.class$("org.eclipse.higgins.user.idas.loginModule.UserNamePasswordModuleOld")) : class$org$eclipse$higgins$user$idas$loginModule$UserNamePasswordModuleOld));
    private static final String CONTEXT_ID = "contextId";
    private static final String USER_NAME = "user";
    private static final String PASSWORD = "password";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map options;
    private IEntity userEntity;
    private String username;
    private char[] password;
    static /* synthetic */ Class class$org$eclipse$higgins$user$idas$loginModule$UserNamePasswordModuleOld;

    public boolean abort() throws LoginException {
        log.trace((Object)"UserNamePasswordModule.abort()");
        return false;
    }

    public boolean commit() throws LoginException {
        String userId;
        log.trace((Object)"UserNamePasswordModule.commit()");
        if (this.userEntity == null) {
            return false;
        }
        try {
            userId = this.userEntity.getEntityID();
        }
        catch (IdASException e) {
            log.error((Object)e, (Throwable)e);
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
        UserIdentifierPrincipal id = new UserIdentifierPrincipal((Serializable)((Object)userId));
        this.subject.getPrincipals().add((Principal)id);
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
    }

    private Object getOption(String propertyName) throws Exception {
        if (this.options.containsKey(propertyName)) {
            return this.options.get(propertyName);
        }
        String errorMsg = "Options map does not contain " + propertyName + " property for LoginModule " + (class$org$eclipse$higgins$user$idas$loginModule$UserNamePasswordModuleOld == null ? (class$org$eclipse$higgins$user$idas$loginModule$UserNamePasswordModuleOld = UserNamePasswordModuleOld.class$("org.eclipse.higgins.user.idas.loginModule.UserNamePasswordModuleOld")) : class$org$eclipse$higgins$user$idas$loginModule$UserNamePasswordModuleOld).getName();
        throw new ConfigurationException(errorMsg);
    }

    private IContext openContext() throws Exception {
        String contextId = (String)this.getOption(CONTEXT_ID);
        String userName = (String)this.getOption(USER_NAME);
        String password = (String)this.getOption(PASSWORD);
        IdASRegistry registry = IdASRegistry.getInstance();
        IContext ctx = registry.createContext(contextId);
        AuthNNamePasswordMaterials credential = new AuthNNamePasswordMaterials(ctx, userName, password);
        ctx.open((IAuthNMaterials)credential);
        return ctx;
    }

    private IEntity getUserByLogin(IContext ctx, String login) throws LoginException {
        try {
            IFilter filter = ctx.buildFilter();
            IFilterAttributeAssertion fas = ctx.buildAttributeAssertion();
            fas.includeSubtypes(false);
            fas.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
            fas.setID(IdasCtxUris.UP_loginName);
            ISimpleValue val = ctx.buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, (Object)login);
            fas.setAssertionValue((IValue)val);
            filter.setAssertion((IFilterAssertion)fas);
            Iterator subjList = ctx.getEntities(filter);
            IEntity subj = null;
            if (subjList.hasNext()) {
                subj = (IEntity)subjList.next();
                if (subjList.hasNext()) {
                    throw new LoginException("More than one user account entity found by login");
                }
                return subj;
            }
            return null;
        }
        catch (IdASException e) {
            log.error((Object)e, (Throwable)e);
            LoginException newEx = new LoginException();
            newEx.initCause(e);
            throw newEx;
        }
    }

    private boolean checkRealPasswordHash(IEntity user, byte[] passedPassHash) throws IdASException {
        byte[] realPassHash = null;
        ByteBuffer buf = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)user, IdasCtxUris.UP_authPasswordHash);
        if (buf != null) {
            realPassHash = buf.array();
        }
        if (passedPassHash == null || passedPassHash.length == 0) {
            return realPassHash == null || realPassHash.length == 0;
        }
        return Arrays.equals(realPassHash, passedPassHash);
    }

    private boolean checkRealNewPasswordHash(IEntity user, byte[] passedPassHash) throws IdASException {
        if (passedPassHash == null || passedPassHash.length == 0) {
            return false;
        }
        byte[] realPassHash = null;
        ByteBuffer buf = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)user, IdasCtxUris.UP_newAuthPasswordHash);
        if (buf != null) {
            realPassHash = buf.array();
        }
        if (passedPassHash == null || passedPassHash.length == 0) {
            return realPassHash == null || realPassHash.length == 0;
        }
        return Arrays.equals(realPassHash, passedPassHash);
    }

    private boolean checkPassword(IEntity user, char[] password) throws LoginException, IdASException, NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] passedPassHash = null;
        if (password != null && password.length > 0) {
            passedPassHash = PasswordUtils.getPasswordHash((String)new String(password));
        }
        return this.checkRealPasswordHash(user, passedPassHash) || this.checkRealNewPasswordHash(user, passedPassHash);
    }

    public boolean login() throws LoginException {
        IContext ctx;
        block10: {
            log.trace((Object)"UserNamePasswordModule.login()");
            if (this.callbackHandler == null) {
                throw new LoginException("No CallbackHandler available");
            }
            ctx = null;
            NameCallback loginCallback = new NameCallback("user name: ");
            PasswordCallback passCallback = new PasswordCallback("password: ", false);
            Callback[] callbacks = new Callback[]{loginCallback, passCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (UnsupportedCallbackException e) {
                log.debug((Object)e, (Throwable)e);
                boolean bl = false;
                this.closeContext(ctx);
                return bl;
            }
            this.username = loginCallback.getName();
            if (this.username == null) {
                throw new LoginException("User name is null");
            }
            this.password = passCallback.getPassword();
            passCallback.clearPassword();
            ctx = this.openContext();
            String entityID = this.username.startsWith("urn:") ? this.username : "urn:" + this.username;
            this.userEntity = ctx.getEntity(entityID);
            if (this.userEntity != null) break block10;
            boolean bl = false;
            this.closeContext(ctx);
            return bl;
        }
        try {
            boolean bl = this.checkPassword(this.userEntity, this.password);
            this.closeContext(ctx);
            return bl;
        }
        catch (Exception e) {
            try {
                log.error((Object)e, (Throwable)e);
                LoginException newEx = new LoginException();
                newEx.initCause(e);
                throw newEx;
            }
            catch (Throwable throwable) {
                this.closeContext(ctx);
                throw throwable;
            }
        }
    }

    public boolean logout() throws LoginException {
        return true;
    }

    private void closeContext(IContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (IdASException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

