/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.user.idas.util;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;

public final class IdasUtils {
    private IdasUtils() {
    }

    private static Object getSVAttrValue(ISingleValuedAttribute attr) throws IdASException {
        IValue v;
        if (attr != null && (v = attr.getValue()) != null) {
            if (v.isSimple()) {
                ISimpleValue sv = (ISimpleValue)v;
                return sv.getData();
            }
            throw new IdASException("Attribute " + (attr.getType() != null ? attr.getType().toString() : "") + " contains non simple value");
        }
        return null;
    }

    public static Object getSimpleValueData(IHasAttributes ha, URI attribute) throws IdASException {
        ISingleValuedAttribute attr = ha.getSingleValuedAttribute(attribute);
        return IdasUtils.getSVAttrValue(attr);
    }

    public static ByteBuffer getSimpleValueDataAsByteBuffer(IHasAttributes ha, URI attribute) throws IdASException {
        return (ByteBuffer)IdasUtils.getSimpleValueData(ha, attribute);
    }

    public static byte[] getSimpleValueDataAsByteArray(IHasAttributes ha, URI attribure) throws IdASException {
        ByteBuffer bb = IdasUtils.getSimpleValueDataAsByteBuffer(ha, attribure);
        return bb != null && bb.hasArray() ? bb.array() : null;
    }

    public static void saveSimpleValueCollection(IAttribute att, Collection collection) throws IdASException {
        att.remove();
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                att.addSimpleValue(ITypedValue.STRING_TYPE_URI, iterator.next());
            }
        }
    }

    public static List loadSimpleValueList(IAttribute att) throws IdASException {
        Iterator it;
        if (att != null && (it = att.getValues()).hasNext()) {
            ArrayList<Object> lst = new ArrayList<Object>();
            while (it.hasNext()) {
                lst.add(((ISimpleValue)it.next()).getData());
            }
            return lst;
        }
        return null;
    }

    public static Set loadSimpleValueSet(IAttribute att) throws IdASException {
        Iterator it;
        if (att != null && (it = att.getValues()).hasNext()) {
            HashSet<Object> set = new HashSet<Object>();
            while (it.hasNext()) {
                set.add(((ISimpleValue)it.next()).getData());
            }
            return set;
        }
        return null;
    }

    public static void saveComplexValueMap(IAttribute complexAttr, URI keyAttr, URI valueAttr, Map map) throws IdASException {
        complexAttr.remove();
        if (map != null) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                IEntity val = complexAttr.addComplexValue((URI)null);
                val.getAttribute(keyAttr).addSimpleValue(null, e.getKey());
                val.getAttribute(valueAttr).addSimpleValue(null, e.getValue());
            }
        }
    }

    public static Map loadComplexValueMap(IAttribute complexAttr, URI keyAttr, URI valueAttr) throws IdASException {
        Iterator vals = complexAttr.getValues();
        if (vals.hasNext()) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            while (vals.hasNext()) {
                IValue val = (IValue)vals.next();
                if (!val.isSimple()) {
                    map.put(IdasUtils.getSimpleValueData((IHasAttributes)val, keyAttr), IdasUtils.getSimpleValueData((IHasAttributes)val, valueAttr));
                    continue;
                }
                throw new IdASException("Complex value expected, but found " + complexAttr.getModel().getType());
            }
            return map;
        }
        return null;
    }
}

