/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.user.idas.loginModule;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.user.account.callback.IsapMd5PasswordCallback;
import org.eclipse.higgins.user.idas.util.IdasCtxUris;
import org.eclipse.higgins.user.idas.util.IdasUtils;
import org.eclipse.higgins.user.login.UserIdentifierPrincipal;
import org.eclipse.higgins.user.login.exception.ConfigurationException;

public class IsapMd5PasswordModule
implements LoginModule {
    private static Log log;
    private static final String CONTEXT_ID = "contextId";
    private static final String USER_NAME = "user";
    private static final String PASSWORD = "password";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map options;
    private IEntity userEntity;
    private String username;
    private byte[] isapMd5password;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.user.idas.loginModule.IsapMd5PasswordModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public boolean abort() throws LoginException {
        log.trace((Object)"IsapMd5PasswordModule.abort()");
        return false;
    }

    public boolean commit() throws LoginException {
        String userId;
        log.trace((Object)"IsapMd5PasswordModule.commit()");
        if (this.userEntity == null) {
            return false;
        }
        try {
            userId = this.userEntity.getEntityID();
        }
        catch (IdASException e) {
            log.error((Object)e, (Throwable)e);
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
        UserIdentifierPrincipal id = new UserIdentifierPrincipal((Serializable)((Object)userId));
        this.subject.getPrincipals().add((Principal)id);
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
    }

    private Object getOption(String propertyName) throws Exception {
        if (this.options.containsKey(propertyName)) {
            return this.options.get(propertyName);
        }
        StringBuffer stringBuffer = new StringBuffer("Options map does not contain ").append(propertyName).append(" property for LoginModule ");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.user.idas.loginModule.IsapMd5PasswordModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String errorMsg = stringBuffer.append(clazz.getName()).toString();
        throw new ConfigurationException(errorMsg);
    }

    private IContext openContext() throws Exception {
        String contextId = (String)this.getOption(CONTEXT_ID);
        String userName = (String)this.getOption(USER_NAME);
        String password = (String)this.getOption(PASSWORD);
        IdASRegistry registry = IdASRegistry.getInstance();
        IContext ctx = registry.createContext(contextId);
        AuthNNamePasswordMaterials credential = new AuthNNamePasswordMaterials(ctx, userName, password);
        ctx.open((IAuthNMaterials)credential);
        return ctx;
    }

    private IEntity getUserByLogin(IContext ctx, String login) throws LoginException {
        try {
            IFilter filter = ctx.buildFilter();
            IFilterAttributeAssertion fas = ctx.buildAttributeAssertion();
            fas.includeSubtypes(false);
            fas.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
            fas.setID(IdasCtxUris.UP_loginName);
            ISimpleValue val = ctx.buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, (Object)login);
            fas.setAssertionValue((IValue)val);
            filter.setAssertion((IFilterAssertion)fas);
            Iterator subjList = ctx.getEntities(filter);
            IEntity subj = null;
            if (subjList.hasNext()) {
                subj = (IEntity)subjList.next();
                if (subjList.hasNext()) {
                    throw new LoginException("More than one user account entity found by login ");
                }
            }
            return subj;
        }
        catch (IdASException e) {
            log.error((Object)e, (Throwable)e);
            LoginException newEx = new LoginException();
            newEx.initCause(e);
            throw newEx;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean login() throws LoginException {
        IsapMd5PasswordModule.log.trace((Object)"IsapMd5PasswordModule.login()");
        ctx = null;
        loginCallback = new NameCallback("user name: ");
        passCallback = new IsapMd5PasswordCallback();
        callbacks = new Callback[]{loginCallback, passCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            IsapMd5PasswordModule.log.debug((Object)e, (Throwable)e);
lbl13:
            // 3 sources

            while (true) {
                var7_8 = null;
                this.closeContext(ctx);
                return false;
            }
        }
        try {
            this.username = loginCallback.getName();
            this.isapMd5password = passCallback.getPasswordIsapMd5();
            if (this.isapMd5password == null || this.isapMd5password.length == 0) ** GOTO lbl13
            ctx = this.openContext();
            this.userEntity = this.getUserByLogin(ctx, this.username);
            if (this.userEntity != null) ** break;
            ** continue;
            realPassword = null;
            buf = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)this.userEntity, IdasCtxUris.UP_passwordIsapMd5);
            if (buf != null) {
                realPassword = buf.array();
            }
            var9_13 = Arrays.equals(realPassword, this.isapMd5password);
            var7_9 = null;
            this.closeContext(ctx);
            return var9_13;
        }
        catch (Exception e) {
            try {
                IsapMd5PasswordModule.log.error((Object)e, (Throwable)e);
                newEx = new LoginException();
                newEx.initCause(e);
                throw newEx;
            }
            catch (Throwable var8_14) {
                var7_10 = null;
                this.closeContext(ctx);
                throw var8_14;
            }
        }
    }

    public boolean logout() throws LoginException {
        return true;
    }

    private void closeContext(IContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (IdASException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }
}

