/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.user.idas.loginModule;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.dv.util.Base64;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.user.account.utils.PasswordUtils;
import org.eclipse.higgins.user.idas.util.IdasCtxUris;
import org.eclipse.higgins.user.idas.util.IdasUtils;
import org.eclipse.higgins.user.login.UserIdentifierPrincipal;
import org.eclipse.higgins.user.login.exception.ConfigurationException;

public class UserNamePasswordModule
implements LoginModule {
    private static Log log;
    private static final String CONTEXT_ID = "contextId";
    private static final String USER_NAME = "user";
    private static final String PASSWORD = "password";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map options;
    private IEntity userEntity;
    private String username;
    private char[] password;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.user.idas.loginModule.UserNamePasswordModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public boolean abort() throws LoginException {
        log.trace((Object)"UserNamePasswordModule.abort()");
        return false;
    }

    public boolean commit() throws LoginException {
        String userId;
        log.trace((Object)"UserNamePasswordModule.commit()");
        if (this.userEntity == null) {
            return false;
        }
        try {
            userId = this.userEntity.getEntityID();
        }
        catch (IdASException e) {
            log.error((Object)e, (Throwable)e);
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
        UserIdentifierPrincipal id = new UserIdentifierPrincipal((Serializable)((Object)userId));
        this.subject.getPrincipals().add((Principal)id);
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
    }

    private Object getOption(String propertyName) throws Exception {
        if (this.options.containsKey(propertyName)) {
            return this.options.get(propertyName);
        }
        StringBuffer stringBuffer = new StringBuffer("Options map does not contain ").append(propertyName).append(" property for LoginModule ");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.user.idas.loginModule.UserNamePasswordModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String errorMsg = stringBuffer.append(clazz.getName()).toString();
        throw new ConfigurationException(errorMsg);
    }

    private IContext openContext() throws Exception {
        String contextId = (String)this.getOption(CONTEXT_ID);
        String userName = (String)this.getOption(USER_NAME);
        String password = (String)this.getOption(PASSWORD);
        IdASRegistry registry = IdASRegistry.getInstance();
        IContext ctx = registry.createContext(contextId);
        AuthNNamePasswordMaterials credential = new AuthNNamePasswordMaterials(ctx, userName, password);
        ctx.open((IAuthNMaterials)credential);
        return ctx;
    }

    private IEntity getUserByLogin(IContext ctx, String login) throws LoginException {
        try {
            IFilter filter = ctx.buildFilter();
            IFilterAttributeAssertion fas = ctx.buildAttributeAssertion();
            fas.includeSubtypes(false);
            fas.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
            fas.setID(IdasCtxUris.UP_loginName);
            ISimpleValue val = ctx.buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, (Object)login);
            fas.setAssertionValue((IValue)val);
            filter.setAssertion((IFilterAssertion)fas);
            Iterator subjList = ctx.getEntities(filter);
            IEntity subj = null;
            if (subjList.hasNext()) {
                subj = (IEntity)subjList.next();
                if (subjList.hasNext()) {
                    throw new LoginException("More than one user account entity found by login");
                }
                return subj;
            }
            return null;
        }
        catch (IdASException e) {
            log.error((Object)e, (Throwable)e);
            LoginException newEx = new LoginException();
            newEx.initCause(e);
            throw newEx;
        }
    }

    private boolean checkRealPasswordHash(IEntity user, byte[] passedPassHash) throws IdASException {
        byte[] realPassHash = null;
        ByteBuffer buf = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)user, IdasCtxUris.UP_authPasswordHash);
        if (buf != null) {
            realPassHash = buf.array();
        }
        if (passedPassHash == null || passedPassHash.length == 0) {
            return realPassHash == null || realPassHash.length == 0;
        }
        return Arrays.equals(realPassHash, passedPassHash);
    }

    private boolean checkRealNewPasswordHash(IEntity user, byte[] passedPassHash) throws IdASException {
        if (passedPassHash == null || passedPassHash.length == 0) {
            return false;
        }
        byte[] realPassHash = null;
        ByteBuffer buf = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)user, IdasCtxUris.UP_newAuthPasswordHash);
        if (buf != null) {
            realPassHash = buf.array();
        }
        if (passedPassHash == null || passedPassHash.length == 0) {
            return realPassHash == null || realPassHash.length == 0;
        }
        return Arrays.equals(realPassHash, passedPassHash);
    }

    private boolean checkPasswordOldSelector(IEntity user, char[] password) throws LoginException, IdASException, NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] passedPassHash = null;
        if (password != null && password.length > 0) {
            passedPassHash = PasswordUtils.getPasswordHash((String)new String(password));
        }
        return this.checkRealPasswordHash(user, passedPassHash) || this.checkRealNewPasswordHash(user, passedPassHash);
    }

    private boolean checkPasswordNewSelector(IEntity user, char[] password) throws LoginException, IdASException, NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] passedPassHash = null;
        if (password != null && password.length > 0) {
            try {
                String base64PasswordHash = new String(password);
                passedPassHash = Base64.decode((String)base64PasswordHash);
            }
            catch (Exception e) {
                log.debug((Object)e, (Throwable)e);
                return false;
            }
        }
        return this.checkRealPasswordHash(user, passedPassHash) || this.checkRealNewPasswordHash(user, passedPassHash);
    }

    /*
     * Unable to fully structure code
     */
    public boolean login() throws LoginException {
        UserNamePasswordModule.log.trace((Object)"UserNamePasswordModule.login()");
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available");
        }
        ctx = null;
        loginCallback = new NameCallback("user name: ");
        passCallback = new PasswordCallback("password: ", false);
        callbacks = new Callback[]{loginCallback, passCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            UserNamePasswordModule.log.debug((Object)e, (Throwable)e);
            while (true) {
                var7_7 = null;
                this.closeContext(ctx);
                return false;
            }
        }
        try {
            this.username = loginCallback.getName();
            this.password = passCallback.getPassword();
            passCallback.clearPassword();
            ctx = this.openContext();
            this.userEntity = this.getUserByLogin(ctx, this.username);
            if (this.userEntity == null) ** continue;
            var9_10 = this.checkPasswordOldSelector(this.userEntity, this.password) != false || this.checkPasswordNewSelector(this.userEntity, this.password) != false;
            var7_8 = null;
            this.closeContext(ctx);
            return var9_10;
        }
        catch (Exception e) {
            try {
                UserNamePasswordModule.log.error((Object)e, (Throwable)e);
                newEx = new LoginException();
                newEx.initCause(e);
                throw newEx;
            }
            catch (Throwable var8_12) {
                var7_9 = null;
                this.closeContext(ctx);
                throw var8_12;
            }
        }
    }

    public boolean logout() throws LoginException {
        return true;
    }

    private void closeContext(IContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (IdASException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }
}

