/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.user.idas.profile;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheKey;
import org.eclipse.higgins.cache.api.key.UserCacheKey;
import org.eclipse.higgins.cache.nocache.NOCache;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.user.idas.profile.CardUsageComparator;
import org.eclipse.higgins.user.idas.util.IdasCtxUris;
import org.eclipse.higgins.user.idas.util.IdasUtils;
import org.eclipse.higgins.user.profile.IUserProfileService;
import org.eclipse.higgins.user.profile.entity.Captcha;
import org.eclipse.higgins.user.profile.entity.CardCredential;
import org.eclipse.higgins.user.profile.entity.CardInformation;
import org.eclipse.higgins.user.profile.entity.CardUrlRelation;
import org.eclipse.higgins.user.profile.entity.CardUsage;
import org.eclipse.higgins.user.profile.entity.Category;
import org.eclipse.higgins.user.profile.entity.PolicyVersion;
import org.eclipse.higgins.user.profile.entity.SelectorClient;
import org.eclipse.higgins.user.profile.entity.UserProfile;
import org.eclipse.higgins.user.profile.entity.WebForm;
import org.eclipse.higgins.user.profile.exception.CategoryNotFoundException;
import org.eclipse.higgins.user.profile.exception.ConfigurationException;
import org.eclipse.higgins.user.profile.exception.NoSuchEntityException;
import org.eclipse.higgins.user.profile.exception.SelectorClientNotFoundException;
import org.eclipse.higgins.user.profile.exception.UserProfileException;

public class ProfileService
implements IUserProfileService,
IConfigurableComponent {
    private static Log log;
    private static ICache userProfileCache;
    private static boolean isNoCache;
    private static ICache cardUrlRelationCache;
    private static boolean isNoCardUrlRelationCache;
    private static ICache useAlwaysCache;
    private static boolean isNoUseAlwaysCache;
    private static ICache cardInformationCache;
    private static boolean isNoCardInformationCache;
    private static ICache selectorClientCache;
    private static boolean isNoSelectorClientCache;
    private static ICache categoryCache;
    private static boolean isNoCategoryCache;
    private boolean isConfigured = false;
    private IdASRegistry registry;
    private String contextId;
    private String userName;
    private String userPassword;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.user.idas.profile.ProfileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        userProfileCache = CacheProviderFactory.getCacheProvider().getCache("UserProfile.UserProfiles");
        isNoCache = userProfileCache instanceof NOCache;
        cardUrlRelationCache = CacheProviderFactory.getCacheProvider().getCache("UserProfile.CardUrlRelation");
        isNoCardUrlRelationCache = cardUrlRelationCache instanceof NOCache;
        useAlwaysCache = CacheProviderFactory.getCacheProvider().getCache("UserProfile.UseAlways");
        isNoUseAlwaysCache = useAlwaysCache instanceof NOCache;
        cardInformationCache = CacheProviderFactory.getCacheProvider().getCache("UserProfile.CardInformation");
        isNoCardInformationCache = cardInformationCache instanceof NOCache;
        selectorClientCache = CacheProviderFactory.getCacheProvider().getCache("UserProfile.SelectorClient");
        isNoSelectorClientCache = selectorClientCache instanceof NOCache;
        categoryCache = CacheProviderFactory.getCacheProvider().getCache("UserProfile.Category");
        isNoCategoryCache = categoryCache instanceof NOCache;
    }

    public synchronized void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws Exception {
        this.isConfigured = false;
        this.registry = IdASRegistry.getInstance();
        Object ctxObj = mapComponentSettings.get("contextId");
        if (!(ctxObj instanceof String)) {
            throw new ConfigurationException("\"contextId\" xsd:string not found");
        }
        this.contextId = (String)ctxObj;
        Object userObj = mapComponentSettings.get("user");
        if (!(userObj instanceof String)) {
            throw new ConfigurationException("\"user\" xsd:string not found");
        }
        this.userName = (String)userObj;
        Object passObj = mapComponentSettings.get("password");
        if (!(passObj instanceof String)) {
            throw new ConfigurationException("\"password\" xsd:string not found");
        }
        this.userPassword = (String)passObj;
        this.isConfigured = true;
    }

    public ISettingDescriptor getComponentDescriptor() {
        return null;
    }

    protected IContext getContext() throws IdASException, UserProfileException {
        if (!this.isConfigured) {
            throw new UserProfileException("IdAS based user profile service was not configured");
        }
        IContext ctx = this.registry.createContext(this.contextId);
        ctx.open((IAuthNMaterials)new AuthNNamePasswordMaterials(ctx, this.userName, this.userPassword));
        return ctx;
    }

    private void closeContext(IContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (IdASException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    private void cancelUpdates(IContext ctx) throws UserProfileException {
        try {
            if (ctx != null) {
                ctx.cancelUpdates();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public UserProfile addUserProfile(Serializable userId, UserProfile userProfile) throws UserProfileException {
        return this.modifyUserProfile(userId, userProfile);
    }

    public void deleteUserProfile(Serializable userId) throws UserProfileException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UserProfile loadUserProfile(String userId) throws UserProfileException {
        IContext context = null;
        try {
            try {
                context = this.getContext();
                IEntity ds = context.getEntity(userId);
                if (ds == null) {
                    throw new NoSuchEntityException("User not found by Id = " + userId);
                }
                URI type = ds.getModel().getType();
                if (!IdasCtxUris.UP_UserProfile.equals(type)) {
                    throw new UserProfileException("Unexpected type of user profile entity:" + type.toString());
                }
                UserProfile userProfile = this.initFromDS_UP(ds);
                Object var5_8 = null;
                this.closeContext(context);
                return userProfile;
            }
            catch (UserProfileException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.closeContext(context);
            throw throwable;
        }
    }

    private UserProfile initFromDS_UP(IEntity ds) throws UserProfileException, IdASException {
        UserProfile up = new UserProfile();
        up.setFirstName((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_firstName));
        up.setLastName((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_lastName));
        up.setEmail((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_email));
        up.setCreated((Date)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_created));
        up.setModified((Date)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_modified));
        up.setStatus((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_status));
        up.setUsedFrom((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_usedFrom));
        up.setPrivateSelectorINumbers(IdasUtils.loadSimpleValueList(ds.getAttribute(IdasCtxUris.UP_privateSelectorINumbers)));
        up.setOneTimePasswords(IdasUtils.loadComplexValueMap(ds.getAttribute(IdasCtxUris.UP_oneTimePasswords), IdasCtxUris.OT_otpTimestamp, IdasCtxUris.OT_otpValue));
        up.setBlackListedSites(IdasUtils.loadSimpleValueSet(ds.getAttribute(IdasCtxUris.UP_blackListedSites)));
        up.setPrivateKey(IdasUtils.getSimpleValueDataAsByteArray((IHasAttributes)ds, IdasCtxUris.UP_privateKey));
        up.setSms((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_sms));
        up.setDefaultPCardCUID((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_defaultPCardCUID));
        up.setReferralTracking((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_referralTracking));
        Boolean sendMeNews = (Boolean)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_sendMeNews);
        if (sendMeNews != null) {
            up.setSendMeNews(sendMeNews.booleanValue());
        }
        up.setUserIdentifier((Serializable)((Object)ds.getEntityID()));
        return up;
    }

    public UserProfile getUserProfile(Serializable userId) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        String id = userId.toString();
        if (isNoCache) {
            return this.loadUserProfile(id);
        }
        UserCacheKey key = new UserCacheKey(id);
        if (userProfileCache.isKeyInCache((ICacheKey)key)) {
            return (UserProfile)userProfileCache.get((ICacheKey)key);
        }
        UserProfile userProfile = this.loadUserProfile(id);
        userProfileCache.put((ICacheKey)key, (Object)userProfile);
        return userProfile;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserProfile modifyUserProfile(Serializable userId, UserProfile userProfile) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (userProfile == null) {
            throw new UserProfileException("Parameter \"userProfile\" is null");
        }
        String userIdStr = userId.toString();
        IContext context = null;
        try {
            try {
                context = this.getContext();
                IEntity ds = context.getEntity(userIdStr);
                if (ds == null) {
                    throw new NoSuchEntityException("User not found by Id = " + userId);
                }
                userProfile.setModified(new Date());
                this.saveToDS_UP(userProfile, ds);
                context.applyUpdates();
                if (userProfile.getUserIdentifier() == null) {
                    userProfile.setUserIdentifier(userId);
                }
                if (!isNoCache) {
                    UserCacheKey key = new UserCacheKey(userIdStr);
                    userProfileCache.put((ICacheKey)key, (Object)userProfile);
                }
                context.applyUpdates();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeContext(context);
            throw throwable;
        }
        {
            Object var7_10 = null;
            this.closeContext(context);
            return userProfile;
        }
    }

    private void saveToDS_UP(UserProfile up, IEntity ds) throws Exception {
        ds.getAttribute(IdasCtxUris.UP_firstName).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getFirstName());
        ds.getAttribute(IdasCtxUris.UP_lastName).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getLastName());
        ds.getAttribute(IdasCtxUris.UP_email).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getEmail());
        ds.getAttribute(IdasCtxUris.UP_modified).addSimpleValue(ITypedValue.DATETIME_TYPE_URI, (Object)up.getModified());
        ds.getAttribute(IdasCtxUris.UP_status).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getStatus());
        ds.getAttribute(IdasCtxUris.UP_usedFrom).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getUsedFrom());
        IdasUtils.saveSimpleValueCollection(ds.getAttribute(IdasCtxUris.UP_privateSelectorINumbers), up.getPrivateSelectorINumbers());
        IdasUtils.saveComplexValueMap(ds.getAttribute(IdasCtxUris.UP_oneTimePasswords), IdasCtxUris.OT_otpTimestamp, IdasCtxUris.OT_otpValue, up.getOneTimePasswords());
        IdasUtils.saveSimpleValueCollection(ds.getAttribute(IdasCtxUris.UP_blackListedSites), up.getBlackListedSites());
        ds.getAttribute(IdasCtxUris.UP_privateKey).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, up.getPrivateKey() == null ? null : ByteBuffer.wrap(up.getPrivateKey()));
        ds.getAttribute(IdasCtxUris.UP_sms).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getSms());
        ds.getAttribute(IdasCtxUris.UP_defaultPCardCUID).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getDefaultPCardCUID());
        ds.getAttribute(IdasCtxUris.UP_referralTracking).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getReferralTracking());
        ds.getAttribute(IdasCtxUris.UP_sendMeNews).addSimpleValue(ITypedValue.BOOLEAN_TYPE_URI, (Object)new Boolean(up.isSendMeNews()));
        up.setCreated((Date)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_created));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Category addCategory(Serializable userId, Category category) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        String user = userId.toString();
        if (category == null) {
            throw new UserProfileException("Parameter \"category\" is null");
        }
        IContext context = null;
        try {
            try {
                context = this.getContext();
                IEntity ds = context.addEntity(IdasCtxUris.CC_CardCategory, null);
                ds.getAttribute(IdasCtxUris.CC_userIdentifier).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)user);
                this.saveToDS_cat(category, ds);
                context.applyUpdates();
                this.addCategoryToCache(user, category);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.closeContext(context);
            throw throwable;
        }
        {
            Object var6_9 = null;
            this.closeContext(context);
            return category;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteCategory(Serializable userId, String categoryId) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (categoryId == null) {
            throw new UserProfileException("Parameter \"categoryId\" is null");
        }
        IContext context = null;
        try {
            try {
                String uidPassed = userId.toString();
                context = this.getContext();
                IEntity ds = context.getEntity(categoryId);
                String uidFound = (String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_userIdentifier);
                if (!uidPassed.equals(uidFound)) {
                    throw new UserProfileException("Category " + categoryId + " does not belong to the user with Id = " + uidPassed);
                }
                ds.remove();
                context.applyUpdates();
                this.removeCategoryFromCache(uidPassed, categoryId);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeContext(context);
            throw throwable;
        }
        {
            Object var7_10 = null;
            this.closeContext(context);
            return;
        }
    }

    public List getCategories(Serializable userId) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        HashMap cMap = this.getCategories(userId.toString());
        return new ArrayList(cMap.values());
    }

    private Category initFromDS_cat(IEntity ds) throws UserProfileException, IdASException {
        Category cat = new Category();
        cat.setId(ds.getEntityID());
        cat.setParentId((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_parentId));
        cat.setName((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_name));
        cat.setIcon((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_icon));
        cat.setSelectedIcon((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_selectedIcon));
        Integer idx = (Integer)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_idx);
        if (idx == null) {
            cat.setIdx(0);
        } else {
            cat.setIdx(idx.intValue());
        }
        cat.setType((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_type));
        IAttribute att = ds.getAttribute(IdasCtxUris.CC_cuid);
        String cuid = null;
        ArrayList<String> cuids = new ArrayList<String>();
        if (att.getValues() != null) {
            Iterator iter = att.getValues();
            while (iter.hasNext()) {
                IValue v = (IValue)iter.next();
                if (!v.isSimple()) {
                    throw new UserProfileException("Attribute " + (att.getType() != null ? att.getType().toString() : "") + " contains non simple value");
                }
                ISimpleValue sv = (ISimpleValue)v;
                cuid = (String)sv.getData();
                cuids.add(cuid);
            }
        }
        cat.setCardList(cuids);
        return cat;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Category modifyCategory(Serializable userId, Category category) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (category == null) {
            throw new UserProfileException("Parameter \"category\" is null");
        }
        String categoryId = category.getId();
        if (categoryId == null) {
            throw new IllegalArgumentException("Parameter \"categoryId\" is null");
        }
        String uidPassed = userId.toString();
        IContext context = null;
        try {
            try {
                context = this.getContext();
                IEntity ds = context.getEntity(categoryId);
                if (ds == null) {
                    throw new CategoryNotFoundException("Category \"" + category.getId() + "\" not found!");
                }
                String uidFound = (String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_userIdentifier);
                if (!uidPassed.equals(uidFound)) {
                    throw new UserProfileException("Category " + categoryId + " does not belong to the user with Id = " + uidPassed);
                }
                this.saveToDS_cat(category, ds);
                context.applyUpdates();
                this.addCategoryToCache(uidPassed, category);
                Category category2 = category;
                Object var8_11 = null;
                this.closeContext(context);
                return category2;
            }
            catch (UserProfileException e) {
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.closeContext(context);
            throw throwable;
        }
    }

    private void removeCategoryFromCache(String userId, String categoryId) {
        Map cMap;
        UserCacheKey key;
        if (!isNoCategoryCache && categoryCache.isKeyInCache((ICacheKey)(key = new UserCacheKey(userId))) && (cMap = (Map)categoryCache.get((ICacheKey)key)) != null && cMap.containsKey(categoryId)) {
            cMap.remove(categoryId);
        }
    }

    private void addCategoryToCache(String userId, Category category) {
        Map cMap;
        UserCacheKey key;
        if (!isNoCategoryCache && categoryCache.isKeyInCache((ICacheKey)(key = new UserCacheKey(userId))) && (cMap = (Map)categoryCache.get((ICacheKey)key)) != null) {
            cMap.put(userId, category);
        }
    }

    private HashMap getCategories(String userId) throws UserProfileException {
        HashMap mapC = this.getCategoryFromCache(userId);
        if (mapC == null) {
            mapC = this.getCategoryFromDB(userId);
        }
        return mapC;
    }

    private HashMap getCategoryFromCache(String userId) {
        UserCacheKey key;
        HashMap categoryAll = null;
        if (!isNoCategoryCache && categoryCache.isKeyInCache((ICacheKey)(key = new UserCacheKey(userId)))) {
            categoryAll = (HashMap)categoryCache.get((ICacheKey)key);
        }
        return categoryAll;
    }

    private HashMap getCategoryFromDB(String userId) throws UserProfileException {
        IContext context = null;
        try {
            context = this.getContext();
            IFilter filter = context.buildFilter();
            IFilterAttributeAssertion fas = context.buildAttributeAssertion();
            fas.includeSubtypes(true);
            fas.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
            fas.setID(IdasCtxUris.CC_userIdentifier);
            ISimpleValue val = context.buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, (Object)userId);
            fas.setAssertionValue((IValue)val);
            filter.setAssertion((IFilterAssertion)fas);
            Iterator subjList = context.getEntities(filter);
            HashMap<String, Category> categories = new HashMap<String, Category>();
            while (subjList.hasNext()) {
                IEntity subj = (IEntity)subjList.next();
                if (!IdasCtxUris.CC_CardCategory.equals(subj.getModel().getType())) continue;
                Category category = this.initFromDS_cat(subj);
                categories.put(category.getId(), category);
            }
            HashMap<String, Category> hashMap = categories;
            Object var10_12 = null;
            this.closeContext(context);
            return hashMap;
        }
        catch (Exception e) {
            try {
                log.error((Object)e, (Throwable)e);
                throw new UserProfileException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                this.closeContext(context);
                throw throwable;
            }
        }
    }

    private void saveToDS_cat(Category cat, IEntity ds) throws Exception {
        cat.setId(ds.getEntityID());
        ds.getAttribute(IdasCtxUris.CC_parentId).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cat.getParentId());
        ds.getAttribute(IdasCtxUris.CC_name).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cat.getName());
        ds.getAttribute(IdasCtxUris.CC_icon).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cat.getIcon());
        ds.getAttribute(IdasCtxUris.CC_selectedIcon).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cat.getSelectedIcon());
        ds.getAttribute(IdasCtxUris.CC_idx).addSimpleValue(ITypedValue.INTEGER_TYPE_URI, (Object)new Integer(cat.getIdx()));
        ds.getAttribute(IdasCtxUris.CC_type).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cat.getType());
        IAttribute attr = ds.getAttribute(IdasCtxUris.CC_cuid);
        attr.remove();
        if (cat.getCardList() != null && !cat.getCardList().isEmpty()) {
            Iterator iter = cat.getCardList().iterator();
            while (iter.hasNext()) {
                attr.addSimpleValue(ITypedValue.STRING_TYPE_URI, iter.next());
            }
        }
    }

    private void clearCardCredentialInDB(IEntity userProfile, CUID cuid) throws UserProfileException, IdASException, CardException {
        IAttribute attCI = userProfile.getAttribute(IdasCtxUris.UP_cardInformation);
        Iterator valsCI = attCI.getValues();
        while (valsCI.hasNext()) {
            IValue valCI = (IValue)valsCI.next();
            if (!valCI.isSimple()) {
                IEntity cardInfoVal = (IEntity)valCI;
                CUID cuidVal = new CUID((String)IdasUtils.getSimpleValueData((IHasAttributes)cardInfoVal, IdasCtxUris.CC_cuid));
                if (!cuid.equals((Object)cuidVal)) continue;
                IAttribute credentialsAttr = cardInfoVal.getAttribute(IdasCtxUris.CCI_cardCred);
                credentialsAttr.remove();
                break;
            }
            throw new UserProfileException("Complex value expected, but found " + valCI.getType().toString());
        }
    }

    public CardInformation clearCardCredential(Serializable userId, CUID cuid) throws UserProfileException {
        IContext context;
        block7: {
            if (userId == null) {
                throw new UserProfileException("Parameter \"userId\" is null");
            }
            String userIdStr = userId.toString();
            if (cuid == null) {
                throw new UserProfileException("Parameter \"cuid\" is null");
            }
            context = null;
            context = this.getContext();
            IEntity userProfile = this.getUserProfileEntity(userId, context);
            HashMap cardInfo = this.getCardInformation(userProfile, userIdStr);
            if (!cardInfo.containsKey(cuid)) break block7;
            this.clearCardCredentialInDB(userProfile, cuid);
            context.applyUpdates();
            CardInformation ci = (CardInformation)cardInfo.get(cuid);
            ci.setCardCredential(null);
            CardInformation cardInformation = ci;
            Object var8_10 = null;
            this.closeContext(context);
            return cardInformation;
        }
        try {
            Object var8_11 = null;
            this.closeContext(context);
            return null;
        }
        catch (Exception e) {
            try {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                this.closeContext(context);
                throw throwable;
            }
        }
    }

    public CardInformation getCardInformation(Serializable userId, CUID cuid) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (cuid == null) {
            throw new UserProfileException("Parameter \"cuid\" is null");
        }
        HashMap ciMap = this.getCardInformation(userId.toString());
        if (ciMap.containsKey(cuid)) {
            return (CardInformation)ciMap.get(cuid);
        }
        CardInformation newCI = new CardInformation();
        newCI.setCuid(cuid);
        return newCI;
    }

    private void saveCardCredential(IEntity cardInfoVal, CardCredential cardCredential) throws IdASException {
        ISingleValuedAttribute attCardCred = cardInfoVal.getSingleValuedAttribute(IdasCtxUris.CCI_cardCred);
        IEntity valCC = (IEntity)attCardCred.getValue();
        if (valCC == null) {
            valCC = attCardCred.addComplexValue(null);
        }
        valCC.getSingleValuedAttribute(IdasCtxUris.CCI_SC_type).addSimpleValue(null, (Object)cardCredential.getCredentialType());
        valCC.getSingleValuedAttribute(IdasCtxUris.CCI_SC_tsAddress).addSimpleValue(null, (Object)cardCredential.getTsAddress());
        valCC.getSingleValuedAttribute(IdasCtxUris.CCI_SC_tsMetadataAddress).addSimpleValue(null, (Object)cardCredential.getTsMetadataAddress());
        valCC.getSingleValuedAttribute(IdasCtxUris.UP_loginName).addSimpleValue(null, (Object)cardCredential.getUsername());
        valCC.getSingleValuedAttribute(IdasCtxUris.UP_password).addSimpleValue(null, (Object)cardCredential.getPassword());
        valCC.getSingleValuedAttribute(IdasCtxUris.CCI_SC_pinCode).addSimpleValue(null, cardCredential.getPinCode() == null ? null : ByteBuffer.wrap(cardCredential.getPinCode()));
    }

    public CardInformation setCardCredential(Serializable userId, CUID cuid, CardCredential cardCredential) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (cuid == null) {
            throw new UserProfileException("Parameter \"cuid\" is null");
        }
        if (cardCredential == null) {
            throw new UserProfileException("Parameter \"cardCredential\" is null");
        }
        IContext context = null;
        try {
            context = this.getContext();
            IEntity userProfile = this.getUserProfileEntity(userId, context);
            IAttribute attCI = userProfile.getAttribute(IdasCtxUris.UP_cardInformation);
            IEntity cardInfoVal = null;
            CardInformation ci = null;
            HashMap ciMap = this.getCardInformation(userProfile, userId.toString());
            if (ciMap.containsKey(cuid)) {
                cardInfoVal = this.getCardInformationValue(attCI, cuid);
                ci = (CardInformation)ciMap.get(cuid);
            } else {
                cardInfoVal = attCI.addComplexValue(null);
                cardInfoVal.getAttribute(IdasCtxUris.CC_cuid).addSimpleValue(null, (Object)cuid.toString());
                ci = new CardInformation();
                ci.setCuid(cuid);
            }
            this.saveCardCredential(cardInfoVal, cardCredential);
            context.applyUpdates();
            ci.setCardCredential(cardCredential);
            ciMap.put(cuid, ci);
            CardInformation cardInformation = ci;
            Object var10_12 = null;
            this.closeContext(context);
            return cardInformation;
        }
        catch (Exception e) {
            try {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                this.closeContext(context);
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PolicyVersion getRPPolicyVersion(Serializable userId, WebForm form) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (form == null) {
            throw new UserProfileException("Parameter \"form\" is null");
        }
        String userIdStr = userId.toString();
        IContext context = null;
        try {
            try {
                block9: {
                    String formAction;
                    String formId;
                    String formName;
                    IEntity valPV;
                    URI uri;
                    WebForm wfFound;
                    context = this.getContext();
                    IEntity dsUser = context.getEntity(userIdStr);
                    if (dsUser == null) {
                        throw new NoSuchEntityException("User not found by Id = " + userId);
                    }
                    IAttribute attPV = dsUser.getAttribute(IdasCtxUris.UP_policyVersion);
                    Iterator it = attPV.getValues();
                    do {
                        if (!it.hasNext()) break block9;
                    } while (!(wfFound = new WebForm(uri = (URI)IdasUtils.getSimpleValueData((IHasAttributes)(valPV = (IEntity)it.next()), IdasCtxUris.CU_url), formName = (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formName), formId = (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formId), formAction = (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formAction))).equals((Object)form));
                    PolicyVersion pv = new PolicyVersion();
                    pv.setForm(wfFound);
                    pv.setPolicy(new String(((ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.PV_policy)).array(), "UTF-8"));
                    pv.setVersion((String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.PV_version));
                    PolicyVersion policyVersion = pv;
                    Object var15_18 = null;
                    this.closeContext(context);
                    return policyVersion;
                }
                Object var15_19 = null;
                this.closeContext(context);
                return null;
            }
            catch (UserProfileException e) {
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            this.closeContext(context);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRPPolicyVersion(Serializable userId, PolicyVersion policyVersion) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (policyVersion == null) {
            throw new UserProfileException("Parameter \"policyVersion\" is null");
        }
        if (policyVersion.getForm() == null) {
            throw new UserProfileException("Parameter \"policyVersion.webForm\" can not be null");
        }
        if (policyVersion.getPolicy() == null) {
            throw new UserProfileException("Parameter \"policyVersion.policy\" can not be null");
        }
        if (policyVersion.getVersion() == null) {
            throw new UserProfileException("Parameter \"policyVersion.version\" can not be null");
        }
        String userIdStr = userId.toString();
        IContext context = null;
        try {
            try {
                IEntity valPV;
                IAttribute attPV;
                block13: {
                    String formAction;
                    String formId;
                    String formName;
                    URI uri;
                    WebForm wfFound;
                    context = this.getContext();
                    IEntity dsUser = context.getEntity(userIdStr);
                    if (dsUser == null) {
                        throw new NoSuchEntityException("User not found by Id = " + userId);
                    }
                    attPV = dsUser.getAttribute(IdasCtxUris.UP_policyVersion);
                    Iterator it = attPV.getValues();
                    do {
                        if (!it.hasNext()) break block13;
                    } while (!(wfFound = new WebForm(uri = (URI)IdasUtils.getSimpleValueData((IHasAttributes)(valPV = (IEntity)it.next()), IdasCtxUris.CU_url), formName = (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formName), formId = (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formId), formAction = (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formAction))).equals((Object)policyVersion.getForm()));
                    valPV.getAttribute(IdasCtxUris.PV_policy).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)ByteBuffer.wrap(policyVersion.getPolicy().getBytes("UTF-8")));
                    valPV.getAttribute(IdasCtxUris.PV_version).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)policyVersion.getVersion());
                    context.applyUpdates();
                    Object var14_16 = null;
                    this.closeContext(context);
                    return;
                }
                valPV = attPV.addComplexValue(IdasCtxUris.PV_PolicyVersion);
                valPV.getAttribute(IdasCtxUris.CU_url).addSimpleValue(ITypedValue.ANYURI_TYPE_URI, (Object)policyVersion.getForm().getUrl());
                valPV.getAttribute(IdasCtxUris.CU_formAction).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)policyVersion.getForm().getFormAction());
                valPV.getAttribute(IdasCtxUris.CU_formId).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)policyVersion.getForm().getFormId());
                valPV.getAttribute(IdasCtxUris.CU_formName).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)policyVersion.getForm().getFormName());
                valPV.getAttribute(IdasCtxUris.PV_policy).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)ByteBuffer.wrap(policyVersion.getPolicy().getBytes("UTF-8")));
                valPV.getAttribute(IdasCtxUris.PV_version).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)policyVersion.getVersion());
                context.applyUpdates();
            }
            catch (UserProfileException e) {
                this.cancelUpdates(context);
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            this.closeContext(context);
            throw throwable;
        }
        {
            Object var14_18 = null;
            this.closeContext(context);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Captcha addCaptcha(Captcha captcha) throws UserProfileException {
        if (captcha == null) {
            throw new UserProfileException("Parameter \"captcha\" is null.");
        }
        if (captcha.getId() != null) {
            throw new UserProfileException("Passed captcha has been already stored.");
        }
        String cKey = captcha.getKey();
        if (cKey == null) throw new UserProfileException("Passed captcha contains no key.");
        if (cKey.trim().length() == 0) {
            throw new UserProfileException("Passed captcha contains no key.");
        }
        Date cDate = captcha.getDtCreation();
        if (cDate == null) {
            throw new UserProfileException("Passed captcha contains no creation date.");
        }
        IContext ctx = null;
        try {
            try {
                ctx = this.getContext();
                IEntity cEntity = ctx.addEntity(IdasCtxUris.UP_Captcha, null);
                cEntity.getAttribute(IdasCtxUris.UP_key).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cKey);
                cEntity.getAttribute(IdasCtxUris.UP_dtCreation).addSimpleValue(ITypedValue.DATETIME_TYPE_URI, (Object)cDate);
                ctx.applyUpdates();
                String newId = cEntity.getEntityID();
                captcha.setId(newId);
            }
            catch (IdASException e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(ctx);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeContext(ctx);
            throw throwable;
        }
        {
            Object var7_10 = null;
            this.closeContext(ctx);
            return captcha;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteCaptcha(String captchaId) throws UserProfileException {
        if (captchaId == null) {
            throw new UserProfileException("Parameter \"captchaId\" is null.");
        }
        IContext ctx = null;
        try {
            try {
                ctx = this.getContext();
                IEntity cEntity = ctx.getEntity(captchaId);
                if (cEntity == null) {
                    throw new NoSuchEntityException("Could not find IdAS entity by passed ID.");
                }
                URI type = cEntity.getModel().getType();
                if (!IdasCtxUris.UP_Captcha.equals(type)) throw new UserProfileException("Entity with required ID has unexpected type " + type.toString());
                cEntity.remove();
                ctx.applyUpdates();
            }
            catch (UserProfileException e) {
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(ctx);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.closeContext(ctx);
            throw throwable;
        }
        {
            Object var5_9 = null;
            this.closeContext(ctx);
            return;
        }
    }

    public void deleteCaptcha(Captcha captcha) throws UserProfileException {
        if (captcha == null) {
            throw new UserProfileException("Parameter \"captcha\" is null.");
        }
        this.deleteCaptcha(captcha.getId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Captcha getCaptcha(String captchaID) throws UserProfileException {
        if (captchaID == null) {
            throw new UserProfileException("Parameter \"captchaID\" is null.");
        }
        IContext ctx = null;
        try {
            try {
                ctx = this.getContext();
                IEntity cEntity = ctx.getEntity(captchaID);
                if (cEntity == null) {
                    throw new NoSuchEntityException("Could not find IdAS entity by passed ID.");
                }
                String id = cEntity.getEntityID();
                String key = (String)IdasUtils.getSimpleValueData((IHasAttributes)cEntity, IdasCtxUris.UP_key);
                Date dtCreation = (Date)IdasUtils.getSimpleValueData((IHasAttributes)cEntity, IdasCtxUris.UP_dtCreation);
                Captcha captcha = new Captcha();
                captcha.setDtCreation(dtCreation);
                captcha.setId(id);
                captcha.setKey(key);
                Captcha captcha2 = captcha;
                Object var8_11 = null;
                this.closeContext(ctx);
                return captcha2;
            }
            catch (UserProfileException e) {
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.closeContext(ctx);
            throw throwable;
        }
    }

    public Captcha modifyCaptcha(Captcha captcha) throws UserProfileException {
        throw new UserProfileException("Not implemented.");
    }

    private HashSet getCardUrlRelation(IEntity userProfile, String userId) throws IdASException, UserProfileException, CardException {
        HashSet cardUrlRelations = this.getCardUrlRelationFromCache(userId);
        if (cardUrlRelations == null) {
            cardUrlRelations = this.getCardUrlRelationFromDB(userProfile, userId);
        }
        return cardUrlRelations;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashSet getCardUrlRelation(String userId) throws UserProfileException {
        HashSet setCUR = this.getCardUrlRelationFromCache(userId.toString());
        if (setCUR != null) return setCUR;
        IContext context = null;
        try {
            try {
                context = this.getContext();
                IEntity userProfile = this.getUserProfileEntity((Serializable)((Object)userId), context);
                setCUR = this.getCardUrlRelationFromDB(userProfile, userId.toString());
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeContext(context);
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.closeContext(context);
            return setCUR;
        }
    }

    private HashSet getCardUrlRelationFromCache(String userId) {
        UserCacheKey key;
        HashSet cardUrlRelationsAll = null;
        if (!isNoCardUrlRelationCache && cardUrlRelationCache.isKeyInCache((ICacheKey)(key = new UserCacheKey(userId)))) {
            cardUrlRelationsAll = (HashSet)cardUrlRelationCache.get((ICacheKey)key);
        }
        return cardUrlRelationsAll;
    }

    private HashSet getCardUrlRelationFromDB(IEntity userProfile, String userId) throws IdASException, UserProfileException, CardException {
        HashSet<CardUrlRelation> cardUrlRelations = new HashSet<CardUrlRelation>();
        IAttribute attCUR = userProfile.getAttribute(IdasCtxUris.UP_cardUrlRelation);
        Iterator valsCUR = attCUR.getValues();
        while (valsCUR.hasNext()) {
            IValue valCUR = (IValue)valsCUR.next();
            if (!valCUR.isSimple()) {
                CardUrlRelation cu = new CardUrlRelation();
                cu.setCuid(new CUID((String)IdasUtils.getSimpleValueData((IHasAttributes)((IEntity)valCUR), IdasCtxUris.CC_cuid)));
                WebForm wf = new WebForm();
                wf.setUrl((URI)IdasUtils.getSimpleValueData((IHasAttributes)((IEntity)valCUR), IdasCtxUris.CU_url));
                wf.setFormAction((String)IdasUtils.getSimpleValueData((IHasAttributes)((IEntity)valCUR), IdasCtxUris.CU_formAction));
                wf.setFormId((String)IdasUtils.getSimpleValueData((IHasAttributes)((IEntity)valCUR), IdasCtxUris.CU_formId));
                wf.setFormName((String)IdasUtils.getSimpleValueData((IHasAttributes)((IEntity)valCUR), IdasCtxUris.CU_formName));
                cu.setForm(wf);
                cu.setLastUsed((Date)IdasUtils.getSimpleValueData((IHasAttributes)((IEntity)valCUR), IdasCtxUris.CU_lastUsed));
                IAttribute attOC = ((IEntity)valCUR).getAttribute(IdasCtxUris.CU_optionalClaims);
                HashSet<String> optionalClaims = new HashSet<String>();
                Iterator it = attOC.getValues();
                while (it.hasNext()) {
                    IValue valOC = (IValue)it.next();
                    if (valOC.isSimple()) {
                        optionalClaims.add((String)((ISimpleValue)valOC).getData());
                        continue;
                    }
                    throw new UserProfileException("Simple value expected, but complex found " + attOC.getModel().getType());
                }
                if (optionalClaims.size() > 0) {
                    cu.setOptionalClaims(optionalClaims);
                }
                cardUrlRelations.add(cu);
                continue;
            }
            throw new UserProfileException("Complex value expected, but simple found " + valCUR.getType().toString());
        }
        if (!isNoCardUrlRelationCache) {
            UserCacheKey key = new UserCacheKey(userId);
            cardUrlRelationCache.put((ICacheKey)key, cardUrlRelations);
        }
        return cardUrlRelations;
    }

    private CardCredential getCardCredential(IEntity valCardInfo) throws IdASException {
        CardCredential cc = null;
        ISingleValuedAttribute attCardCred = valCardInfo.getSingleValuedAttribute(IdasCtxUris.CCI_cardCred);
        IEntity val = (IEntity)attCardCred.getValue();
        if (val != null) {
            cc = new CardCredential();
            cc.setCredentialType((String)IdasUtils.getSimpleValueData((IHasAttributes)val, IdasCtxUris.CCI_SC_type));
            cc.setTsAddress((String)IdasUtils.getSimpleValueData((IHasAttributes)val, IdasCtxUris.CCI_SC_tsAddress));
            cc.setTsMetadataAddress((String)IdasUtils.getSimpleValueData((IHasAttributes)val, IdasCtxUris.CCI_SC_tsMetadataAddress));
            cc.setUsername((String)IdasUtils.getSimpleValueData((IHasAttributes)val, IdasCtxUris.UP_loginName));
            cc.setPassword((String)IdasUtils.getSimpleValueData((IHasAttributes)val, IdasCtxUris.UP_password));
            ByteBuffer bb = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)val, IdasCtxUris.CCI_SC_pinCode);
            cc.setPinCode(bb != null ? bb.array() : null);
        }
        return cc;
    }

    private HashSet getCardUsageSet(IEntity valCardInfo, CUID cuid) throws IdASException, URISyntaxException, UserProfileException {
        HashSet<CardUsage> cardUsageSet = new HashSet<CardUsage>();
        IAttribute attCardUsage = valCardInfo.getAttribute(IdasCtxUris.CCI_cardUsage);
        Iterator valsCardUsage = attCardUsage.getValues();
        while (valsCardUsage.hasNext()) {
            IValue val = (IValue)valsCardUsage.next();
            if (!val.isSimple()) {
                IEntity cardUsageVal = (IEntity)val;
                CardUsage cu = new CardUsage();
                cu.setCuid(cuid);
                URI url = new URI((String)IdasUtils.getSimpleValueData((IHasAttributes)cardUsageVal, IdasCtxUris.CCI_CU_site));
                String formName = (String)IdasUtils.getSimpleValueData((IHasAttributes)cardUsageVal, IdasCtxUris.CU_formName);
                String formId = (String)IdasUtils.getSimpleValueData((IHasAttributes)cardUsageVal, IdasCtxUris.CU_formId);
                String formAction = (String)IdasUtils.getSimpleValueData((IHasAttributes)cardUsageVal, IdasCtxUris.CU_formAction);
                cu.setDate((Date)IdasUtils.getSimpleValueData((IHasAttributes)cardUsageVal, IdasCtxUris.CCI_CU_date));
                cu.setForm(new WebForm(url, formName, formId, formAction));
                cardUsageSet.add(cu);
                continue;
            }
            throw new UserProfileException("Complex value expected, but found " + val.getType().toString());
        }
        return cardUsageSet;
    }

    private HashMap getCardInformation(IEntity userProfile, String userId) throws IdASException, UserProfileException, CardException, URISyntaxException {
        HashMap cardInformation = this.getCardInformationFromCache(userId);
        if (cardInformation == null) {
            cardInformation = this.getCardInformationFromDB(userProfile, userId);
        }
        return cardInformation;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap getCardInformation(String userId) throws UserProfileException {
        HashMap mapCI = this.getCardInformationFromCache(userId.toString());
        if (mapCI != null) return mapCI;
        IContext context = null;
        try {
            try {
                context = this.getContext();
                IEntity userProfile = this.getUserProfileEntity((Serializable)((Object)userId), context);
                mapCI = this.getCardInformationFromDB(userProfile, userId.toString());
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeContext(context);
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.closeContext(context);
            return mapCI;
        }
    }

    private HashMap getCardInformationFromCache(String userId) {
        UserCacheKey key;
        HashMap cardInformationAll = null;
        if (!isNoCardInformationCache && cardInformationCache.isKeyInCache((ICacheKey)(key = new UserCacheKey(userId)))) {
            cardInformationAll = (HashMap)cardInformationCache.get((ICacheKey)key);
        }
        return cardInformationAll;
    }

    private HashMap getCardInformationFromDB(IEntity userProfile, String userId) throws IdASException, UserProfileException, CardException, URISyntaxException {
        HashMap<CUID, CardInformation> cardInformation = new HashMap<CUID, CardInformation>();
        IAttribute attCUR = userProfile.getAttribute(IdasCtxUris.UP_cardInformation);
        Iterator valsCUR = attCUR.getValues();
        while (valsCUR.hasNext()) {
            IValue valCUR = (IValue)valsCUR.next();
            if (!valCUR.isSimple()) {
                IEntity cardInfoVal = (IEntity)valCUR;
                CUID cuid = new CUID((String)IdasUtils.getSimpleValueData((IHasAttributes)cardInfoVal, IdasCtxUris.CC_cuid));
                CardInformation ci = new CardInformation();
                ci.setCuid(cuid);
                ci.setCardCredential(this.getCardCredential(cardInfoVal));
                cardInformation.put(cuid, ci);
                continue;
            }
            throw new UserProfileException("Complex value expected, but found " + valCUR.getType().toString());
        }
        if (!isNoCardInformationCache) {
            UserCacheKey key = new UserCacheKey(userId);
            cardInformationCache.put((ICacheKey)key, cardInformation);
        }
        return cardInformation;
    }

    private HashMap getUseAlways(IEntity userProfile, String userId) throws IdASException, UserProfileException, CardException {
        HashMap useAlways = this.getUseAlwaysFromCache(userId);
        if (useAlways == null) {
            useAlways = this.getUseAlwaysFromDB(userProfile, userId);
        }
        return useAlways;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap getUseAlways(String userId) throws UserProfileException {
        HashMap useAlways = this.getUseAlwaysFromCache(userId);
        if (useAlways != null) return useAlways;
        IContext context = null;
        try {
            try {
                context = this.getContext();
                IEntity userProfile = this.getUserProfileEntity((Serializable)((Object)userId), context);
                useAlways = this.getUseAlwaysFromDB(userProfile, userId.toString());
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeContext(context);
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.closeContext(context);
            return useAlways;
        }
    }

    private HashMap getUseAlwaysFromCache(String userId) {
        UserCacheKey key;
        HashMap useAlwaysMap = null;
        if (!isNoUseAlwaysCache && useAlwaysCache.isKeyInCache((ICacheKey)(key = new UserCacheKey(userId)))) {
            useAlwaysMap = (HashMap)useAlwaysCache.get((ICacheKey)key);
        }
        return useAlwaysMap;
    }

    private HashMap getUseAlwaysFromDB(IEntity dsUserProfile, String userId) throws IdASException, UserProfileException, CardException {
        HashMap<WebForm, CUID> useAlways = new HashMap<WebForm, CUID>();
        IAttribute attUA = dsUserProfile.getAttribute(IdasCtxUris.UP_useAlways);
        Iterator valsUA = attUA.getValues();
        while (valsUA.hasNext()) {
            IValue valUA = (IValue)valsUA.next();
            if (!valUA.isSimple()) {
                IEntity cv = (IEntity)valUA;
                WebForm wf = new WebForm();
                wf.setUrl((URI)IdasUtils.getSimpleValueData((IHasAttributes)cv, IdasCtxUris.CU_url));
                wf.setFormAction((String)IdasUtils.getSimpleValueData((IHasAttributes)cv, IdasCtxUris.CU_formAction));
                wf.setFormId((String)IdasUtils.getSimpleValueData((IHasAttributes)cv, IdasCtxUris.CU_formId));
                wf.setFormName((String)IdasUtils.getSimpleValueData((IHasAttributes)cv, IdasCtxUris.CU_formName));
                useAlways.put(wf, new CUID((String)IdasUtils.getSimpleValueData((IHasAttributes)cv, IdasCtxUris.CC_cuid)));
                continue;
            }
            throw new UserProfileException("Complex value expected, but simple found " + valUA.getType().toString());
        }
        if (!isNoUseAlwaysCache) {
            UserCacheKey key = new UserCacheKey(userId);
            useAlwaysCache.put((ICacheKey)key, useAlways);
        }
        return useAlways;
    }

    private IEntity getUserProfileEntity(Serializable userId, IContext context) throws IdASException, UserProfileException {
        String id = userId.toString();
        IEntity ds = context.getEntity(id);
        if (ds == null) {
            throw new NoSuchEntityException("User not found by Id = " + userId);
        }
        URI type = ds.getModel().getType();
        if (!IdasCtxUris.UP_UserProfile.equals(type)) {
            throw new UserProfileException("Unexpected type of user profile entity:" + type.toString());
        }
        return ds;
    }

    private IEntity getOrCreateCardInformationValue(IAttribute cardInfo, CUID cuid) throws Exception {
        IEntity valCCI = this.getCardInformationValue(cardInfo, cuid);
        if (valCCI == null) {
            valCCI = cardInfo.addComplexValue(null);
            valCCI.getSingleValuedAttribute(IdasCtxUris.CC_cuid).addSimpleValue(null, (Object)cuid.toString());
        }
        return valCCI;
    }

    private IEntity getCardInformationValue(IAttribute cardInfo, CUID cuid) throws IdASException, UserProfileException {
        Iterator valsCCI = cardInfo.getValues();
        IEntity valCCI = null;
        while (valsCCI.hasNext()) {
            IValue val = (IValue)valsCCI.next();
            if (!val.isSimple()) {
                String cuidFound = (String)IdasUtils.getSimpleValueData((IHasAttributes)((IEntity)val), IdasCtxUris.CC_cuid);
                if (!cuidFound.equals(cuid.toString())) continue;
                valCCI = (IEntity)val;
                break;
            }
            throw new UserProfileException("Complex value expected, but simple found " + val.getType().toString());
        }
        return valCCI;
    }

    private CardUsage saveHistoryEvent(IAttribute cardUsageAttr, CUID cuid, URI uri) throws Exception {
        CardUsage cardUsage = new CardUsage();
        cardUsage.setCuid(cuid);
        cardUsage.setSite(uri);
        cardUsage.setDate(new Date());
        return cardUsage;
    }

    private CardUsage saveHistoryEvent(IAttribute cardUsageAttr, CUID cuid, WebForm form) throws Exception {
        CardUsage cardUsage = new CardUsage();
        cardUsage.setCuid(cuid);
        cardUsage.setForm(form);
        cardUsage.setDate(new Date());
        return cardUsage;
    }

    private CardUsage updateUsageSummary(CardUsage cardUsage, IEntity userProfile, String userId) throws UserProfileException, IdASException, CardException {
        IValue val;
        CUID cuid = cardUsage.getCuid();
        WebForm webForm = cardUsage.getForm();
        if (cuid == null || webForm == null) {
            throw new UserProfileException("Both cuid and form parameters must be set for usage summary");
        }
        if (webForm.getUrl() == null) {
            throw new UserProfileException("At least Web Form Url parameter must be set for usage summary");
        }
        HashSet cardUrlRelationsAll = this.getCardUrlRelation(userProfile, userId);
        CardUrlRelation cuAdded = new CardUrlRelation();
        cuAdded.setCuid(cuid);
        cuAdded.setForm(webForm);
        cuAdded.setLastUsed(cardUsage.getDate());
        IAttribute attCUR = userProfile.getAttribute(IdasCtxUris.UP_cardUrlRelation);
        if (cardUrlRelationsAll.add(cuAdded)) {
            IEntity valCUR = attCUR.addComplexValue(null);
            valCUR.getSingleValuedAttribute(IdasCtxUris.CC_cuid).addSimpleValue(null, (Object)cuAdded.getCuid().toString());
            valCUR.getSingleValuedAttribute(IdasCtxUris.CU_url).addSimpleValue(null, (Object)cuAdded.getForm().getUrl());
            valCUR.getSingleValuedAttribute(IdasCtxUris.CU_formName).addSimpleValue(null, (Object)cuAdded.getForm().getFormName());
            valCUR.getSingleValuedAttribute(IdasCtxUris.CU_formId).addSimpleValue(null, (Object)cuAdded.getForm().getFormId());
            valCUR.getSingleValuedAttribute(IdasCtxUris.CU_formAction).addSimpleValue(null, (Object)cuAdded.getForm().getFormAction());
            valCUR.getSingleValuedAttribute(IdasCtxUris.CU_lastUsed).addSimpleValue(null, (Object)cuAdded.getLastUsed());
        } else {
            Iterator it = cardUrlRelationsAll.iterator();
            while (it.hasNext()) {
                CardUrlRelation cur = (CardUrlRelation)it.next();
                if (!cuAdded.equals((Object)cur) || cuAdded.getLastUsed() == null) continue;
                cur.setLastUsed(cuAdded.getLastUsed());
            }
            Iterator valsCUR = attCUR.getValues();
            CardUrlRelation cu = new CardUrlRelation();
            while (valsCUR.hasNext()) {
                val = (IValue)valsCUR.next();
                if (!val.isSimple()) {
                    cu.setCuid(new CUID((String)IdasUtils.getSimpleValueData((IHasAttributes)((IEntity)val), IdasCtxUris.CC_cuid)));
                    WebForm wf = new WebForm((URI)IdasUtils.getSimpleValueData((IHasAttributes)((IEntity)val), IdasCtxUris.CU_url), (String)IdasUtils.getSimpleValueData((IHasAttributes)((IEntity)val), IdasCtxUris.CU_formName), (String)IdasUtils.getSimpleValueData((IHasAttributes)((IEntity)val), IdasCtxUris.CU_formId), (String)IdasUtils.getSimpleValueData((IHasAttributes)((IEntity)val), IdasCtxUris.CU_formAction));
                    cu.setForm(wf);
                    if (!cuAdded.equals((Object)cu) || cuAdded.getLastUsed() == null) continue;
                    IEntity cVal = (IEntity)val;
                    cVal.getSingleValuedAttribute(IdasCtxUris.CU_lastUsed).addSimpleValue(null, (Object)cuAdded.getLastUsed());
                    break;
                }
                throw new UserProfileException("Complex value expected, but simple found " + val.getType().toString());
            }
        }
        if (cardUsage.getUseAlways() != null) {
            IEntity val2;
            HashMap useAlways = this.getUseAlways(userProfile, userId);
            if (cardUsage.getUseAlways().booleanValue()) {
                if (useAlways.containsKey(webForm)) {
                    CUID oldCuid = (CUID)useAlways.get(webForm);
                    if (!cuid.equals((Object)oldCuid)) {
                        val = this.getUseAlwaysValue(userProfile, webForm);
                        val.getSingleValuedAttribute(IdasCtxUris.CC_cuid).addSimpleValue(null, (Object)cuid.toString());
                    }
                } else {
                    val2 = userProfile.getAttribute(IdasCtxUris.UP_useAlways).addComplexValue(null);
                    val2.getSingleValuedAttribute(IdasCtxUris.CC_cuid).addSimpleValue(null, (Object)cuid.toString());
                    val2.getSingleValuedAttribute(IdasCtxUris.CU_url).addSimpleValue(null, (Object)webForm.getUrl());
                    val2.getSingleValuedAttribute(IdasCtxUris.CU_formAction).addSimpleValue(null, (Object)webForm.getFormAction());
                    val2.getSingleValuedAttribute(IdasCtxUris.CU_formId).addSimpleValue(null, (Object)webForm.getFormId());
                    val2.getSingleValuedAttribute(IdasCtxUris.CU_formName).addSimpleValue(null, (Object)webForm.getFormName());
                }
                useAlways.put(webForm, cuid);
            } else if (useAlways.containsKey(webForm)) {
                val2 = this.getUseAlwaysValue(userProfile, webForm);
                val2.remove();
                useAlways.remove(cuAdded.getForm());
            }
        }
        return cardUsage;
    }

    private IEntity getUseAlwaysValue(IEntity userProfile, WebForm webForm) throws IdASException {
        IAttribute attUA = userProfile.getAttribute(IdasCtxUris.UP_useAlways);
        Iterator valsUA = attUA.getValues();
        while (valsUA.hasNext()) {
            IEntity valUA = (IEntity)valsUA.next();
            WebForm wf = new WebForm();
            wf.setUrl((URI)IdasUtils.getSimpleValueData((IHasAttributes)valUA, IdasCtxUris.CU_url));
            wf.setFormAction((String)IdasUtils.getSimpleValueData((IHasAttributes)valUA, IdasCtxUris.CU_formAction));
            wf.setFormId((String)IdasUtils.getSimpleValueData((IHasAttributes)valUA, IdasCtxUris.CU_formId));
            wf.setFormName((String)IdasUtils.getSimpleValueData((IHasAttributes)valUA, IdasCtxUris.CU_formName));
            if (!wf.equals((Object)webForm)) continue;
            return valUA;
        }
        return null;
    }

    public CardUsage addCardHistory(Serializable userId, CUID cuid, URI uri) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (cuid == null || uri == null) {
            throw new UserProfileException("Both cuid and site must not be null.");
        }
        IContext context = null;
        try {
            context = this.getContext();
            IEntity up = this.getUserProfileEntity(userId, context);
            IAttribute cardInfo = up.getAttribute(IdasCtxUris.UP_cardInformation);
            this.getOrCreateCardInformationValue(cardInfo, cuid);
            IAttribute attCardUsage = null;
            CardUsage cu = this.saveHistoryEvent(attCardUsage, cuid, uri);
            cu = this.updateUsageSummary(cu, up, userId.toString());
            context.applyUpdates();
            CardUsage cardUsage = cu;
            Object var9_11 = null;
            this.closeContext(context);
            return cardUsage;
        }
        catch (Exception e) {
            try {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                this.closeContext(context);
                throw throwable;
            }
        }
    }

    public CardUsage addCardHistory(Serializable userId, CUID cuid, WebForm form) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (cuid == null || form == null) {
            throw new UserProfileException("Both cuid and site must not be null.");
        }
        IContext context = null;
        try {
            context = this.getContext();
            IEntity up = this.getUserProfileEntity(userId, context);
            IAttribute cardInfo = up.getAttribute(IdasCtxUris.UP_cardInformation);
            this.getOrCreateCardInformationValue(cardInfo, cuid);
            IAttribute attCardUsage = null;
            CardUsage cu = this.saveHistoryEvent(attCardUsage, cuid, form);
            cu = this.updateUsageSummary(cu, up, userId.toString());
            context.applyUpdates();
            CardUsage cardUsage = cu;
            Object var9_11 = null;
            this.closeContext(context);
            return cardUsage;
        }
        catch (Exception e) {
            try {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                this.closeContext(context);
                throw throwable;
            }
        }
    }

    private void clearCardUsageInDB(IEntity userProfile, CUID cuid) throws IdASException, UserProfileException {
        IAttribute cardInfo = userProfile.getAttribute(IdasCtxUris.UP_cardInformation);
        IEntity cardInfoValue = this.getCardInformationValue(cardInfo, cuid);
    }

    private void clearCardUrlRelationInDB(IEntity userProfile, String userId, CUID cuid, WebForm webForm) throws IdASException, UserProfileException, CardException {
        String cuidStr = cuid.toString();
        HashMap useAlways = this.getUseAlways(userProfile, userId);
        IAttribute attCUR = userProfile.getAttribute(IdasCtxUris.UP_cardUrlRelation);
        Iterator valsCUR = attCUR.getValues();
        while (valsCUR.hasNext()) {
            IValue val = (IValue)valsCUR.next();
            if (!val.isSimple()) {
                IEntity cvCUR = (IEntity)val;
                String cuidVal = (String)IdasUtils.getSimpleValueData((IHasAttributes)cvCUR, IdasCtxUris.CC_cuid);
                if (!cuidStr.equals(cuidVal)) continue;
                URI url = (URI)IdasUtils.getSimpleValueData((IHasAttributes)cvCUR, IdasCtxUris.CU_url);
                String formName = (String)IdasUtils.getSimpleValueData((IHasAttributes)cvCUR, IdasCtxUris.CU_formName);
                String formId = (String)IdasUtils.getSimpleValueData((IHasAttributes)cvCUR, IdasCtxUris.CU_formId);
                String formAction = (String)IdasUtils.getSimpleValueData((IHasAttributes)cvCUR, IdasCtxUris.CU_formAction);
                WebForm wf = new WebForm(url, formName, formId, formAction);
                if (webForm != null && !webForm.equals((Object)wf)) continue;
                CUID thisSiteCard = (CUID)useAlways.get(wf);
                if (thisSiteCard == null || !thisSiteCard.equals((Object)cuid)) {
                    cvCUR.remove();
                    continue;
                }
                cvCUR.getAttribute(IdasCtxUris.CU_lastUsed).remove();
                continue;
            }
            throw new UserProfileException("Complex value expected, but simple found " + val.getType().toString());
        }
    }

    private void clearCardUrlRelationInCache(String userId, CUID cuid, WebForm webForm) throws IdASException, UserProfileException, CardException {
        HashSet cardUrlRelation = this.getCardUrlRelationFromCache(userId);
        if (cardUrlRelation != null) {
            HashMap useAlways = this.getUseAlwaysFromCache(userId);
            Iterator valsCUR = cardUrlRelation.iterator();
            while (valsCUR.hasNext()) {
                CardUrlRelation cur = (CardUrlRelation)valsCUR.next();
                CUID cuidVal = cur.getCuid();
                if (!cuid.equals((Object)cuidVal)) continue;
                WebForm wf = cur.getForm();
                if (webForm != null && !webForm.equals((Object)wf)) continue;
                CUID thisSiteCard = (CUID)useAlways.get(wf);
                if (thisSiteCard == null || !thisSiteCard.equals((Object)cuid)) {
                    valsCUR.remove();
                    continue;
                }
                cur.setLastUsed(null);
            }
        }
    }

    private void setOptionalClaimsInDB(WebForm form, Set optionalClaims, CUID cuid, IEntity userProfile, String userId) throws UserProfileException, IdASException, CardException {
        this.updateUsageSummary(new CardUsage(cuid, form, null, null), userProfile, userId);
        IAttribute attCUR = userProfile.getAttribute(IdasCtxUris.UP_cardUrlRelation);
        Iterator valsCUR = attCUR.getValues();
        String cuidStr = cuid.toString();
        while (valsCUR.hasNext()) {
            String formAction;
            String formId;
            String formName;
            URI url;
            WebForm itrForm;
            IEntity valCUR = (IEntity)valsCUR.next();
            String cuidVal = (String)IdasUtils.getSimpleValueData((IHasAttributes)valCUR, IdasCtxUris.CC_cuid);
            if (!cuidStr.equals(cuidVal) || !form.equals((Object)(itrForm = new WebForm(url = (URI)IdasUtils.getSimpleValueData((IHasAttributes)valCUR, IdasCtxUris.CU_url), formName = (String)IdasUtils.getSimpleValueData((IHasAttributes)valCUR, IdasCtxUris.CU_formName), formId = (String)IdasUtils.getSimpleValueData((IHasAttributes)valCUR, IdasCtxUris.CU_formId), formAction = (String)IdasUtils.getSimpleValueData((IHasAttributes)valCUR, IdasCtxUris.CU_formAction))))) continue;
            IAttribute attOC = valCUR.getAttribute(IdasCtxUris.CU_optionalClaims);
            attOC.remove();
            Iterator it = optionalClaims.iterator();
            while (it.hasNext()) {
                attOC.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)((String)it.next()));
            }
            break block0;
        }
    }

    private void setOptionalClaimsInCache(WebForm form, Set optionalClaims, CUID cuid, IEntity userProfile, String userId) throws UserProfileException, IdASException, CardException {
        HashSet cardUrlRelationsAll = this.getCardUrlRelation(userProfile, userId);
        Iterator it = cardUrlRelationsAll.iterator();
        while (it.hasNext()) {
            CardUrlRelation cur = (CardUrlRelation)it.next();
            if (!cuid.equals((Object)cur.getCuid()) || !form.equals((Object)cur.getForm())) continue;
            cur.setOptionalClaims(optionalClaims);
            break;
        }
    }

    private void setOptionalClaims(WebForm form, Set optionalClaims, CUID cuid, IEntity userProfile, String userId) throws UserProfileException, IdASException, CardException {
        this.setOptionalClaimsInDB(form, optionalClaims, cuid, userProfile, userId);
        this.setOptionalClaimsInCache(form, optionalClaims, cuid, userProfile, userId);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearCardHistory(Serializable userId, CUID cuid) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (cuid == null) {
            throw new UserProfileException("Parameter \"cuid\" is null");
        }
        IContext context = null;
        try {
            try {
                context = this.getContext();
                IEntity up = this.getUserProfileEntity(userId, context);
                this.clearCardUsageInDB(up, cuid);
                this.clearCardUrlRelationInDB(up, userId.toString(), cuid, null);
                context.applyUpdates();
                this.clearCardUrlRelationInCache(userId.toString(), cuid, null);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeContext(context);
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.closeContext(context);
            return;
        }
    }

    public void clearCardHistory(Serializable userId, CUID cuid, URI site) throws UserProfileException {
        if (site == null) {
            throw new UserProfileException("Parameter \"site\" is null");
        }
        WebForm wf = new WebForm(site, null, null, null);
        this.clearCardHistory(userId, cuid, wf);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearCardHistory(Serializable userId, CUID cuid, WebForm form) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (cuid == null) {
            throw new UserProfileException("Parameter \"cuid\" is null");
        }
        if (form == null) {
            throw new UserProfileException("Parameter \"form\" is null");
        }
        IContext context = null;
        try {
            try {
                context = this.getContext();
                IEntity up = this.getUserProfileEntity(userId, context);
                this.clearCardUsageInDB(up, cuid);
                this.clearCardUrlRelationInDB(up, userId.toString(), cuid, form);
                context.applyUpdates();
                this.clearCardUrlRelationInCache(userId.toString(), cuid, form);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.closeContext(context);
            throw throwable;
        }
        {
            Object var6_9 = null;
            this.closeContext(context);
            return;
        }
    }

    private void clearUsedAlwaysFromDB(IEntity userProfile, CUID cuid) throws IdASException, CardException, UserProfileException {
        IAttribute attUA = userProfile.getAttribute(IdasCtxUris.UP_useAlways);
        Iterator valsUA = attUA.getValues();
        while (valsUA.hasNext()) {
            IValue valUA = (IValue)valsUA.next();
            if (!valUA.isSimple()) {
                IEntity cv = (IEntity)valUA;
                String cuidStr = (String)IdasUtils.getSimpleValueData((IHasAttributes)cv, IdasCtxUris.CC_cuid);
                CUID cuidVal = new CUID(cuidStr);
                if (!cuid.equals((Object)cuidVal)) continue;
                cv.remove();
                continue;
            }
            throw new UserProfileException("Complex value expected, but simple found " + valUA.getType().toString());
        }
    }

    private void clearUsedAlwaysInCache(IEntity userProfile, String userId, CUID cuid) throws IdASException, CardException, UserProfileException {
        HashMap useAlways = this.getUseAlways(userProfile, userId);
        Iterator it = useAlways.values().iterator();
        while (it.hasNext()) {
            CUID cuidVal = (CUID)it.next();
            if (!cuid.equals((Object)cuidVal)) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearUsedAlwaysURLs(Serializable userId, CUID cuid) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (cuid == null) {
            throw new UserProfileException("Parameter \"cuid\" is null");
        }
        IContext context = null;
        try {
            try {
                context = this.getContext();
                IEntity up = this.getUserProfileEntity(userId, context);
                this.clearUsedAlwaysFromDB(up, cuid);
                context.applyUpdates();
                this.clearUsedAlwaysInCache(up, userId.toString(), cuid);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeContext(context);
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.closeContext(context);
            return;
        }
    }

    public CardUsage deleteUsedAlways(Serializable userId, CUID cuid, URI uri) throws UserProfileException {
        if (uri == null) {
            throw new UserProfileException("Parameter \"form\" is null");
        }
        WebForm wf = new WebForm(uri, null, null, null);
        return this.deleteUsedAlways(userId, cuid, wf);
    }

    public CardUsage deleteUsedAlways(Serializable userId, CUID cuid, WebForm form) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (cuid == null) {
            throw new UserProfileException("Parameter \"cuid\" is null");
        }
        if (form == null) {
            throw new UserProfileException("Parameter \"form\" is null");
        }
        IContext context = null;
        try {
            context = this.getContext();
            IEntity userProfile = this.getUserProfileEntity(userId, context);
            CardUsage cardUsage = new CardUsage(cuid, form, null, Boolean.FALSE);
            cardUsage = this.updateUsageSummary(cardUsage, userProfile, userId.toString());
            context.applyUpdates();
            CardUsage cardUsage2 = cardUsage;
            Object var7_9 = null;
            this.closeContext(context);
            return cardUsage2;
        }
        catch (Exception e) {
            try {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.closeContext(context);
                throw throwable;
            }
        }
    }

    private List getCardHistoryFromCardInfo(CardInformation ci) {
        ArrayList res = new ArrayList();
        return res;
    }

    public List getCardHistory(Serializable userId, CUID cuid) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (cuid == null) {
            throw new UserProfileException("Parameter \"cuid\" is null");
        }
        HashMap ciMap = this.getCardInformation(userId.toString());
        if (ciMap.containsKey(cuid)) {
            return this.getCardHistoryFromCardInfo((CardInformation)ciMap.get(cuid));
        }
        return Collections.EMPTY_LIST;
    }

    public List getCardHistory(Serializable userId, CUID cuid, int startFrom, int size, String orderBy, boolean desc) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (cuid == null) {
            throw new UserProfileException("Parameter \"cuid\" is null");
        }
        int to = startFrom + size;
        List historyList = this.getCardHistory(userId, cuid);
        int fullSize = historyList.size();
        if (to > fullSize) {
            to = fullSize;
        }
        Collections.sort(historyList, new CardUsageComparator(orderBy, desc));
        return historyList.subList(startFrom, to);
    }

    private CardUsage cardUsageFromCUR(CardUrlRelation cur, String userId) throws UserProfileException {
        CardUsage cu = new CardUsage();
        cu.setCuid(cur.getCuid());
        cu.setForm(cur.getForm());
        cu.setDate(cur.getLastUsed());
        HashMap useAlways = this.getUseAlways(userId);
        CUID thisSiteCard = (CUID)useAlways.get(cur.getForm());
        cu.setUseAlways(new Boolean(thisSiteCard != null && thisSiteCard.equals((Object)cur.getCuid())));
        return cu;
    }

    public List getCardUsageSummary(Serializable userId, CUID cuid) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (cuid == null) {
            throw new UserProfileException("Parameter \"cuid\" is null");
        }
        String userIdStr = userId.toString();
        HashSet setCUR = this.getCardUrlRelation(userIdStr);
        ArrayList<CardUsage> result = new ArrayList<CardUsage>();
        Iterator it = setCUR.iterator();
        while (it.hasNext()) {
            CardUrlRelation cur = (CardUrlRelation)it.next();
            if (!cuid.equals((Object)cur.getCuid())) continue;
            result.add(this.cardUsageFromCUR(cur, userIdStr));
        }
        return result;
    }

    public List getCardUsageSummary(Serializable userId, CUID cuid, int startFrom, int size, String orderBy, boolean desc) throws UserProfileException {
        int to = startFrom + size;
        List summaryList = this.getCardUsageSummary(userId, cuid);
        int fullSize = summaryList.size();
        if (to > fullSize) {
            to = fullSize;
        }
        if (size == -1) {
            startFrom = 0;
            to = fullSize;
        }
        Collections.sort(summaryList, new CardUsageComparator(orderBy, desc));
        return summaryList.subList(startFrom, to);
    }

    public int getHistoryTotalSize(Serializable userId, CUID cuid) throws UserProfileException {
        return this.getCardHistory(userId, cuid).size();
    }

    public Set getOptionalClaims(Serializable userId, CUID cuid, URI site) throws UserProfileException {
        return this.getOptionalClaims(userId, cuid, new WebForm(site, null, null, null));
    }

    public Set getOptionalClaims(Serializable userId, CUID cuid, WebForm form) throws UserProfileException {
        HashSet setCUR = this.getCardUrlRelation(userId.toString());
        Iterator it = setCUR.iterator();
        while (it.hasNext()) {
            CardUrlRelation cur = (CardUrlRelation)it.next();
            if (!cuid.equals((Object)cur.getCuid()) || !form.equals((Object)cur.getForm())) continue;
            return cur.getOptionalClaims();
        }
        return null;
    }

    public int getSummaryTotalSize(Serializable userId, CUID cuid) throws UserProfileException {
        int size = 0;
        HashSet setCUR = this.getCardUrlRelation(userId.toString());
        Iterator it = setCUR.iterator();
        while (it.hasNext()) {
            CardUrlRelation cur = (CardUrlRelation)it.next();
            if (!cuid.equals((Object)cur.getCuid())) continue;
            ++size;
        }
        return size;
    }

    public CUID getUsedAlwaysCard(Serializable userId, URI uri) throws UserProfileException {
        return this.getUsedAlwaysCard(userId, new WebForm(uri, null, null, null));
    }

    public CUID getUsedAlwaysCard(Serializable userId, WebForm form) throws UserProfileException {
        HashMap useAlways = this.getUseAlways(userId.toString());
        return (CUID)useAlways.get(form);
    }

    public List getUsedAlwaysURLs(Serializable userId, CUID cuid) throws UserProfileException {
        ArrayList<CardUsage> result = new ArrayList<CardUsage>();
        HashSet setCUR = this.getCardUrlRelation(userId.toString());
        Iterator itCUR = setCUR.iterator();
        while (itCUR.hasNext()) {
            CardUsage cu;
            CardUrlRelation cur = (CardUrlRelation)itCUR.next();
            if (!cuid.equals((Object)cur.getCuid()) || !(cu = this.cardUsageFromCUR(cur, userId.toString())).getUseAlways().booleanValue()) continue;
            result.add(cu);
        }
        return result;
    }

    public List getUsedCards(Serializable userId, URI uri) throws UserProfileException {
        return this.getUsedCards(userId, new WebForm(uri, null, null, null));
    }

    public List getUsedCards(Serializable userId, WebForm form) throws UserProfileException {
        ArrayList<CardUsage> result = new ArrayList<CardUsage>();
        HashSet setCUR = this.getCardUrlRelation(userId.toString());
        Iterator itCUs = setCUR.iterator();
        while (itCUs.hasNext()) {
            CardUrlRelation cur = (CardUrlRelation)itCUs.next();
            if (!cur.getForm().equals((Object)form)) continue;
            result.add(this.cardUsageFromCUR(cur, userId.toString()));
        }
        return result;
    }

    public void setOptionalClaims(Serializable userId, CUID cuid, URI site, Set optionalClaims) throws UserProfileException {
        WebForm form = new WebForm(site, null, null, null);
        this.setOptionalClaims(userId, cuid, form, optionalClaims);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setOptionalClaims(Serializable userId, CUID cuid, WebForm form, Set optionalClaims) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (cuid == null) {
            throw new UserProfileException("Parameter \"cuid\" is null");
        }
        if (form == null) {
            throw new UserProfileException("Parameter \"form\" is null");
        }
        IContext context = null;
        try {
            try {
                context = this.getContext();
                IEntity userProfile = this.getUserProfileEntity(userId, context);
                this.setOptionalClaims(form, optionalClaims, cuid, userProfile, userId.toString());
                context.applyUpdates();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeContext(context);
            throw throwable;
        }
        {
            Object var7_10 = null;
            this.closeContext(context);
            return;
        }
    }

    public CardUsage setUsedAlways(Serializable userId, CUID cuid, URI uri) throws UserProfileException {
        if (uri == null) {
            throw new UserProfileException("Parameter \"uri\" is null");
        }
        WebForm form = new WebForm(uri, null, null, null);
        return this.setUsedAlways(userId, cuid, form);
    }

    public CardUsage setUsedAlways(Serializable userId, CUID cuid, WebForm form) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (cuid == null) {
            throw new UserProfileException("Parameter \"cuid\" is null");
        }
        if (form == null) {
            throw new UserProfileException("Parameter \"form\" is null");
        }
        IContext context = null;
        try {
            context = this.getContext();
            IEntity up = this.getUserProfileEntity(userId, context);
            CardUsage cardUsage = new CardUsage(cuid, form, null, Boolean.TRUE);
            cardUsage = this.updateUsageSummary(cardUsage, up, userId.toString());
            context.applyUpdates();
            CardUsage cardUsage2 = cardUsage;
            Object var7_9 = null;
            this.closeContext(context);
            return cardUsage2;
        }
        catch (Exception e) {
            try {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.closeContext(context);
                throw throwable;
            }
        }
    }

    public Map getClaimValuesMRU(Serializable userId) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        IContext context = null;
        HashMap res = new HashMap();
        try {
            context = this.getContext();
            IEntity up = this.getUserProfileEntity(userId, context);
            IAttribute attCV = up.getAttribute(IdasCtxUris.UP_claimValuesMRU);
            Iterator itValsCV = attCV.getValues();
            while (itValsCV.hasNext()) {
                IValue valCV = (IValue)itValsCV.next();
                if (!valCV.isSimple()) {
                    String claimType = (String)IdasUtils.getSimpleValueData((IHasAttributes)((IEntity)valCV), IdasCtxUris.CU_claimType);
                    IAttribute attMRUValues = ((IEntity)valCV).getAttribute(IdasCtxUris.CU_claimValue);
                    Iterator itMRUValues = attMRUValues.getValues();
                    HashSet<String> resValues = new HashSet<String>();
                    while (itMRUValues.hasNext()) {
                        ISimpleValue val = (ISimpleValue)itMRUValues.next();
                        String sVal = (String)val.getData();
                        resValues.add(sVal);
                    }
                    res.put(claimType, resValues);
                    continue;
                }
                throw new UserProfileException("Attribute " + (attCV.getType() != null ? attCV.getType().toString() : "") + " contains simple value");
            }
            HashMap hashMap = res;
            Object var14_16 = null;
            this.closeContext(context);
            return hashMap;
        }
        catch (Exception e) {
            try {
                log.error((Object)e, (Throwable)e);
                throw new UserProfileException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                this.closeContext(context);
                throw throwable;
            }
        }
    }

    public Set getClaimValuesMRU(Serializable userId, String claimType) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (claimType == null) {
            throw new UserProfileException("Parameter \"claimType\" is null");
        }
        IContext context = null;
        HashSet<String> resValues = new HashSet<String>();
        try {
            context = this.getContext();
            IEntity up = this.getUserProfileEntity(userId, context);
            IAttribute attCV = up.getAttribute(IdasCtxUris.UP_claimValuesMRU);
            Iterator itValsCV = attCV.getValues();
            while (itValsCV.hasNext()) {
                IValue valCV = (IValue)itValsCV.next();
                if (!valCV.isSimple()) {
                    if (!claimType.equals((String)IdasUtils.getSimpleValueData((IHasAttributes)((IEntity)valCV), IdasCtxUris.CU_claimType))) continue;
                    IAttribute attMRUValues = ((IEntity)valCV).getAttribute(IdasCtxUris.CU_claimValue);
                    Iterator itMRUValues = attMRUValues.getValues();
                    while (itMRUValues.hasNext()) {
                        ISimpleValue val = (ISimpleValue)itMRUValues.next();
                        String sVal = (String)val.getData();
                        resValues.add(sVal);
                    }
                    break;
                }
                throw new UserProfileException("Attribute " + (attCV.getType() != null ? attCV.getType().toString() : "") + " contains simple value");
            }
            HashSet<String> hashSet = resValues;
            Object var13_15 = null;
            this.closeContext(context);
            return hashSet;
        }
        catch (Exception e) {
            try {
                log.error((Object)e, (Throwable)e);
                throw new UserProfileException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                this.closeContext(context);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClaimValuesMRU(Serializable userId, String claimType, Set claimValues) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (claimType == null) {
            throw new UserProfileException("Parameter \"claimType\" is null");
        }
        IContext context = null;
        try {
            try {
                block14: {
                    Iterator itMRUValues;
                    IAttribute attMRUValues;
                    block15: {
                        String string;
                        IAttribute attCV;
                        block16: {
                            IEntity valCV;
                            context = this.getContext();
                            IEntity up = this.getUserProfileEntity(userId, context);
                            attCV = up.getAttribute(IdasCtxUris.UP_claimValuesMRU);
                            Iterator itValsCV = attCV.getValues();
                            do {
                                if (!itValsCV.hasNext()) {
                                    valCV = attCV.addComplexValue(IdasCtxUris.CU_ClaimValuesMRU);
                                    valCV.getAttribute(IdasCtxUris.CU_claimType).addSimpleValue(null, (Object)claimType);
                                    if (claimValues == null) break block14;
                                    attMRUValues = valCV.getAttribute(IdasCtxUris.CU_claimValue);
                                    itMRUValues = claimValues.iterator();
                                    break block15;
                                }
                                valCV = (IValue)itValsCV.next();
                                if (valCV.isSimple()) break block16;
                            } while (!claimType.equals((String)IdasUtils.getSimpleValueData((IHasAttributes)valCV, IdasCtxUris.CU_claimType)));
                            IAttribute attMRUValues2 = valCV.getAttribute(IdasCtxUris.CU_claimValue);
                            attMRUValues2.remove();
                            if (claimValues != null && claimValues.size() > 0) {
                                Iterator itMRUValues2 = claimValues.iterator();
                                while (itMRUValues2.hasNext()) {
                                    attMRUValues2.addSimpleValue(null, (Object)((String)itMRUValues2.next()));
                                }
                            } else {
                                valCV.remove();
                            }
                            context.applyUpdates();
                            Object var11_14 = null;
                            this.closeContext(context);
                            return;
                        }
                        StringBuffer stringBuffer = new StringBuffer("Attribute ");
                        if (attCV.getType() != null) {
                            string = attCV.getType().toString();
                            throw new UserProfileException(stringBuffer.append(string).append(" contains simple value").toString());
                        }
                        string = "";
                        throw new UserProfileException(stringBuffer.append(string).append(" contains simple value").toString());
                    }
                    while (itMRUValues.hasNext()) {
                        attMRUValues.addSimpleValue(null, (Object)((String)itMRUValues.next()));
                    }
                }
                context.applyUpdates();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            this.closeContext(context);
            throw throwable;
        }
        {
            Object var11_16 = null;
            this.closeContext(context);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SelectorClient addSelectorClient(Serializable userId, SelectorClient selectorClient) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        String user = userId.toString();
        if (selectorClient == null) {
            throw new UserProfileException("Parameter \"selectorClient\" is null");
        }
        if (selectorClient.getSerialNumber() == null) {
            throw new UserProfileException("Parameter \"selectorClient\" has null serial number");
        }
        IContext context = null;
        try {
            try {
                context = this.getContext();
                IEntity ds = context.addEntity(IdasCtxUris.UP_SelectorClient, null);
                ds.getAttribute(IdasCtxUris.UP_userIdentifier).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)user);
                this.saveSelectorClient(selectorClient, ds);
                context.applyUpdates();
                this.addSelectorClientToCache(user, selectorClient);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.closeContext(context);
            throw throwable;
        }
        {
            Object var6_9 = null;
            this.closeContext(context);
            return selectorClient;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteSelectorClient(Serializable userId, String selectorClientId) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (selectorClientId == null) {
            throw new UserProfileException("Parameter \"selectorClientId\" is null");
        }
        IContext context = null;
        try {
            try {
                String uidPassed = userId.toString();
                context = this.getContext();
                IEntity ds = context.getEntity(selectorClientId);
                String uidFound = (String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_userIdentifier);
                if (!uidPassed.equals(uidFound)) {
                    throw new UserProfileException("Category " + selectorClientId + " does not belong to the user with Id = " + uidPassed);
                }
                ds.remove();
                context.applyUpdates();
                this.removeSelectorClientFromCache(uidPassed, selectorClientId);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeContext(context);
            throw throwable;
        }
        {
            Object var7_10 = null;
            this.closeContext(context);
            return;
        }
    }

    public List getSelectorClients(Serializable userId) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        HashMap scMap = this.getSelectorClient(userId.toString());
        return new ArrayList(scMap.values());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SelectorClient modifySelectorClient(Serializable userId, SelectorClient selectorClient) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null");
        }
        if (selectorClient == null) {
            throw new UserProfileException("Parameter \"selectorClient\" is null");
        }
        String selectorClientId = selectorClient.getId();
        if (selectorClientId == null) {
            throw new IllegalArgumentException("Parameter \"selectorClient\" has null selectorClientId");
        }
        String uidPassed = userId.toString();
        IContext context = null;
        try {
            try {
                context = this.getContext();
                IEntity ds = context.getEntity(selectorClientId);
                if (ds == null) {
                    throw new SelectorClientNotFoundException("SelectorClient \"" + selectorClientId + "\" not found!");
                }
                String uidFound = (String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_userIdentifier);
                if (!uidPassed.equals(uidFound)) {
                    throw new UserProfileException("SelectorClient with Id " + selectorClientId + " does not belong to the user with Id = " + uidPassed);
                }
                this.saveSelectorClient(selectorClient, ds);
                context.applyUpdates();
                this.addSelectorClientToCache(uidPassed, selectorClient);
                SelectorClient selectorClient2 = selectorClient;
                Object var8_11 = null;
                this.closeContext(context);
                return selectorClient2;
            }
            catch (UserProfileException e) {
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(context);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.closeContext(context);
            throw throwable;
        }
    }

    private void saveSelectorClient(SelectorClient selectorClient, IEntity entity) throws Exception {
        selectorClient.setId(entity.getEntityID());
        entity.getAttribute(IdasCtxUris.UP_name).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)selectorClient.getName());
        entity.getAttribute(IdasCtxUris.UP_serialNumber).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)selectorClient.getSerialNumber());
        entity.getAttribute(IdasCtxUris.UP_state).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)selectorClient.getState());
        entity.getAttribute(IdasCtxUris.UP_added).addSimpleValue(ITypedValue.DATETIME_TYPE_URI, (Object)selectorClient.getAdded());
    }

    private SelectorClient initSelectorClient(IEntity entity) throws UserProfileException, IdASException {
        SelectorClient selectorClient = new SelectorClient();
        selectorClient.setId(entity.getEntityID());
        selectorClient.setName((String)IdasUtils.getSimpleValueData((IHasAttributes)entity, IdasCtxUris.UP_name));
        selectorClient.setAdded((Date)IdasUtils.getSimpleValueData((IHasAttributes)entity, IdasCtxUris.UP_added));
        selectorClient.setSerialNumber((String)IdasUtils.getSimpleValueData((IHasAttributes)entity, IdasCtxUris.UP_serialNumber));
        selectorClient.setState((String)IdasUtils.getSimpleValueData((IHasAttributes)entity, IdasCtxUris.UP_state));
        return selectorClient;
    }

    private void removeSelectorClientFromCache(String userId, String selectorClientId) {
        Map scMap;
        UserCacheKey key;
        if (!isNoSelectorClientCache && selectorClientCache.isKeyInCache((ICacheKey)(key = new UserCacheKey(userId))) && (scMap = (Map)selectorClientCache.get((ICacheKey)key)) != null && scMap.containsKey(selectorClientId)) {
            scMap.remove(selectorClientId);
        }
    }

    private void addSelectorClientToCache(String userId, SelectorClient selectorClient) {
        Map scMap;
        UserCacheKey key;
        if (!isNoSelectorClientCache && selectorClientCache.isKeyInCache((ICacheKey)(key = new UserCacheKey(userId))) && (scMap = (Map)selectorClientCache.get((ICacheKey)key)) != null) {
            scMap.put(userId, selectorClient);
        }
    }

    private HashMap getSelectorClient(String userId) throws UserProfileException {
        HashMap mapSC = this.getSelectorClientFromCache(userId);
        if (mapSC == null) {
            mapSC = this.getSelectorClientFromDB(userId);
        }
        return mapSC;
    }

    private HashMap getSelectorClientFromCache(String userId) {
        UserCacheKey key;
        HashMap selectorClientAll = null;
        if (!isNoSelectorClientCache && selectorClientCache.isKeyInCache((ICacheKey)(key = new UserCacheKey(userId)))) {
            selectorClientAll = (HashMap)selectorClientCache.get((ICacheKey)key);
        }
        return selectorClientAll;
    }

    private HashMap getSelectorClientFromDB(String userId) throws UserProfileException {
        HashMap<String, SelectorClient> selectorClientMap = new HashMap<String, SelectorClient>();
        IContext context = null;
        try {
            context = this.getContext();
            IFilter filter = context.buildFilter();
            IFilterAttributeAssertion fas = context.buildAttributeAssertion();
            fas.includeSubtypes(true);
            fas.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
            fas.setID(IdasCtxUris.UP_userIdentifier);
            ISimpleValue val = context.buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, (Object)userId);
            fas.setAssertionValue((IValue)val);
            filter.setAssertion((IFilterAssertion)fas);
            Iterator subjList = context.getEntities(filter);
            while (subjList.hasNext()) {
                IEntity subj = (IEntity)subjList.next();
                if (!IdasCtxUris.UP_SelectorClient.equals(subj.getModel().getType())) continue;
                SelectorClient selectorClient = this.initSelectorClient(subj);
                selectorClientMap.put(selectorClient.getId(), selectorClient);
            }
            if (!isNoSelectorClientCache) {
                UserCacheKey key = new UserCacheKey(userId);
                selectorClientCache.put((ICacheKey)key, selectorClientMap);
            }
            HashMap<String, SelectorClient> hashMap = selectorClientMap;
            Object var10_12 = null;
            this.closeContext(context);
            return hashMap;
        }
        catch (Exception e) {
            try {
                log.error((Object)e, (Throwable)e);
                throw new UserProfileException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                this.closeContext(context);
                throw throwable;
            }
        }
    }
}

