/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.user.login;

import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.user.login.UserAccount;
import org.eclipse.higgins.user.login.exception.ConfigurationException;
import org.eclipse.higgins.user.login.exception.LoginException;
import org.eclipse.higgins.user.login.exception.UserNotFoundException;

public class LoginService
implements IConfigurableComponent {
    private static Log log;
    private Configuration jaasConfig;
    public static final String SERVICE_NAME = "UserLoginService";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.user.login.LoginService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public static LoginService getInstance(Map settings) throws ConfigurationException {
        if (settings.containsKey(SERVICE_NAME)) {
            Object obj = settings.get(SERVICE_NAME);
            if (obj instanceof LoginService) {
                return (LoginService)obj;
            }
            throw new ConfigurationException("UserLoginServicehas unexpected type " + obj.getClass().getName());
        }
        throw new ConfigurationException("UserLoginServicenot found in configuration");
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws Exception {
        Object lmObj = mapComponentSettings.get("LoginModules");
        if (!(lmObj instanceof List)) {
            throw new ConfigurationException("\"LoginModules\" htf:list not found");
        }
        List modules = (List)lmObj;
        AppConfigurationEntry[] entries = new AppConfigurationEntry[modules.size()];
        int i = 0;
        int k = modules.size();
        while (i < k) {
            Object mObj = modules.get(i);
            if (!(mObj instanceof Map)) {
                throw new ConfigurationException("\"LoginModules\" entry should be htf:map type");
            }
            Map module = (Map)mObj;
            String className = (String)module.get("className");
            String controlFlag = (String)module.get("controlFlag");
            Map opts = (Map)module.get("options");
            AppConfigurationEntry.LoginModuleControlFlag flag = this.getFlagByName(controlFlag);
            entries[i] = new AppConfigurationEntry(className, flag, opts);
            ++i;
        }
        this.jaasConfig = new JAASConfig(entries);
    }

    private AppConfigurationEntry.LoginModuleControlFlag getFlagByName(String name) throws ConfigurationException {
        if ("REQUIRED".equalsIgnoreCase(name)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if ("REQUISITE".equalsIgnoreCase(name)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        if ("SUFFICIENT".equalsIgnoreCase(name)) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        if ("OPTIONAL".equalsIgnoreCase(name)) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        throw new ConfigurationException("Unexpected flag \"" + name + "\", should be one of: REQUIRED, REQUISITE, SUFFICIENT, or OPTIONAL");
    }

    public ISettingDescriptor getComponentDescriptor() {
        return null;
    }

    public UserAccount login(CallbackHandler loginHandler) throws LoginException {
        Subject subj;
        if (loginHandler == null) {
            throw new LoginException("Paramether \"loginHandler\" is null");
        }
        LoginContext lc = null;
        try {
            Configuration.setConfiguration(this.jaasConfig);
            subj = new Subject();
            lc = new LoginContext("UserProfile", subj, loginHandler);
        }
        catch (Exception e) {
            throw new LoginException(e);
        }
        try {
            lc.login();
            subj = lc.getSubject();
            return new UserAccount(subj);
        }
        catch (javax.security.auth.login.LoginException e) {
            log.error((Object)e, (Throwable)e);
            throw new UserNotFoundException(e);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new LoginException(e);
        }
    }

    private class JAASConfig
    extends Configuration {
        private AppConfigurationEntry[] entries;

        public JAASConfig(AppConfigurationEntry[] entries) {
            this.entries = entries;
        }

        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return this.entries;
        }

        public void refresh() {
        }
    }
}

