/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 *		Yuriy Pilipenko - API and implementation 
 * 
 */

package org.eclipse.higgins.userprofile.idas;

import java.net.URI;
import java.util.Date;
import java.util.Set;

import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.userprofile.UserProfileException;
import org.eclipse.higgins.userprofile.entity.WebForm;

class CardUrlRelation {
	private CUID cuid;
	private WebForm form;
	private Date lastUsed;
	private Set optionalClaims;
	
	public CUID getCuid() {
		return cuid;
	}
	public void setCuid(CUID cuid) throws UserProfileException {
		if (cuid == null)
			throw new UserProfileException("CardUrlRelation.cuid can not be null!!!");
		this.cuid = cuid;
	}
	
	public Date getLastUsed() {
		return lastUsed;
	}
	public void setLastUsed(Date date) {
		this.lastUsed = date;
	}
	
	public Set getOptionalClaims() {
		return optionalClaims;
	}
	public void setOptionalClaims(Set optionalClaims) {
		this.optionalClaims = optionalClaims;
	}

	public boolean equals(Object obj) {
		if (this == obj) {
		    return true;
		}
		if (obj instanceof CardUrlRelation) {
			CardUrlRelation cu = (CardUrlRelation) obj;
			
			return cuid.equals(cu.cuid) && form.equals(cu.getForm());
		}
		return false;
	}

	public int hashCode() {
		return cuid.hashCode() ^ form.hashCode();
	}
	
	public WebForm getForm() {
		return form;
	}
	public void setForm(WebForm form) throws UserProfileException {
		if (form == null)
			throw new UserProfileException("CardUrlRelation.form can not be null!!!");
		this.form = form;
	}

}
