/** 
 * Copyright (c) 2007-2008 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 *		Yuriy Pilipenko - API and implementation 
 * 
 */
package org.eclipse.higgins.userprofile.idas.util;

import java.net.URI;

/***
 * URI Constants for User Meta Information IdAS Context.
 * 
 * @author PilipenkoYN
 */
public final class IdasCtxUris {
	
	private IdasCtxUris() {
	}
	
	public static final String UP_NS = "http://www.eclipse.org/higgins/ontologies/2008/7/userProfile#";
	//public static final String UP_NS = "http://www.eclipse.org/higgins/ontologies/2008/userProfile#";

	//User Profile entity URIs
	public static final URI UP_UserProfile = URI.create(UP_NS + "UserProfile");
	
	public static final URI UP_authPasswordHash = URI.create(UP_NS + "authPasswordHash");
	public static final URI UP_loginName = URI.create(UP_NS + "loginName"); //used in UserProfile, CardCredentialInfo
	public static final URI UP_password = URI.create(UP_NS + "password");	//CardCredentialInfo, not more used in UserProfile
	public static final URI UP_firstName = URI.create(UP_NS + "firstName");
	public static final URI UP_lastName = URI.create(UP_NS + "lastName");
	public static final URI UP_email = URI.create(UP_NS + "email");
	public static final URI UP_status = URI.create(UP_NS + "status");
	public static final URI UP_created = URI.create(UP_NS + "created");
	public static final URI UP_modified = URI.create(UP_NS + "modified");
	public static final URI UP_usedFrom = URI.create(UP_NS + "usedFrom");
	public static final URI UP_privateUserINumber = URI.create(UP_NS + "privateUserINumber");
	public static final URI UP_privateSelectorINumbers = URI.create(UP_NS + "privateSelectorINumbers");
	public static final URI UP_cardInformation = URI.create(UP_NS + "cardInformation"); //complex att CardInformation, used in UserProfile
	public static final URI UP_cardUrlRelation = URI.create(UP_NS + "cardUrlRelation");	//complex att CardUrlRelation, used in UserProfile
	public static final URI UP_claimValuesMRU = URI.create(UP_NS + "claimValuesMRU");   //complex att ClaimValuesMRU, used in UserProfile
	public static final URI UP_oneTimePasswords = URI.create(UP_NS + "oneTimePasswords"); //complex att OneTimePassword, used in UserProfile
	public static final URI UP_useAlways = URI.create(UP_NS + "useAlways");				//complex att UseAlways, used in UserProfile
	public static final URI UP_blackListedSites	= URI.create(UP_NS + "blackListedSites");
	public static final URI UP_policyVersion = URI.create(UP_NS + "policyVersion");		//complex att PolicyVersion, used in UserProfile
	public static final URI UP_privateKey = URI.create(UP_NS + "privateKey");
	public static final URI UP_newAuthPasswordHash = URI.create(UP_NS + "newAuthPasswordHash");
	public static final URI UP_passwordIsapMd5 = URI.create(UP_NS + "passwordIsapMd5");
	public static final URI UP_sms = URI.create(UP_NS + "sms");
	public static final URI UP_defaultPCardCUID = URI.create(UP_NS + "defaultPCardCUID");
	public static final URI UP_passphraseHash = URI.create(UP_NS + "passphraseHash");
	public static final URI UP_passwordResetCode = URI.create(UP_NS + "passwordResetCode");
	public static final URI UP_resetCodeDate = URI.create(UP_NS + "resetCodeDate");
	public static final URI UP_referralTracking = URI.create(UP_NS + "referralTracking");
	public static final URI UP_sendMeNews = URI.create(UP_NS + "sendMeNews");

	//User Card Category entity URIs
	public static final URI CC_CardCategory = URI.create(UP_NS + "CardCategory");
	public static final URI CC_userIdentifier = URI.create(UP_NS + "userIdentifier");
	public static final URI CC_id = URI.create(UP_NS + "id");
	public static final URI CC_parentId = URI.create(UP_NS + "parentId");
	public static final URI CC_name =  URI.create(UP_NS + "name");
	public static final URI CC_icon = URI.create(UP_NS + "icon");
	public static final URI CC_selectedIcon = URI.create(UP_NS + "selectedIcon");
	public static final URI CC_cuid = URI.create(UP_NS + "cuid"); //used in CardCategory, CardInformation, CardUrlRelation, UseAlways
	public static final URI CC_idx = URI.create(UP_NS + "idx"); 
	public static final URI CC_type = URI.create(UP_NS + "type");
	
	//User Card Credential Info complex attribute URIs
	public static final URI CCI_CardInformation = URI.create(UP_NS + "CardInformation");
	public static final URI CCI_cardCred = URI.create(UP_NS + "cardCredential");	//Complex att CardCredential
	public static final URI CCI_cardUsage = URI.create(UP_NS + "cardUsage");		//Complex att CardUsage
	public static final URI CCI_CardCredential = URI.create(UP_NS + "CardCredential"); 
	public static final URI CCI_SC_urls = URI.create(UP_NS + "urls");	
	public static final URI CCI_SC_type = URI.create(UP_NS + "type");
	public static final URI CCI_SC_tsAddress = URI.create(UP_NS + "tsAddress");
	public static final URI CCI_SC_tsMetadataAddress = URI.create(UP_NS + "tsMetadataAddress");
	public static final URI CCI_SC_pinCode = URI.create(UP_NS + "pinCode");
	public static final URI CCI_CardUsage = URI.create(UP_NS + "CardUsage");
	public static final URI CCI_CU_site = URI.create(UP_NS + "cuSite");
	public static final URI CCI_CU_date = URI.create(UP_NS + "cuDate");

	//Card Url Relation attribute uris
	public static final URI CU_CardUrlRelation = URI.create(UP_NS + "CardUrlRelation");
	public static final URI CU_url = URI.create(UP_NS + "url");					//used in CardUrlRelation, UseAlways, PolicyVersion
	public static final URI CU_formName = URI.create(UP_NS + "formName");		//used in CardUrlRelation, UseAlways, CardUsage, PolicyVersion
	public static final URI CU_formId = URI.create(UP_NS + "formId");			//used in CardUrlRelation, UseAlways, CardUsage, PolicyVersion
	public static final URI CU_formAction = URI.create(UP_NS + "formAction");	//used in CardUrlRelation, UseAlways, CardUsage, PolicyVersion
	public static final URI CU_lastUsed = URI.create(UP_NS + "lastUsed");
	public static final URI CU_optionalClaims = URI.create(UP_NS + "optionalClaims");
	//public static final URI CU_useAlways = URI.create(UP_NS + "useAlways");
	
	//Card claim values MRU list uris
	public static final URI CU_ClaimValuesMRU = URI.create(UP_NS + "ClaimValuesMRU");
	public static final URI CU_claimType = URI.create(UP_NS + "claimType");
	public static final URI CU_claimValue = URI.create(UP_NS + "claimValue");
	
	//Use Always class uri
	public static final URI UA_UseAlways = URI.create(UP_NS + "UseAlways");
	
	//PolicyVersion class uris
	public static final URI PV_PolicyVersion = URI.create(UP_NS + "PolicyVersion");
	public static final URI PV_policy = URI.create(UP_NS + "policy");
	public static final URI PV_version = URI.create(UP_NS + "version");

	//OneTimePassword class uris
	public static final URI OT_OneTimePassword = URI.create(UP_NS + "OneTimePassword");
	public static final URI OT_otpTimestamp = URI.create(UP_NS + "otpTimestamp");
	public static final URI OT_otpValue = URI.create(UP_NS + "otpValue");

	public static final URI UP_Captcha = URI.create(UP_NS + "Captcha");
	public static final URI UP_dtCreation = URI.create(UP_NS + "dtCreation");
	public static final URI UP_key = URI.create(UP_NS + "key");

}
