/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.userprofile;

import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.registry.HigginsRegistry;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.registry.IIORegistryExtension;
import org.eclipse.higgins.registry.IRegistryExtension;
import org.eclipse.higgins.registry.IServiceProvider;
import org.eclipse.higgins.registry.PropertiesConfigurationFactory;
import org.eclipse.higgins.registry.RegistryConfigurationException;
import org.eclipse.higgins.registry.SecurityRegistryExtension;
import org.eclipse.higgins.userprofile.IUserProfileService;
import org.eclipse.higgins.userprofile.UserProfileException;
import org.eclipse.higgins.userprofile.entity.UserProfile;
import org.eclipse.higgins.userprofile.inmem.MemoryUserProfileService;

public class UserProfileRegistry
extends HigginsRegistry {
    private Log log;
    private static UserProfileRegistry instance = new UserProfileRegistry();
    protected static PropertiesConfigurationFactory configFactory = new PropertiesConfigurationFactory(".userprofile");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private UserProfileRegistry() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.higgins.userprofile.IUserProfileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.higgins.userprofile.UserProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz2);
        this.initialize();
    }

    private UserProfileRegistry(String configPath) throws RegistryConfigurationException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.higgins.userprofile.IUserProfileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.higgins.userprofile.UserProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz2);
        configFactory.setRootHigginsConfigPath(configPath);
        this.initialize();
    }

    private void initialize() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.higgins.userprofile.IUserProfileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addExtension((IRegistryExtension)new IIORegistryExtension((Class)clazz));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.higgins.userprofile.IUserProfileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addExtension((IRegistryExtension)new SecurityRegistryExtension((Class)clazz2));
        this.loadProviders();
        try {
            if (this.providers.size() > 1) {
                this.log.warn((Object)("There are more than one User Profile Service providers! " + this.providers.keySet().toString()));
            }
            if (this.providers.size() == 0) {
                this.add(new MemoryUserProfileService());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
    }

    public static UserProfileRegistry getInstance() {
        return instance;
    }

    public IUserProfileService getUserProfileService() throws UserProfileException {
        Object svc = this.providers.values().iterator().next();
        if (svc instanceof IUserProfileService) {
            return (IUserProfileService)svc;
        }
        throw new UserProfileException("User Profile Service not found! Check the configuration!");
    }

    public UserProfile getUserProfile(CallbackHandler handler) throws UserProfileException {
        IUserProfileService ups = (IUserProfileService)this.providers.values().iterator().next();
        return ups.getUserProfile(handler);
    }

    public IConfiguration getConfiguration(IServiceProvider provider) throws RegistryConfigurationException {
        return configFactory.getConfigurqation(provider.getID());
    }
}

