/**
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *  	Duane Buss
 *  	Tom Doman
 */

package org.eclipse.higgins.util.idas.cp;

import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;

import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.IdASException;

/**
 * Helper function for policy based <a
 * href="http://www.eclipse.org/higgins/">Higgins</a> Context providers. This
 * implementation allows for policy at critical points.
 * 
 * After creation this object always transforms results as the accessor
 * functions are called. The direction of the mapping is based on if object was
 * created with provider or consumer values. You cannot use the object to access
 * values untransformed!
 *
 * @author dbuss@novell.com
 */

public class AttributeValuesPDPIter implements Iterator
{
		//
	private IAttributePDPs _attributePDP;
	private IAttributePDPs _metaAttrPDP;
	private URI _providerAttrID;
	private URI _consumerAttrID;
		// the iterator we're wrapping
	private Iterator _realIterator;

	private boolean _isProviderData;

		/**
		 * Create a new ImmutableIterator
		 */
	public AttributeValuesPDPIter(
		URI providerAttrID,
		URI consumerAttrID,
		IAttributePDPs attributePDP,
		IAttributePDPs metaAttrPDP,
		Iterator iterator,
		boolean isProviderData)
	{
		_providerAttrID = providerAttrID;
		_consumerAttrID = consumerAttrID;
		_attributePDP = attributePDP;
		_metaAttrPDP = metaAttrPDP;
		_realIterator = iterator;
		_isProviderData = isProviderData;
	}

	/**
	 * Standard hasNext method
	 */
	public boolean hasNext()
	{
		return (_realIterator != null) ? _realIterator.hasNext() : false;
	}

	/**
	 * Standard next method
	 * TODO: implement Complex Values
	 * @throws NoSuchElementException 
	 */
	public Object next() throws NoSuchElementException
	{
		IValue provider = (IValue)_realIterator.next();
		try {
			if ( provider.isSimple())
				return new SimpleValuePDP(_providerAttrID, _consumerAttrID, _attributePDP, _metaAttrPDP, (ISimpleValue)provider, _isProviderData);
		}catch (IdASException e) {
		}
		throw new NoSuchElementException("Complex values not yet supported");
	}

	/**
	 * Makes sure that no one can remove any elements from the collection
	 */
	public void remove() throws UnsupportedOperationException
	{
		throw new UnsupportedOperationException();
	}
}
