/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Date;
import org.eclipse.higgins.util.saml.SAML2Attributes;
import org.eclipse.higgins.util.saml.SAML2AuthnStatement;
import org.eclipse.higgins.util.saml.SAMLAssertion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SAML2Assertion
extends SAMLAssertion {
    public SAML2Assertion() {
        this((Document)null);
    }

    public SAML2Assertion(Document document) {
        super(document, "saml", "urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        SAML2Assertion.addInferredNamespaceAttributes(this.element);
        this.setVersion("2.0");
        this.setIssueInstant(new Date());
    }

    public SAML2Assertion(InputStream stream) throws SAXException, IOException {
        super(stream);
    }

    public SAML2Assertion(Reader reader) throws SAXException, IOException {
        super(reader);
    }

    public SAML2Assertion(Document document, Element element) {
        super(document, element);
    }

    public Element getAuthnStatementElement() {
        Element element = (Element)this.element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnStatement").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("AuthnStatement").item(0);
        }
        return element;
    }

    public SAML2AuthnStatement getSAMLAuthnStatement() {
        Element elementAuthnStatement = this.getAuthnStatementElement();
        if (elementAuthnStatement == null) {
            return null;
        }
        return new SAML2AuthnStatement(this.document, elementAuthnStatement);
    }

    public void setSAMLAuthnStatement(SAML2AuthnStatement samlAuthnStatement) {
        Element elementAuthnStatement = this.getAuthnStatementElement();
        if (elementAuthnStatement != null) {
            this.element.replaceChild(elementAuthnStatement, samlAuthnStatement.getElement());
        } else {
            this.element.appendChild(samlAuthnStatement.getElement());
        }
    }

    public SAML2Attributes getAttributes() {
        return new SAML2Attributes(this.document, this.element);
    }
}

