/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.higgins.util.saml.XMLElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SAML2LogoutRequest
extends XMLElement {
    public SAML2LogoutRequest() {
        this((Document)null);
    }

    public SAML2LogoutRequest(Document document) {
        super(document, "samlp", "urn:oasis:names:tc:SAML:2.0:protocol", "LogoutRequest");
        this.setVersion("2.0");
        this.setIssueInstant(new Date());
        this.setIssuer("");
        this.setNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
    }

    public SAML2LogoutRequest(InputStream stream) throws SAXException, IOException {
        super(stream);
    }

    public SAML2LogoutRequest(Reader reader) throws SAXException, IOException {
        super(reader);
    }

    public SAML2LogoutRequest(Document document, Element element) {
        super(document, element);
    }

    public String getVersion() {
        return this.element.getAttribute("Version");
    }

    public void setVersion(String value) {
        this.element.setAttribute("Version", value);
    }

    public Date getIssueInstant() {
        try {
            return SAML2LogoutRequest.fromXMLDate(this.element.getAttribute("IssueInstant"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setIssueInstant(Date value) {
        this.element.setAttribute("IssueInstant", SAML2LogoutRequest.toXMLDate(value));
    }

    private Element getNameIDElement() {
        Element element = (Element)this.element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "NameID").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("NameID").item(0);
        }
        return element;
    }

    public String getNameIDFormat() {
        Element elementNameID = this.getNameIDElement();
        if (elementNameID == null) {
            return null;
        }
        Attr attrFormat = elementNameID.getAttributeNode("Format");
        if (attrFormat == null) {
            return null;
        }
        return attrFormat.getValue();
    }

    public void setNameIDFormat(String value) {
        Element elementNameID = this.getNameIDElement();
        if (elementNameID == null) {
            elementNameID = this.document.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "NameID");
            elementNameID.setPrefix("saml");
            SAML2LogoutRequest.addInferredNamespaceAttributes(elementNameID);
            this.element.appendChild(elementNameID);
        }
        elementNameID.setAttribute("Format", value);
    }

    public String getNameIDSPNameQualifier() {
        Element elementNameID = this.getNameIDElement();
        if (elementNameID == null) {
            return null;
        }
        Attr attrFormat = elementNameID.getAttributeNode("SPNameQualifier");
        if (attrFormat == null) {
            return null;
        }
        return attrFormat.getValue();
    }

    public void setNameIDSPNameQualifier(String value) {
        Element elementNameID = this.getNameIDElement();
        if (elementNameID == null) {
            elementNameID = this.document.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "NameID");
            elementNameID.setPrefix("saml");
            SAML2LogoutRequest.addInferredNamespaceAttributes(elementNameID);
            this.element.appendChild(elementNameID);
        }
        elementNameID.setAttribute("SPNameQualifier", value);
    }

    public String getNameID() {
        Element elementNameID = this.getNameIDElement();
        if (elementNameID == null) {
            return null;
        }
        return SAML2LogoutRequest.getTextContent(elementNameID);
    }

    public void setNameID(String value) {
        Element elementNameID = this.getNameIDElement();
        if (this.element == null) {
            this.element = this.document.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "NameID");
            this.element.setPrefix("saml");
            SAML2LogoutRequest.addInferredNamespaceAttributes(this.element);
            this.element.appendChild(this.element);
        }
        SAML2LogoutRequest.setTextContent(elementNameID, value);
    }

    private Element getIssuerElement() {
        Element elementIssuer = (Element)this.element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer").item(0);
        if (elementIssuer == null) {
            elementIssuer = (Element)this.element.getElementsByTagName("Issuer").item(0);
        }
        return elementIssuer;
    }

    public String getIssuer() {
        Element elementIssuer = this.getIssuerElement();
        if (elementIssuer == null) {
            return null;
        }
        return SAML2LogoutRequest.getTextContent(elementIssuer);
    }

    public void setIssuer(String value) {
        Element elementIssuer = this.getIssuerElement();
        if (elementIssuer == null) {
            elementIssuer = this.document.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer");
            elementIssuer.setPrefix("saml");
            SAML2LogoutRequest.addInferredNamespaceAttributes(elementIssuer);
            this.element.appendChild(elementIssuer);
        }
        SAML2LogoutRequest.setTextContent(elementIssuer, value);
    }
}

