/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.higgins.util.saml.SAML2Assertion;
import org.eclipse.higgins.util.saml.XMLElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SAML2Response
extends XMLElement {
    public SAML2Response(Document document) {
        super(document, "samlp", "urn:oasis:names:tc:SAML:2.0:protocol", "Response");
        this.setVersion("2.0");
        this.setIssueInstant(new Date());
    }

    public SAML2Response() {
        this((Document)null);
    }

    public SAML2Response(InputStream stream) throws SAXException, IOException {
        super(stream);
    }

    public SAML2Response(Reader reader) throws SAXException, IOException {
        super(reader);
    }

    public SAML2Response(Document document, Element element) {
        super(document, element);
    }

    public String getVersion() {
        return this.element.getAttribute("Version");
    }

    public void setVersion(String value) {
        this.element.setAttribute("Version", value);
    }

    public Date getIssueInstant() {
        try {
            return SAML2Response.fromXMLDate(this.element.getAttribute("IssueInstant"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setIssueInstant(Date value) {
        this.element.setAttribute("IssueInstant", SAML2Response.toXMLDate(value));
    }

    public String getDestination() {
        return this.element.getAttribute("Destination");
    }

    public void setDestination(String value) {
        this.element.setAttribute("Destination", value);
    }

    public String getInResponseTo() {
        return this.element.getAttribute("InResponseTo");
    }

    public void setInResponseTo(String value) {
        this.element.setAttribute("InResponseTo", value);
    }

    public Element getIssuerElement() {
        Element element = (Element)this.element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("Issuer").item(0);
        }
        return element;
    }

    public String getIssuer() {
        Element elementIssuer = this.getIssuerElement();
        if (elementIssuer == null) {
            return null;
        }
        return SAML2Response.getTextContent(elementIssuer);
    }

    public void setIssuer(String value) {
        Element elementIssuer = this.getIssuerElement();
        if (elementIssuer == null) {
            elementIssuer = this.document.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer");
            elementIssuer.setPrefix("saml");
            SAML2Response.addInferredNamespaceAttributes(elementIssuer);
            this.element.appendChild(elementIssuer);
        }
        SAML2Response.setTextContent(elementIssuer, value);
    }

    private Element getStatusElement() {
        Element element = (Element)this.element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "Status").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("Status").item(0);
        }
        return element;
    }

    private Element getStatusCodeElement(Element elementStatus) {
        Element element = (Element)this.element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "StatusCode").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("StatusCode").item(0);
        }
        return element;
    }

    public String getStatusCodeValue() {
        Element elementStatus = this.getStatusElement();
        if (elementStatus == null) {
            return null;
        }
        Element elementStatusCode = this.getStatusCodeElement(elementStatus);
        if (elementStatusCode == null) {
            return null;
        }
        Attr attrValue = elementStatusCode.getAttributeNode("Value");
        if (attrValue == null) {
            return null;
        }
        return attrValue.getValue();
    }

    public void setStatusCodeValue(String value) {
        Element elementStatusCode;
        Element elementStatus = this.getStatusElement();
        if (elementStatus == null) {
            elementStatus = this.document.createElementNS("urn:oasis:names:tc:SAML:2.0:protocol", "Status");
            elementStatus.setPrefix("samlp");
            this.element.appendChild(elementStatus);
        }
        if ((elementStatusCode = this.getStatusCodeElement(elementStatus)) == null) {
            elementStatusCode = this.document.createElementNS("urn:oasis:names:tc:SAML:2.0:protocol", "StatusCode");
            elementStatusCode.setPrefix("samlp");
            elementStatus.appendChild(elementStatusCode);
        }
        elementStatusCode.setAttribute("Value", value);
    }

    private Element getAssertionElement() {
        Element element = (Element)this.element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("Assertion").item(0);
        }
        return element;
    }

    public SAML2Assertion getSAMLAssertion() {
        Element elementAssertion = this.getAssertionElement();
        if (elementAssertion == null) {
            return null;
        }
        return new SAML2Assertion(this.document, elementAssertion);
    }

    public void setSAMLAssertion(SAML2Assertion samlAssertion) {
        Element elementAssertion = this.getAssertionElement();
        if (elementAssertion != null) {
            this.element.replaceChild(elementAssertion, samlAssertion.getElement());
        } else {
            this.element.appendChild(samlAssertion.getElement());
        }
    }
}

