/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import org.eclipse.higgins.util.saml.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SAMLAttribute
extends XMLElement {
    public SAMLAttribute() {
        this((Document)null);
    }

    public SAMLAttribute(Document document) {
        super(document, "saml", "urn:oasis:names:tc:SAML:2.0:assertion", "Attribute");
    }

    public SAMLAttribute(InputStream stream) throws SAXException, IOException {
        super(stream);
        this.nameSpace = this.element.getNamespaceURI();
    }

    public SAMLAttribute(Reader reader) throws SAXException, IOException {
        super(reader);
        this.nameSpace = this.element.getNamespaceURI();
    }

    public SAMLAttribute(Document document, Element element) {
        super(document, element);
        this.nameSpace = element.getNamespaceURI();
    }

    public boolean isSimpleSingleValuedValue() {
        NodeList nl = this.element.getElementsByTagNameNS(this.nameSpace, "AttributeValue");
        if (nl == null) {
            nl = this.element.getElementsByTagName("AttributeValue");
        }
        return nl == null || nl != null && nl.getLength() <= 1;
    }

    public String getValue() {
        if (!this.isSimpleSingleValuedValue()) {
            return null;
        }
        Element element = (Element)this.element.getElementsByTagNameNS(this.nameSpace, "AttributeValue").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("AttributeValue").item(0);
        }
        if (element == null) {
            return null;
        }
        return SAMLAttribute.getTextContent(element);
    }

    public Vector getSimpleValues() {
        Vector<String> claimValues = new Vector<String>();
        NodeList nl = this.element.getElementsByTagNameNS(this.nameSpace, "AttributeValue");
        if (nl == null) {
            nl = this.element.getElementsByTagName("AttributeValue");
        }
        if (nl != null && nl.getLength() >= 1) {
            int index = 0;
            while (index < nl.getLength()) {
                claimValues.add(SAMLAttribute.getTextContent((Element)nl.item(index)));
                ++index;
            }
        }
        return claimValues;
    }
}

