/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.higgins.idas.api.IdASException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomFuncs {
    public static final String IDAS_NAMESPACE = "http://www.eclipse.org/higgins/idas/rest-xml/2008/6";
    public static final String CLASS_NAME_ATTR = "className";
    public static final String STATUS_INFO_ELEMENT = "StatusInfo";
    public static final String STATUS_MESSAGE_ELEMENT = "StatusMessage";
    public static final String EXCEPTION_ELEMENT = "Exception";
    public static final String EXCEPTION_ERR_MSG_ELEMENT = "ExceptionErrMsg";
    public static final String EXCEPTION_STACK_TRACE = "ExceptionStackTrace";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;

    public static boolean isElementNode(Node node, String strNamespace, String strElementName) {
        String szNodeElementName;
        if (node.getNodeType() == 1 && (szNodeElementName = node.getLocalName()) != null && szNodeElementName.equals(strElementName)) {
            String szNodeNamespace = node.getNamespaceURI();
            if (strNamespace == null ? szNodeNamespace == null : szNodeNamespace.equals(strNamespace)) {
                return true;
            }
        }
        return false;
    }

    public static Element getFirstChildElement(Node parentNode, String strNamespace, String strElementName) {
        for (Node childNode = parentNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (!DomFuncs.isElementNode(childNode, strNamespace, strElementName)) continue;
            return (Element)childNode;
        }
        return null;
    }

    public static Element getLastChildElement(Node parentNode, String strNamespace, String strElementName) {
        for (Node childNode = parentNode.getLastChild(); childNode != null; childNode = childNode.getPreviousSibling()) {
            if (!DomFuncs.isElementNode(childNode, strNamespace, strElementName)) continue;
            return (Element)childNode;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node siblingNode, String strNamespace, String strElementName) {
        for (Node sibNode = siblingNode.getNextSibling(); sibNode != null; sibNode = sibNode.getNextSibling()) {
            if (!DomFuncs.isElementNode(sibNode, strNamespace, strElementName)) continue;
            return (Element)sibNode;
        }
        return null;
    }

    public static Element getPreviousSiblingElement(Node siblingNode, String strNamespace, String strElementName) {
        for (Node sibNode = siblingNode.getPreviousSibling(); sibNode != null; sibNode = sibNode.getPreviousSibling()) {
            if (!DomFuncs.isElementNode(sibNode, strNamespace, strElementName)) continue;
            return (Element)sibNode;
        }
        return null;
    }

    public static String getNodeText(Node node) {
        Node textNode;
        for (textNode = node.getFirstChild(); textNode != null && textNode.getNodeType() != 3; textNode = textNode.getNextSibling()) {
        }
        if (textNode != null) {
            return textNode.getNodeValue();
        }
        return "";
    }

    public static Element createChildElement(Element parentElement, String strNamespace, String strElementName, String strValue) throws DOMException {
        Element childElement = strNamespace != null ? parentElement.getOwnerDocument().createElementNS(strNamespace, strElementName) : parentElement.getOwnerDocument().createElement(strElementName);
        parentElement.appendChild(childElement);
        if (strValue != null) {
            childElement.appendChild(parentElement.getOwnerDocument().createTextNode(strValue));
        }
        return childElement;
    }

    public static Element createChildElement(Document parentDoc, String strNamespace, String strElementName, String strValue) throws DOMException {
        Element childElement = strNamespace != null ? parentDoc.createElementNS(strNamespace, strElementName) : parentDoc.createElement(strElementName);
        parentDoc.appendChild(childElement);
        if (strValue != null) {
            childElement.appendChild(parentDoc.createTextNode(strValue));
        }
        return childElement;
    }

    public static Document parseToDOMFromStream(InputStream iStream) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(iStream);
    }

    public static Document parseToDOMFromStr(String strBuffer) throws IdASException {
        Document doc = null;
        try {
            doc = DomFuncs.parseToDOMFromStream(new ByteArrayInputStream(strBuffer.getBytes()));
        }
        catch (Exception e) {
            throw new IdASException("Exception " + e.getClass().getName() + " parsing XML string [" + strBuffer + "]: " + e.getMessage());
        }
        return doc;
    }

    public static Document parseToDOMFromFile(String strFileName) throws IdASException {
        Document doc = null;
        try {
            doc = DomFuncs.parseToDOMFromStream(new FileInputStream(new File(strFileName)));
        }
        catch (Exception e) {
            throw new IdASException("Exception " + e.getClass().getName() + " parsing XML file '" + strFileName + "': " + e.getMessage());
        }
        return doc;
    }

    public static InputStream XMLDocumentStream(Document doc) throws Exception {
        InputStream iStream = null;
        return iStream;
    }

    public static String XMLDocumentString(Document doc) throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        transformer.transform(source, result);
        return sw.toString();
    }

    public static Class getExceptionClass(String strExceptionClass) {
        try {
            return Class.forName(strExceptionClass);
        }
        catch (Exception e) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                try {
                    return classLoader.loadClass(strExceptionClass);
                }
                catch (Throwable t) {
                    return null;
                }
            }
            return null;
        }
    }

    public static Exception getException(String strExceptionClass, String strExceptionMessage, Exception eCause) {
        Class exceptionClass = DomFuncs.getExceptionClass(strExceptionClass);
        if (strExceptionMessage != null && eCause != null) {
            try {
                Class[] argClassTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DomFuncs.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = DomFuncs.class$("java.lang.Throwable")) : class$java$lang$Throwable};
                Constructor ctor = exceptionClass.getDeclaredConstructor(argClassTypes);
                Object[] args = new Object[]{strExceptionMessage, eCause};
                return (Exception)ctor.newInstance(args);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (eCause != null) {
            try {
                Class[] argClassTypes = new Class[]{class$java$lang$Throwable == null ? (class$java$lang$Throwable = DomFuncs.class$("java.lang.Throwable")) : class$java$lang$Throwable};
                Constructor ctor = exceptionClass.getDeclaredConstructor(argClassTypes);
                Object[] args = new Object[]{eCause};
                return (Exception)ctor.newInstance(args);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (strExceptionMessage != null) {
            try {
                Class[] argClassTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DomFuncs.class$("java.lang.String")) : class$java$lang$String};
                Constructor ctor = exceptionClass.getDeclaredConstructor(argClassTypes);
                Object[] args = new Object[]{strExceptionMessage};
                return (Exception)ctor.newInstance(args);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            return (Exception)exceptionClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Exception getException(Element exceptionElement, String strDefaultExceptionClass) {
        Exception e;
        Element statusInfoElement = null;
        Element messageElement = null;
        Element subExceptionElement = null;
        Exception eCause = null;
        String strExceptionClass = null;
        String strExceptionMessage = null;
        Object exceptionClass = null;
        if (DomFuncs.isElementNode(exceptionElement, IDAS_NAMESPACE, STATUS_INFO_ELEMENT)) {
            statusInfoElement = exceptionElement;
            exceptionElement = DomFuncs.getFirstChildElement(statusInfoElement, IDAS_NAMESPACE, EXCEPTION_ELEMENT);
        } else if (!DomFuncs.isElementNode(exceptionElement, IDAS_NAMESPACE, EXCEPTION_ELEMENT)) {
            return null;
        }
        if (exceptionElement == null) {
            if (statusInfoElement != null && (messageElement = DomFuncs.getFirstChildElement(statusInfoElement, IDAS_NAMESPACE, STATUS_MESSAGE_ELEMENT)) != null) {
                strExceptionMessage = DomFuncs.getNodeText(messageElement);
            }
        } else {
            strExceptionClass = exceptionElement.getAttribute(CLASS_NAME_ATTR);
            messageElement = DomFuncs.getFirstChildElement(exceptionElement, IDAS_NAMESPACE, EXCEPTION_ERR_MSG_ELEMENT);
            if (messageElement != null) {
                strExceptionMessage = DomFuncs.getNodeText(messageElement);
            }
            if ((subExceptionElement = DomFuncs.getFirstChildElement(exceptionElement, IDAS_NAMESPACE, EXCEPTION_ELEMENT)) != null) {
                eCause = DomFuncs.getException(subExceptionElement, null);
            }
        }
        if (strExceptionClass != null && (e = DomFuncs.getException(strExceptionClass, strExceptionMessage, eCause)) != null) {
            Class defaultClass;
            if (strDefaultExceptionClass != null && (defaultClass = DomFuncs.getExceptionClass(strDefaultExceptionClass)) != null && !defaultClass.isInstance(e)) {
                e = DomFuncs.getException(strDefaultExceptionClass, strExceptionMessage, e);
            }
            if (e != null) {
                return e;
            }
        }
        if (strDefaultExceptionClass != null && (e = DomFuncs.getException(strDefaultExceptionClass, strExceptionMessage, eCause)) != null) {
            return e;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

