/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.ant.service;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.higgins.ant.Higgins2AntPlugin;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.TeamException;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;

/**
 * Creates build.xml file.
 */
public abstract class AbstractBuildFileCreator extends AbstractCreator {
    protected static final String IMPORT_BUILDFILE_PROCESSING_TARGET = "eclipse.ant.import"; //$NON-NLS-1$
//    protected static final String WARNING = " WARNING: Higgins2Ant v %1$s auto-generated file." + ExportUtil.NEWLINE + //$NON-NLS-1$
    protected static final String WARNING = " WARNING: Higgins2Ant v {0} auto-generated file." + ExportUtil.NEWLINE + //$NON-NLS-1$
                                            "              Any modifications will be overwritten."; //$NON-NLS-1$
    protected static final String NOTE =    "              To include a user specific buildfile here, " + //$NON-NLS-1$
                                            "simply create one in the same" + ExportUtil.NEWLINE + //$NON-NLS-1$
                                            "              directory with the processing instruction " + //$NON-NLS-1$
                                            "<?" +  IMPORT_BUILDFILE_PROCESSING_TARGET + "?>" + ExportUtil.NEWLINE + //$NON-NLS-1$ //$NON-NLS-2$
                                            "              as the first entry and export the buildfile again. "; //$NON-NLS-1$
    protected static final String COMMENT_SEPARATOR = " ======================================== ";

	protected Map variable2valueMap = new LinkedHashMap();
	
    public AbstractBuildFileCreator() {
    	super();
    }
    
    public AbstractBuildFileCreator(IProject project) {
    	super(project);
    }
    
    protected void Init(IProject project) {
    	super.Init(project);
    }
    
	protected void createRoot(String defaultTarget) {
		// <project name="hello" default="build" basedir=".">
		root = doc.createElement("project");
		root.setAttribute("name", projectName);
		root.setAttribute("default", defaultTarget);
		root.setAttribute("basedir", ".");
		doc.appendChild(root);

		// <!-- warning -->
		//String v = String.format(WARNING, new String[] {Higgins2AntPlugin.getDefault().getVersion()});
		String v = MessageFormat.format(WARNING, new String[] {Higgins2AntPlugin.getDefault().getVersion()});
		Comment comment = doc.createComment(v + ExportUtil.NEWLINE + NOTE);
		doc.insertBefore(comment, root);
	}
    
	protected void createFetch() throws JavaModelException {
		Comment c = doc.createComment(" ======================================== ");
		root.appendChild(c);
		c = doc.createComment(" Fetch dependencies ");
		root.appendChild(c);
		Element target = doc.createElement("target");
		target.setAttribute("name", "fetch.dependencies");
		
		List dependencies  = projectManager.getSubProjects(project);
		
		//sort projects by provider
		Map byProvider = new HashMap(); 
		for (int i = 0; i < dependencies.size(); i++) {
			IProject p = projectManager.getProject(dependencies.get(i));
			if (p != null) {
				//---------------------------------------
				RepositoryProvider provider = RepositoryProvider.getProvider(p);
				if (provider != null) {
					String id = provider.getID();
					Set list = (Set) byProvider.get(id);
					if (list == null) {
						list = new TreeSet(projectManager.getProjectComparator());
						byProvider.put(id, list);
					}
					list.add(p);
				}
			}
		}
		Comparator comparator = new Comparator() {
			public int compare(Object arg0, Object arg1) {
				// TODO Auto-generated method stub
				return ((Element) arg0).getAttribute("name").compareTo(((Element) arg1).getAttribute("name"));
			}
		};
		Set fetchTargetList = new TreeSet(comparator);
		Set checkoutTargetList = new TreeSet(comparator);
		Set updateTargetList = new TreeSet(comparator);
		
		boolean taskdefReqired = true;
		boolean cvsTargetsReuired = true;
		boolean svnTargetsReuired = true;
		
		for (Iterator providersIt = byProvider.keySet().iterator(); providersIt.hasNext(); ) {
			String id = (String) providersIt.next();
			Set list = (Set) byProvider.get(id);
			IProject[] projectArray = (IProject[])list.toArray(new IProject[list.size()]);
			
			RepositoryProviderType providerType = RepositoryProviderType.getProviderType(id);
			ProjectSetCapability capability = providerType.getProjectSetCapability();
			ProjectSetCapability.ensureBackwardsCompatible(providerType, capability);
			
			String[] references = null;
			if (capability != null) {
				try {
					references = capability.asReference(projectArray, new ProjectSetSerializationContext(), new NullProgressMonitor());
				} catch (TeamException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			
			if (references != null) {
				if ("org.eclipse.team.cvs.core.cvsnature".equalsIgnoreCase(id)) {
					if (cvsTargetsReuired) {
						Element element = doc.createElement("target");
						element.setAttribute("name", "fetch.from.cvs");
						element.setAttribute("depends", "check.project.existence,checkout.dependency.cvs,update.dependency.cvs");
						Element echo = doc.createElement("echo");
						echo.setAttribute("message", "fetch of ${id} - comlete");
						element.appendChild(echo);
						fetchTargetList.add(element);
						element = doc.createElement("target");
						element.setAttribute("name", "checkout.dependency.cvs");
						element.setAttribute("unless", "${id}-exists");
						Element cvs = doc.createElement("cvs");
						cvs.setAttribute("cvsRoot", "${cvsroot}");
						cvs.setAttribute("package", "${path}");
						cvs.setAttribute("command", "checkout -d ../${id}");
						cvs.setAttribute("tag", "${revision}");
						cvs.setAttribute("taskname", "cvs - checkout ${id}");
						element.appendChild(cvs);
						checkoutTargetList.add(element);
						element = doc.createElement("target");
						element.setAttribute("name", "update.dependency.cvs");
						element.setAttribute("if", "${id}-exists");
						cvs = doc.createElement("cvs");
						cvs.setAttribute("command", "update ../${id}");
						element.appendChild(cvs);
						updateTargetList.add(element);
						cvsTargetsReuired = false;
					}
					for (int i = 0; i < references.length; i++) {
						StringTokenizer tokenizer = new StringTokenizer(references[i], ",");
						tokenizer.nextToken();
						Element antcall =doc.createElement("antcall");
						antcall.setAttribute("target", "fetch.from.cvs");
						Element param = doc.createElement("param");
						param.setAttribute("name", "cvsroot");
						param.setAttribute("value", tokenizer.nextToken());
						antcall.appendChild(param);
						param = doc.createElement("param");
						param.setAttribute("name", "path");
						param.setAttribute("value", tokenizer.nextToken());
						antcall.appendChild(param);
						param = doc.createElement("param");
						param.setAttribute("name", "id");
						param.setAttribute("value", tokenizer.nextToken());
						antcall.appendChild(param);
						param = doc.createElement("param");
						param.setAttribute("name", "revision");
						param.setAttribute("value", "HEAD");
						antcall.appendChild(param);
						target.appendChild(antcall);
					}
				} else if ("org.eclipse.team.svn.core.svnnature".equalsIgnoreCase(id) || 
						"org.tigris.subversion.subclipse.core.svnnature".equalsIgnoreCase(id) ||
						"org.polarion.team.svn.core.svnnature".equalsIgnoreCase(id)) {
					if (taskdefReqired) {
						//add taskdef
						//default
						Element defaultSVNTaskDefTarget = doc.createElement("target");
						defaultSVNTaskDefTarget.setAttribute("unless", "svn.lib.path");
						defaultSVNTaskDefTarget.setAttribute("name", "default.svn.task.def");
						Element svnTaskDef = doc.createElement("taskdef");
						svnTaskDef.setAttribute("resource", "org/tigris/subversion/svnant/svnantlib.xml");
						defaultSVNTaskDefTarget.appendChild(svnTaskDef);
						//with path
						Element svnTaskDefTarget = doc.createElement("target");
						svnTaskDefTarget.setAttribute("if", "svn.lib.path");
						svnTaskDefTarget.setAttribute("name", "svn.task.def");
						//classpath 
						Element path = doc.createElement("path");
						path.setAttribute("id", "svn.classpath");
						Element pathelement = doc.createElement("pathelement");
						pathelement.setAttribute("location", "${svn.lib.path}/svnant.jar");
						path.appendChild(pathelement);
						pathelement = doc.createElement("pathelement");
						pathelement.setAttribute("location", "${svn.lib.path}/svnjavahl.jar");
						path.appendChild(pathelement);
						pathelement = doc.createElement("pathelement");
						pathelement.setAttribute("location", "${svn.lib.path}/javasvn.jar");
						path.appendChild(pathelement);
						pathelement = doc.createElement("pathelement");
						pathelement.setAttribute("location", "${svn.lib.path}/svnClientAdapter.jar");
						path.appendChild(pathelement);
						svnTaskDefTarget.appendChild(path);
						
						svnTaskDef = doc.createElement("taskdef");
						svnTaskDef.setAttribute("resource", "org/tigris/subversion/svnant/svnantlib.xml");
						svnTaskDef.setAttribute("classpathref", "svn.classpath");
						svnTaskDefTarget.appendChild(svnTaskDef);
						target.setAttribute("depends", "default.svn.task.def,svn.task.def");
						
						root.appendChild(defaultSVNTaskDefTarget);
						root.appendChild(svnTaskDefTarget);
						taskdefReqired = false;
					}
					if (svnTargetsReuired) {
						Element element = doc.createElement("target");
						element.setAttribute("name", "fetch.from.svn");
						element.setAttribute("depends", "check.project.existence,checkout.dependency.svn,update.dependency.svn");
						Element echo = doc.createElement("echo");
						echo.setAttribute("message", "fetch of ${id} - comlete");
						element.appendChild(echo);
						fetchTargetList.add(element);
						element = doc.createElement("target");
						element.setAttribute("name", "checkout.dependency.svn");
						element.setAttribute("unless", "${id}-exists");
						Element svn = doc.createElement("svn");
						svn.setAttribute("taskname", "svn - checkout ${id}");
						Element checkout = doc.createElement("checkout");
						checkout.setAttribute("url", "${url}");
						checkout.setAttribute("destpath", "../${id}");
						checkout.setAttribute("revision", "${revision}");
						svn.appendChild(checkout);
						element.appendChild(svn);
						checkoutTargetList.add(element);
						element = doc.createElement("target");
						element.setAttribute("name", "update.dependency.svn");
						element.setAttribute("if", "${id}-exists");
						svn = doc.createElement("svn");
						svn.setAttribute("taskname", "svn - update ${id}");
						Element update = doc.createElement("update");
						update.setAttribute("dir", "../${id}");
						svn.appendChild(update);
						element.appendChild(svn);
						updateTargetList.add(element);
						svnTargetsReuired = false;
					}
					for (int i = 0; i < references.length; i++) {
						StringTokenizer tokenizer = new StringTokenizer(references[i], ",");
						tokenizer.nextToken();
						Element antcall =doc.createElement("antcall");
						antcall.setAttribute("target", "fetch.from.svn");
						Element param = doc.createElement("param");
						param.setAttribute("name", "url");
						param.setAttribute("value", tokenizer.nextToken());
						antcall.appendChild(param);
						param = doc.createElement("param");
						param.setAttribute("name", "id");
						param.setAttribute("value", tokenizer.nextToken());
						antcall.appendChild(param);
						param = doc.createElement("param");
						param.setAttribute("name", "revision");
						param.setAttribute("value", "HEAD");
						antcall.appendChild(param);
						target.appendChild(antcall);
					}
				}
			}
		}
		root.appendChild(target);
		
		//fetching targets
		if (!cvsTargetsReuired || !svnTargetsReuired) {
			c = doc.createComment(" fetching ");
			root.appendChild(c);
			Element checkTarget = doc.createElement("target");
			checkTarget.setAttribute("name", "check.project.existence");
			Element available = doc.createElement("available");
			available.setAttribute("property", "${id}-exists");
			available.setAttribute("file", "../${id}");
			checkTarget.appendChild(available);
			root.appendChild(checkTarget);
		
			for (Iterator it = fetchTargetList.iterator(); it.hasNext();) {
				root.appendChild((Element) it.next());
			}
			c = doc.createComment(" checkout ");
			root.appendChild(c);
			for (Iterator it = checkoutTargetList.iterator(); it.hasNext();) {
				root.appendChild((Element) it.next());
			}
			c = doc.createComment(" update ");
			root.appendChild(c);
			for (Iterator it = updateTargetList.iterator(); it.hasNext();) {
				root.appendChild((Element) it.next());
			}
		}
	}
	
	protected abstract boolean create(List projects, IProgressMonitor pm) throws Exception;

}
