/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.ant.service;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.higgins.ant.Higgins2AntPlugin;
import org.eclipse.higgins.ant.internal.ui.DataTransferMessages;
import org.eclipse.higgins.ant.internal.ui.IPreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
//import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.widgets.Shell;

public class BuildCreator {
	protected static IPreferenceStore preferenceStore = null;
	
	//protected static String BUILD_XML = "build.xml";

	//protected static String DEP_XML = "dependencies.xml";

	//protected static String PSF_XML = "project.psf";

	//protected static String PSF_DEP_XML = "projectWithDeps.psf";
	
    protected static final String WARNING = " WARNING: Eclipse auto-generated file." + ExportUtil.NEWLINE + //$NON-NLS-1$
                                            "              Any modifications will be overwritten."; //$NON-NLS-1$
    
//    private static IProjectManager projectManager = ExtensionManager.createProjectManager();
	protected static IProjectManager projectManager = AbstractProjectManager.getInstance(); 

	public static List createBuildFiles(Set projects, Shell shell, IProgressMonitor pm) throws Exception {
		List res = new ArrayList();
		try {
			createBuildFilesLoop(projects, shell, pm, res);
		} finally {
			if (pm != null) {
				pm.done();
			}
		}
		return res;
	}

	private static void createBuildFilesLoop(Set projects, Shell shell, IProgressMonitor pm, List res) throws Exception {

		// determine files to create/change
		List files = new ArrayList();
		for (Iterator iter = projects.iterator(); iter.hasNext();) {
			Object object = iter.next();
			IFile file = getBuildFile(object);
			if (file != null) {
				files.add(file);
			}
			file = getDependenciesFile(object);
			if (file != null) {
				files.add(file);
			}
			file = getPSFFile(object);
			if (file != null) {
				files.add(file);
			}
			file = getPSFWithDepsFile(object);
			if (file != null) {
				files.add(file);
			}
		}

		// trigger checkout
		Map validator2files = ExportUtil.getFileModificationValidator(files);
		Set confirmedFiles = ExportUtil.validateEdit(shell, validator2files);

		if (pm != null) {
			pm.beginTask(DataTransferMessages.AntBuildfileExportPage_0, confirmedFiles.size());
		}

		for (Iterator iter = projects.iterator(); iter.hasNext(); ) {
			Object object = iter.next();

			createBuildFile(object, confirmedFiles, pm);
			
			if (getCreateDependenciesFiles()) {
				createDependenciesFile(object, confirmedFiles, pm);
			}

			if (getCreatePSFFiles()) {
				createPSFFile(object, confirmedFiles, pm);
			}

			if (getCreateDeepPSFFiles()) {
				createPSFWithDepsFile(object, confirmedFiles, pm);
			}
		}
	}
	
	protected static void createPSFFile(Object object, Set confirmedFiles, IProgressMonitor pm) throws Exception {
		//IProject p = ExportUtil.getProject(object);
		IProject p = projectManager.getProject(object);
		IFile file = getPSFFile(p);
		if (confirmedFiles.contains(file)) {
			if (pm != null) {
				pm.subTask("Creating " + p.getName() + "/" + file.getName());
			}

			ICreator creator = null;
			IProject project = projectManager.getProject(object);
			
			if (project != null) {
				creator = projectManager.getPSFCreator(project);
			}

			if (creator != null) {
				writeFile(file, creator.create(true, false, pm));
			} else {
				//TODO show warning message
			}

			if (pm != null) {
				pm.worked(1);
				if (pm.isCanceled()) {
					throw new InterruptedException();
				}
			}
		}
	}
	
	protected static void createPSFWithDepsFile(Object object, Set confirmedFiles, IProgressMonitor pm) throws Exception {
		//IProject p = ExportUtil.getProject(object);
		IProject p = projectManager.getProject(object);
		IFile file = getPSFWithDepsFile(p);
		if (confirmedFiles.contains(file)) {
			if (pm != null) {
				pm.subTask("Creating " + p.getName() + "/" + file.getName());
			}

			ICreator creator = null;
			IProject project = projectManager.getProject(object);
			
			if (project != null) {
				creator = projectManager.getPSFCreator(project);
			}

			if (creator != null) {
				writeFile(file, creator.create(true, true, pm));
			} else {
				//TODO show warning message
			}

			if (pm != null) {
				pm.worked(1);
				if (pm.isCanceled()) {
					throw new InterruptedException();
				}
			}
		}
	}
	
	protected static void createDependenciesFile(Object object, Set confirmedFiles, IProgressMonitor pm) throws Exception {
		IProject p = projectManager.getProject(object);
		IFile file = getDependenciesFile(p);
		if (confirmedFiles.contains(file)) {
			if (pm != null) {
				pm.subTask("Creating " + p.getName() + "/" + file.getName());
			}

			ICreator creator = projectManager.getDependenciesCreator(p);

			if (creator != null) {
				ByteArrayInputStream is = creator.create(false, true, pm);
				writeFile(file, is);
			} else {
				//TODO show warning message
			}

			if (pm != null) {
				pm.worked(1);
				if (pm.isCanceled()) {
					throw new InterruptedException();
				}
			}
		}
	}
	
	protected static void createBuildFile(Object object, Set confirmedFiles, IProgressMonitor pm) throws Exception {
		//IProject p = ExportUtil.getProject(object);
		IProject p = projectManager.getProject(object);
		IFile file = getBuildFile(p);
		if (confirmedFiles.contains(file)) {
			if (pm != null) {
				pm.subTask("Creating " + p.getName() + "/" + file.getName());
			}

			ICreator creator = projectManager.getBuildFileCreator(object);

			if (creator != null && !projectManager.getProjectName(p).equals("org.eclipse.higgins.auto")) {
				ByteArrayInputStream is = creator.create(false, false, pm);
				writeFile(file, is);
			} else {
				//TODO show warning message
			}
			
			if (pm != null) {
				pm.worked(1);
				if (pm.isCanceled()) {
					throw new InterruptedException();
				}
			}
		}
	}
	
	protected static void writeFile(IFile file, ByteArrayInputStream is) throws CoreException {
		if (is != null) {
			if (file.exists()) {
				if (!ExportUtil.isIdentical(file, is)) {
					file.setContents(is, true, true, null);
				}
			} else {
				file.create(is, true, null);
			}
		}
	}
	
	public static IFile getBuildFile(Object o) {
		IFile f = null;
		//IProject p = ExportUtil.getProject(o);
		IProject p = projectManager.getProject(o);
		if (p != null) {
			f = p.getFile(getBUILD_XML());
		}
		return f;
	}

	public static IFile getDependenciesFile(Object o) {
		IFile f = null;
		IProject p = projectManager.getProject(o);
		if (p != null) {
			f = p.getFile(getDEP_XML());
		}
		return f;
	}

	public static IFile getPSFFile(Object o) {
		IFile f = null;
		IProject p = projectManager.getProject(o);
		if (p != null) {
			f = p.getFile(getPSF_XML());
		}
		return f;
	}

	public static IFile getPSFWithDepsFile(Object o) {
		IFile f = null;
		IProject p = projectManager.getProject(o);
		if (p != null) {
			f = p.getFile(getPSF_DEP_XML());
		}
		return f;
	}

	/*
	public static void setOptions(String buildfilename, String depfilename, String psffilename, String psfdepfilename) {

		if (buildfilename.length() > 0) {
			BUILD_XML = buildfilename;
		}
		if (depfilename.length() > 0) {
			DEP_XML = depfilename;
		}
		if (psffilename.length() > 0) {
			PSF_XML = psffilename;
		}
		if (psfdepfilename.length() > 0) {
			PSF_DEP_XML = psfdepfilename;
		}
	}
	*/
	public static IPreferenceStore getPreferenceStore() {
		if (preferenceStore == null) {
			preferenceStore = Higgins2AntPlugin.getDefault().getPreferenceStore();
		}
		return preferenceStore;
	}
	
	public static String getBUILD_XML() {
		//return BUILD_XML;
		IPreferenceStore store = getPreferenceStore();
		return store.getString(IPreferenceConstants.GENERAL_FILE_NAME_BUILD);
	}

	public static String getDEP_XML() {
		//return PSF_XML;
		IPreferenceStore store = getPreferenceStore();
		return store.getString(IPreferenceConstants.GENERAL_FILE_NAME_DEP);
	}

	public static String getPSF_XML() {
		//return PSF_XML;
		IPreferenceStore store = getPreferenceStore();
		return store.getString(IPreferenceConstants.GENERAL_FILE_NAME_PSF);
	}

	public static String getPSF_DEP_XML() {
		//return PSF_DEP_XML;
		IPreferenceStore store = getPreferenceStore();
		return store.getString(IPreferenceConstants.GENERAL_FILE_NAME_DEEP_PSF);
	}

	public static boolean getCreateBuildFilesForDeps() {
		//return PSF_DEP_XML;
		IPreferenceStore store = getPreferenceStore();
		return store.getBoolean(IPreferenceConstants.GENERAL_CREATE_BUILDFILES_FOR_DEP);
	}

	public static boolean getCreateDependenciesFiles() {
		//return PSF_DEP_XML;
		IPreferenceStore store = getPreferenceStore();
		return store.getBoolean(IPreferenceConstants.GENERAL_CREATE_DEP_FILE);
	}

	public static boolean getCreatePSFFiles() {
		//return PSF_DEP_XML;
		IPreferenceStore store = getPreferenceStore();
		return store.getBoolean(IPreferenceConstants.GENERAL_CREATE_PSF_FILE);
	}

	public static boolean getCreateDeepPSFFiles() {
		//return PSF_DEP_XML;
		IPreferenceStore store = getPreferenceStore();
		return store.getBoolean(IPreferenceConstants.GENERAL_CREATE_DEEP_PSF_FILE);
	}

	public static boolean getAutorunAtStartUp() {
		//return PSF_DEP_XML;
		IPreferenceStore store = getPreferenceStore();
		return store.getBoolean(IPreferenceConstants.GENERAL_AUTORUN_AT_STARTUP);
	}

	public static boolean getAutorunMonitorFileChanges() {
		//return PSF_DEP_XML;
		IPreferenceStore store = getPreferenceStore();
		return store.getBoolean(IPreferenceConstants.GENERAL_AUTORUN_MONITOR_FILE_CHANGES);
	}

	public static String getAutorunMonitorFileNames() {
		//return PSF_DEP_XML;
		IPreferenceStore store = getPreferenceStore();
		return store.getString(IPreferenceConstants.GENERAL_AUTORUN_MONITOR_FILE_NAMES);
	}
}
