package org.eclipse.higgins.ant.autorun;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.higgins.ant.service.BuildCreator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class Startup implements IStartup {

	public void earlyStartup() {

		final IWorkbench workbench = PlatformUI.getWorkbench();
		workbench.getDisplay().asyncExec(new Runnable() {
			public void run() {
				final IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
				if (window != null) {
//					Workspace workspace = (Workspace) ResourcesPlugin.getWorkspace();
//					boolean oldLock = workspace.isTreeLocked();
//					workspace.setTreeLocked(false);
					IProgressService ps = PlatformUI.getWorkbench().getProgressService();
					try {
						ps.runInUI(ps, new IRunnableWithProgress() {

							public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
								// TODO commented next line temporarily until preference page is developed to allow the user 
								// to manage this startup behavior
								if (BuildCreator.getAutorunAtStartUp()) {
									AutorunBuildCreator.createBuildFilesWorkspaceProjects(window.getShell(), monitor);
								}
								IWorkspace workspace = ResourcesPlugin.getWorkspace();
								workspace.addResourceChangeListener(new ResourceChangeListener());
							}}, ResourcesPlugin.getWorkspace().getRoot());
					} catch (InvocationTargetException e) {
						e.printStackTrace();
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
//					workspace.setTreeLocked(oldLock);		
				}
			}
		});

	}

}
