/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.ant.service;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilderFactory;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractCreator implements ICreator {
	protected static final String DEFAULT_EXCLUDES = "**/bin/,**/build/,**/temp.**/,**/doc/,**/cvs/,**/.svn/,**/*.psf,dependencies.xml";

	protected Element root;
	protected Document doc = null;
	protected IProject project;
	protected String projectName;
	protected String projectRoot;
	
	//protected static IProjectManager projectManager = ExtensionManager.createProjectManager();
	protected static IProjectManager projectManager = AbstractProjectManager.getInstance(); 

	protected AbstractCreator() {
		super();
	}
	
	public AbstractCreator(IProject project) {
		Init(project);
	}
	
	protected void Init(IProject project) {
		this.project = project;
        this.projectName = project.getName();
        //this.projectRoot = ExportUtil.getProjectRoot(project);
        this.projectRoot = projectManager.getProjectRoot(project);
	}

	protected void createDoc() throws Exception {
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		this.doc = dbf.newDocumentBuilder().newDocument();
	}

	protected IProject getProject() {
		return project;
	}
	
	protected List getProjects(boolean handleProject, boolean handleSubProjects) {
		List projects = new ArrayList();
		if (handleProject) {
			projects.add(getProject());
		}
		
		if (handleSubProjects) {
			projects.addAll(getSubProjects());
		}
		return projects;
	}

	protected List getSubProjects() {
		return projectManager.getSubProjects(getProject());
	}
	
	public ByteArrayInputStream create(boolean handleProject, boolean handleSubProjects, IProgressMonitor pm) throws Exception {
		ByteArrayInputStream is = null;
		
		List projects = getProjects(handleProject, handleSubProjects);

		if (create(projects, pm)) {
			String xml = ExportUtil.toString(doc);
			is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
		}
	
		return is;
	}
	
	protected abstract boolean create(List projects, IProgressMonitor pm) throws Exception;
}