/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.ant.service;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.w3c.dom.Document;

public interface IProjectManager {
	
	/**
	 * Gets all projects in the workspace supported by this project manager. 
	 */
	public List getWorkspaceProjects();
	
	/**
	 * Gets a set of projects to be build. 
	 * @param projects
	 * @param requiredProjects
	 * @return
	 * @throws JavaModelException
	 */
	public Set getBuildProjects(Iterator projects, boolean requiredProjects) throws JavaModelException;
	
	/**
	 * Gets build file creator for the given project.
	 * @param project
	 * @return
	 * @throws Exception
	 */
	public ICreator getBuildFileCreator(Object project) throws Exception;
	
	public ICreator getPSFCreator(Object project) throws Exception;
	
	public ICreator getDependenciesCreator(Object project) throws Exception;
	
	/**
	 * Gets an instance of IProject for the given project.
	 * @param object
	 * @return
	 */
	public IProject getProject(Object object);

    /**
     * Gets project root for the given project.
	 * @param object
	 * @return
     */
	public String getProjectRoot(Object object);
	
	/**
	 * Gets the name (project id) of the given project.
	 * @param object
	 * @return
	 */
	public String getProjectName(Object object);

	/**
	 * Gets comparator for all projects in the workspace supported by this project manager. 
	 * @return
	 */
	public Comparator getProjectComparator();
	
	public boolean isJavaProject(IProject project);
	public boolean isFeatureProject(IProject project);
	public boolean isPluginProject(IProject project);
	public boolean isSiteProject(IProject project);

	public List getSubProjects(IProject project);
	public void getSubProjects(IProject project, Set set);

	public IJavaProject getJavaProject(IProject project);

    /**
     * Get Java project for given root.
     */
	public IJavaProject getJavaProject(String root);
	
    /**
     * Get Java project from resource.
     */
	public IJavaProject getJavaProjectByName(String name);
	
    /**
     * Gets all directly and indirectly dependent projects for the given project.
     * 
     * @return set of IJavaProject objects
     */
	public List getClasspathProjectsRecursive(Object object) throws JavaModelException;
	
	/**
	 * Gets template with the specified name.  
	 * @param bundle TODO
	 * @param name
	 * @return
	 */
	public Document getTemplate(String bundle, String name);
}
