/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.ant.core;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

import org.eclipse.core.resources.IProject;
import org.eclipse.higgins.ant.service.AbstractProjectManager;
import org.eclipse.higgins.ant.service.ICreator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectManager extends AbstractProjectManager {
	
	public ProjectManager() {
		//System.out.println("ProjectManager() for java project");
	}
	
	public Set getBuildProjects(Iterator projects, boolean requiredProjects) throws JavaModelException {
		Set res = new TreeSet(getProjectComparator());
        while (projects.hasNext()) {
        	IProject project = (IProject) projects.next();
        	if (isJavaProject(project)) {
                IJavaProject javaProject = getJavaProject(project);
                if (requiredProjects){
                	res.addAll(getClasspathProjectsRecursive(javaProject));
                }
                res.add(javaProject);
        	}
        }
        return res;
	}
	
	public IProject getProject(Object o) {
		IProject p = null;
		if (o instanceof IProject) {
			p = (IProject) o;
		} else if (o instanceof IJavaProject) {
			p = getProject((IJavaProject) o);
		} else if (o instanceof String) {
			p = getProject((String) o); 
		}
		return p;
	}

	private static IProject getProject(IJavaProject p) {
		return p.getProject();
	}
	
	public ICreator getBuildFileCreator(Object project) throws Exception {
		ICreator creator = null;
		if (project instanceof IJavaProject) {
			creator = new JavaProjectBuildFileCreator((IJavaProject) project);
		}
		return creator;
	}

	public ICreator getDependenciesCreator(Object project) throws Exception {
		ICreator creator = null;
		if (project instanceof IProject) {
			creator = new DependenciesCreator((IProject) project);
		}
		return creator;
	}

	public ICreator getPSFCreator(Object project) throws Exception {
		ICreator creator = null;
		if (project instanceof IProject) {
			creator = new PSFCreator((IProject) project);
		}
		return creator;
	}
	
	public ICreator getProjectBuildFileCreator(Object project) throws Exception {
		ICreator creator = null;
		if (project instanceof IJavaProject) {
			creator = new JavaProjectBuildFileCreator((IJavaProject) project);
		}
		return creator;
	}
}
