/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ant.pde;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.higgins.ant.pde.ProjectManager;
import org.eclipse.higgins.ant.service.AbstractBuildFileCreator;
import org.eclipse.higgins.ant.service.EclipseClasspath;
import org.eclipse.higgins.ant.service.ExportUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FeatureBuildFileCreator
extends AbstractBuildFileCreator {
    protected IFeatureModel model;
    protected IFeature feature;

    public FeatureBuildFileCreator() {
    }

    public FeatureBuildFileCreator(IFeatureModel model) {
        super(projectManager.getProject((Object)model));
        this.model = model;
        this.feature = this.model.getFeature();
    }

    protected void Init(IProject project) {
        super.Init(project);
        this.model = ((ProjectManager)projectManager).getFeatureModel(project);
        this.feature = this.model.getFeature();
    }

    private void addSubProperties() throws JavaModelException {
        String location = String.valueOf(this.projectName) + ".location";
        String relativePath = ExportUtil.getRelativePath((String)this.projectRoot, (String)this.projectRoot);
        this.variable2valueMap.put(location, relativePath);
        List list = this.getSubProjects();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IProject subProject = projectManager.getProject(iterator.next());
            location = String.valueOf(projectManager.getProjectName((Object)subProject)) + ".location";
            String subProjectRoot = projectManager.getProjectRoot((Object)subProject);
            relativePath = ExportUtil.getRelativePath((String)subProjectRoot, (String)this.projectRoot);
            this.variable2valueMap.put(location, relativePath);
        }
    }

    public void createFeature() {
        try {
            Document tdoc = projectManager.getTemplate("higgins2ant.pde", "featureBuilder");
            Element troot = tdoc.getDocumentElement();
            NodeList nl = troot.getChildNodes();
            int length = nl.getLength();
            int i = 0;
            while (i < length) {
                Node n = nl.item(i);
                Node n1 = this.doc.importNode(n, true);
                if (n1.getNodeType() == 1) {
                    Element e = (Element)n1;
                    if (e.getNodeName().equals("target") && e.getAttribute("name").equals("-initFeatureSources")) {
                        this.createInitFeatureSources(e);
                    } else if (e.getNodeName().equals("target") && e.getAttribute("name").equals("-updateFeatureSources")) {
                        this.createUpdateFeatureSources(e);
                    }
                }
                this.root.appendChild(n1);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createUpdateFeatureSources(Element target) throws JavaModelException {
        this.createCopyProjectSources(target, this.model, true);
        List subProjects = this.getSubProjects();
        Iterator iterator = subProjects.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof IFeatureModel)) continue;
            this.createCopyProjectSources(target, o, true);
        }
    }

    private void createInitFeatureSources(Element target) throws JavaModelException {
        this.createCopyProjectSources(target, this.model, false);
        List subProjects = this.getSubProjects();
        Iterator iterator = subProjects.iterator();
        while (iterator.hasNext()) {
            this.createCopyProjectSources(target, iterator.next(), false);
        }
    }

    private void createCopyProjectSources(Element target, Object project, boolean update) throws JavaModelException {
        if (project instanceof IFeatureModel) {
            this.createCopyProjectSources(target, (IFeatureModel)project, update);
        } else if (project instanceof IJavaProject) {
            this.createCopyProjectSources(target, (IJavaProject)project, update);
        } else if (project instanceof IProject) {
            this.createCopyProjectSources(target, (IProject)project, update);
        }
    }

    private void createCopyProjectSources(Element target, IProject project, boolean update) {
        String projectName = projectManager.getProjectName((Object)project);
        Element copy = this.doc.createElement("copy");
        copy.setAttribute("todir", "${temp.dir.plugins}/" + projectName);
        copy.setAttribute("failonerror", "true");
        Element fileset = this.doc.createElement("fileset");
        fileset.setAttribute("dir", "${" + projectName + ".location}");
        fileset.setAttribute("excludes", "**/bin/,**/build/,**/temp.**/,**/doc/,**/cvs/,**/.svn/,**/*.psf,dependencies.xml");
        copy.appendChild(fileset);
        target.appendChild(copy);
    }

    private void createCopyProjectSources(Element target, IFeatureModel model, boolean update) {
        Element fileset;
        Element copy;
        String projectName = projectManager.getProjectName((Object)model);
        if (!update) {
            copy = this.doc.createElement("copy");
            copy.setAttribute("todir", "${temp.dir.features}/" + projectName);
            copy.setAttribute("failonerror", "true");
            copy.setAttribute("overwrite", "true");
            fileset = this.doc.createElement("fileset");
            fileset.setAttribute("dir", "${" + projectName + ".location}");
            fileset.setAttribute("excludes", "**/bin/,**/build/,**/temp.**/,**/doc/,**/cvs/,**/.svn/,**/*.psf,dependencies.xml,build.xml,feature.xml");
            copy.appendChild(fileset);
            target.appendChild(copy);
        }
        copy = this.doc.createElement("copy");
        copy.setAttribute("todir", "${temp.dir.features}/" + projectName);
        copy.setAttribute("failonerror", "true");
        copy.setAttribute("overwrite", "true");
        fileset = this.doc.createElement("fileset");
        fileset.setAttribute("dir", "${" + projectName + ".location}");
        fileset.setAttribute("includes", "feature.xml");
        copy.appendChild(fileset);
        if (!update) {
            copy.setAttribute("encoding", "UTF-8");
            Element filterchain = this.doc.createElement("filterchain");
            copy.appendChild(filterchain);
            Element tokenfilter = this.doc.createElement("tokenfilter");
            filterchain.appendChild(tokenfilter);
            Element replaceregex = this.doc.createElement("replaceregex");
            tokenfilter.appendChild(replaceregex);
            replaceregex.setAttribute("pattern", "os=\\x22.*\\x22");
            replaceregex.setAttribute("replace", "os=\"*\"");
            replaceregex = this.doc.createElement("replaceregex");
            tokenfilter.appendChild(replaceregex);
            replaceregex.setAttribute("pattern", "ws=\\x22.*\\x22");
            replaceregex.setAttribute("replace", "ws=\"*\"");
            replaceregex = this.doc.createElement("replaceregex");
            tokenfilter.appendChild(replaceregex);
            replaceregex.setAttribute("pattern", "arch=\\x22.*\\x22");
            replaceregex.setAttribute("replace", "arch=\"*\"");
        }
        target.appendChild(copy);
    }

    private void createCopyProjectSources(Element target, IJavaProject project, boolean update) throws JavaModelException {
        EclipseClasspath classpath = new EclipseClasspath(project);
        String projectName = projectManager.getProjectName((Object)project);
        Element copy = this.doc.createElement("copy");
        copy.setAttribute("todir", "${temp.dir.plugins}/" + projectName);
        copy.setAttribute("failonerror", "true");
        Element fileset = this.doc.createElement("fileset");
        fileset.setAttribute("dir", "${" + projectName + ".location}");
        fileset.setAttribute("excludes", "**/bin/,**/build/,**/temp.**/,**/doc/,**/cvs/,**/.svn/,**/*.psf,dependencies.xml");
        copy.appendChild(fileset);
        if (classpath.getSrcDirs().size() > 0) {
            int size = classpath.getSrcDirs().size();
            int i = 0;
            while (i < size) {
                String srcDir = (String)classpath.getSrcDirs().get(i);
                if (!EclipseClasspath.isReference((String)srcDir)) {
                    List exclusions = (List)classpath.getExclusionLists().get(i);
                    Iterator iter = exclusions.iterator();
                    while (iter.hasNext()) {
                        String exclusion = (String)iter.next();
                        Element excludeElement = this.doc.createElement("exclude");
                        excludeElement.setAttribute("name", String.valueOf(srcDir) + "/" + exclusion);
                        fileset.appendChild(excludeElement);
                    }
                }
                ++i;
            }
        }
        String target_ = project.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true);
        String oldTarget_ = (String)this.variable2valueMap.get("target");
        if (oldTarget_ != null && oldTarget_.compareTo(target_) < 0) {
            target_ = oldTarget_;
        }
        this.variable2valueMap.put("target", target_);
        String source = project.getOption("org.eclipse.jdt.core.compiler.source", true);
        String oldSource = (String)this.variable2valueMap.get("source");
        if (oldSource != null && oldSource.compareTo(source) < 0) {
            source = oldSource;
        }
        this.variable2valueMap.put("source", source);
        target.appendChild(copy);
    }

    protected void createProperty() {
        Node node;
        LinkedHashMap<String, Object> v2p = new LinkedHashMap<String, Object>();
        Comment c = this.doc.createComment(" ======================================== ");
        v2p.put("c1", c);
        v2p.put("sources.dir", "${basedir}/..");
        v2p.put("build.dir", "${basedir}/build");
        v2p.put("build.dir.bin", "${build.dir}/bin");
        v2p.put("build.dir.lib", "${build.dir}/lib");
        v2p.put("build.dir.doc", "${build.dir}/doc");
        c = this.doc.createComment(" ======================================== ");
        v2p.put("c1.1", c);
        String jarName = this.projectName;
        jarName = jarName.replaceAll("org\\.eclipse\\.higgins", "higgins");
        jarName = jarName.replaceAll("\\.", "-");
        v2p.put("build.file.name", jarName);
        boolean first = true;
        try {
            Document tdoc = projectManager.getTemplate("higgins2ant.pde", "featureProperties");
            Element troot = tdoc.getDocumentElement();
            NodeList nl = troot.getChildNodes();
            int length = nl.getLength();
            first = true;
            node = this.root.getFirstChild();
            int i = 0;
            while (i < length) {
                Node n = nl.item(i);
                Node n1 = this.doc.importNode(n, true);
                if (first) {
                    first = false;
                } else {
                    node = node.getNextSibling();
                }
                node = this.root.insertBefore(n1, node);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        first = true;
        node = this.root.getFirstChild();
        Iterator iterator = v2p.keySet().iterator();
        while (iterator.hasNext()) {
            Node prop = null;
            String key = (String)iterator.next();
            Object o = v2p.get(key);
            if (o instanceof Node) {
                prop = (Node)o;
            } else if (o instanceof String) {
                String value = (String)o;
                Element e = this.doc.createElement("property");
                e.setAttribute("name", key);
                e.setAttribute("value", value);
                prop = e;
            }
            if (prop == null) continue;
            if (first) {
                first = false;
            } else {
                node = node.getNextSibling();
            }
            node = this.root.insertBefore(prop, node);
        }
    }

    protected void createPropertyM() {
        boolean first = true;
        Node node = this.root.getFirstChild();
        Iterator iterator = this.variable2valueMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)this.variable2valueMap.get(key);
            Element prop = this.doc.createElement("property");
            prop.setAttribute("name", key);
            prop.setAttribute("value", value);
            if (first) {
                first = false;
            } else {
                node = node.getNextSibling();
            }
            node = this.root.insertBefore(prop, node);
        }
        IPath home = JavaCore.getClasspathVariable((String)"ECLIPSE_HOME");
        String home_ecl = home.toString();
        Element ecl = this.doc.createElement("property");
        ecl.setAttribute("name", "ECLIPSE_HOME");
        ecl.setAttribute("value", home_ecl);
        this.root.insertBefore(ecl, this.root.getFirstChild());
    }

    protected boolean create(List projects, IProgressMonitor pm) throws Exception {
        this.createDoc();
        this.createRoot("feature");
        this.createFeature();
        this.createFetch();
        this.addSubProperties();
        this.createProperty();
        this.createPropertyM();
        return true;
    }
}

