/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ant.pde;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.higgins.ant.core.JavaProjectBuildFileCreator;
import org.eclipse.higgins.ant.pde.FeatureBuildFileCreator;
import org.eclipse.higgins.ant.pde.SiteBuildFileCreator;
import org.eclipse.higgins.ant.service.ICreator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteModel;

public class ProjectManager
extends org.eclipse.higgins.ant.core.ProjectManager {
    private final String SITE_XML = "site.xml";

    protected void addFeatureProjects(List projects) {
        if (projects == null) {
            projects = new ArrayList<IProject>();
        }
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        try {
            IFeatureModel[] features = manager.getWorkspaceModels();
            int i = 0;
            while (i < features.length) {
                projects.add(ProjectManager.getProject(features[i]));
                ++i;
            }
        }
        catch (Exception exception) {
            IFeatureModel[] features = new IFeatureModel[]{};
        }
    }

    public List getWorkspaceProjects() {
        ArrayList projects = new ArrayList();
        this.addJavaProjects(projects);
        this.addFeatureProjects(projects);
        this.addOtherProjects(projects);
        return projects;
    }

    protected boolean addFeatureProject(Set projects, IProject project, boolean requiredProjects) throws JavaModelException {
        boolean res = false;
        if (this.isFeatureProject(project)) {
            IFeatureModel model = this.getFeatureModel(project);
            if (requiredProjects) {
                IFeaturePlugin[] plugins = model.getFeature().getPlugins();
                int i = 0;
                while (i < plugins.length) {
                    IJavaProject javaProject = this.getJavaProject(plugins[i]);
                    if (javaProject != null) {
                        projects.addAll(this.getClasspathProjectsRecursive(javaProject));
                    }
                    ++i;
                }
            }
            projects.add(model);
            res = true;
        }
        return res;
    }

    protected boolean addSiteProject(Set projects, IProject project, boolean requiredProjects) {
        boolean res = false;
        if (this.isSiteProject(project)) {
            projects.add(project);
        }
        return res;
    }

    public Set getBuildProjects(Iterator projects, boolean requiredProjects) throws JavaModelException {
        TreeSet res = new TreeSet(this.getProjectComparator());
        while (projects.hasNext()) {
            IProject project = (IProject)projects.next();
            if (this.addJavaProject(res, project, requiredProjects) || this.addFeatureProject(res, project, requiredProjects)) continue;
            this.addSiteProject(res, project, requiredProjects);
        }
        return res;
    }

    public ICreator getBuildFileCreator(Object project) throws Exception {
        Object creator = null;
        if (project instanceof IJavaProject) {
            creator = new JavaProjectBuildFileCreator((IJavaProject)project);
        } else if (project instanceof IFeatureModel) {
            creator = new FeatureBuildFileCreator((IFeatureModel)project);
        } else if (project instanceof IProject) {
            IProject p = (IProject)project;
            if (this.isJavaProject(p)) {
                IJavaProject jp = this.getJavaProject(p);
                creator = this.getBuildFileCreator(jp);
            } else if (this.isFeatureProject(p)) {
                IFeatureModel m = this.getFeatureModel(p);
                creator = this.getBuildFileCreator(m);
            } else if (this.isSiteProject(p)) {
                creator = new SiteBuildFileCreator(p);
            }
        }
        return creator;
    }

    private IJavaProject getJavaProject(IFeaturePlugin plugin) {
        IJavaProject javaProject = null;
        IProject project = ProjectManager.getProject(plugin);
        if (project != null) {
            javaProject = this.getJavaProject(project);
        }
        return javaProject;
    }

    public IProject getProject(Object o) {
        IProject p = super.getProject(o);
        if (p == null) {
            if (o instanceof IFeatureModel) {
                p = ProjectManager.getProject((IFeatureModel)o);
            } else if (o instanceof IFeaturePlugin) {
                p = ProjectManager.getProject((IFeaturePlugin)o);
            }
        }
        return p;
    }

    private static IProject getProject(IJavaProject p) {
        return p.getProject();
    }

    private static IProject getProject(IFeatureModel m) {
        IProject p = null;
        IResource r = m.getUnderlyingResource();
        if (r != null) {
            p = r.getProject();
        }
        return p;
    }

    private static IProject getProject(IFeaturePlugin fp) {
        IResource r;
        IProject p = null;
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        IPluginModelBase pm = manager.findModel(fp.getId());
        if (pm != null && (r = pm.getUnderlyingResource()) != null) {
            p = r.getProject();
        }
        return p;
    }

    protected boolean getFeatureSubProjects(IProject project, Set set) {
        boolean res = false;
        try {
            if (this.isFeatureProject(project)) {
                res = true;
                IFeatureModel model = this.getFeatureModel(project);
                if (model != null) {
                    IFeaturePlugin[] plugins;
                    IFeatureChild[] features = model.getFeature().getIncludedFeatures();
                    if (features != null) {
                        int i = 0;
                        while (i < features.length) {
                            IFeatureModel m = this.getFeatureModel(features[i].getId());
                            if (m != null && !set.contains(m)) {
                                set.add(m);
                                this.getSubProjects(ProjectManager.getProject(m), set);
                            }
                            ++i;
                        }
                    }
                    if ((plugins = model.getFeature().getPlugins()) != null) {
                        int i = 0;
                        while (i < plugins.length) {
                            IProject p = ProjectManager.getProject(plugins[i]);
                            if (p != null) {
                                IJavaProject javaProject = this.getJavaProject(plugins[i]);
                                if (javaProject == null) {
                                    set.add(p);
                                } else if (!set.contains(javaProject)) {
                                    set.add(javaProject);
                                    List l = this.getClasspathProjectsRecursive(javaProject);
                                    int j = 0;
                                    while (j < l.size()) {
                                        set.add(this.getProject(l.get(j)));
                                        ++j;
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return res;
    }

    protected boolean getSiteSubProjects(IProject project, Set set) {
        boolean res = false;
        if (this.isSiteProject(project)) {
            IFeatureModel[] models = this.getFeatureModels(project);
            int i = 0;
            while (i < models.length) {
                IFeatureModel model = models[i];
                if (!set.contains(model)) {
                    set.add(model);
                    this.getSubProjects(ProjectManager.getProject(model), set);
                }
                ++i;
            }
        }
        return res;
    }

    public void getSubProjects(IProject project, Set set) {
        if (!this.getSiteSubProjects(project, set) && !this.getFeatureSubProjects(project, set)) {
            this.getJavaSubProjects(project, set);
        }
    }

    protected IFeatureModel getFeatureModel(IProject project) {
        IFeatureModel model = null;
        if (WorkspaceModelManager.isFeatureProject((IProject)project)) {
            model = this.getFeatureModel(project.getName());
        }
        return model;
    }

    protected IFeatureModel getFeatureModel(String id) {
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel model = null;
        IFeatureModel[] models = manager.getWorkspaceModels();
        int i = 0;
        while (i < models.length) {
            if (id.equals(models[i].getFeature().getId())) {
                model = models[i];
                break;
            }
            ++i;
        }
        return model;
    }

    private ISiteModel getSiteModel(IProject project) {
        WorkspaceSiteModel model = null;
        if (this.isSiteProject(project)) {
            IFile siteXml = project.getFile("site.xml");
            model = new WorkspaceSiteModel(siteXml);
            try {
                model.load();
            }
            catch (CoreException coreException) {
                model = null;
            }
        }
        return model;
    }

    protected IFeatureModel[] getFeatureModels(ISiteModel siteModel) {
        ArrayList<IFeatureModel> models = new ArrayList<IFeatureModel>();
        if (siteModel != null) {
            ISiteFeature[] sbFeatures = siteModel.getSite().getFeatures();
            int i = 0;
            while (i < sbFeatures.length) {
                ISiteFeature siteFeature = sbFeatures[i];
                IFeatureModel model = this.getFeatureModel(siteFeature.getId());
                if (model != null) {
                    models.add(model);
                }
                ++i;
            }
        }
        return models.toArray(new IFeatureModel[models.size()]);
    }

    protected IFeatureModel[] getFeatureModels(IProject project) {
        return this.getFeatureModels(this.getSiteModel(project));
    }
}

