/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ant.autorun;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.higgins.ant.service.BuildCreator;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Shell;

public class AutorunBuildCreator
extends BuildCreator {
    public static void createBuildFilesWorkspaceProjects(Shell shell, IProgressMonitor monitor) {
        List projectsList = projectManager.getWorkspaceProjects();
        try {
            Set projects = projectManager.getBuildProjects(projectsList.iterator(), false);
            AutorunBuildCreator.createBuildFiles(projects, null, monitor);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Set getBuildProjects(IProject project) throws JavaModelException {
        Set projects = null;
        ArrayList<IProject> projectsList = new ArrayList<IProject>(1);
        projectsList.add(project);
        projects = projectManager.getBuildProjects(projectsList.iterator(), false);
        return projects;
    }

    public static void createBuildFiles(IProject project, Shell shell, IProgressMonitor monitor) throws Exception {
        Set projects = AutorunBuildCreator.getBuildProjects(project);
        AutorunBuildCreator.createBuildFiles(projects, shell, monitor);
    }

    private static Set findDependentProjects(Set projects) {
        TreeSet<IProject> res = new TreeSet<IProject>(projectManager.getProjectComparator());
        List list = projectManager.getWorkspaceProjects();
        Iterator itr = projects.iterator();
        while (itr.hasNext()) {
            IProject project = (IProject)itr.next();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IProject proj = projectManager.getProject(iterator.next());
                TreeSet projs = new TreeSet(projectManager.getProjectComparator());
                projectManager.getSubProjects(proj, projs);
                if (!projs.contains(project) || res.contains(proj)) continue;
                res.add(proj);
            }
        }
        return res;
    }

    public static void createDependentBuildFiles(Set list, Shell shell, IProgressMonitor monitor) throws Exception {
        Set projects = AutorunBuildCreator.findDependentProjects(list);
        projects.addAll(list);
        AutorunBuildCreator.createBuildFiles(projects, shell, monitor);
    }
}

