/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ant.autorun;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.higgins.ant.autorun.AutorunBuildCreator;
import org.eclipse.higgins.ant.service.AbstractProjectManager;
import org.eclipse.higgins.ant.service.BuildCreator;
import org.eclipse.higgins.ant.service.IProjectManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ResourceChangeListener
implements IResourceChangeListener {
    protected static final String MANIFEST = "META-INF/MANIFEST.MF";
    protected static final String PLUGIN_XML = "plugin.xml";
    protected static final String SITE_XML = "site.xml";
    protected static final String FEATURE_XML = "feature.xml";
    protected static final String DOT_PROJECT = ".project";
    protected static final String DOT_CLASSPATH = ".classpath";
    protected static final String[] fileNames = new String[]{".project", ".classpath", "plugin.xml", "feature.xml", "site.xml", "META-INF/MANIFEST.MF"};
    protected static final IPath[] files = ResourceChangeListener.getMonitorFilePath();
    protected static IProjectManager projectManager = AbstractProjectManager.getInstance();

    private static IPath[] getMonitorFilePath() {
        IPath[] files = null;
        String s = BuildCreator.getAutorunMonitorFileNames();
        StringTokenizer st = new StringTokenizer(s, ",", false);
        int count = st.countTokens();
        files = new IPath[count];
        int i = 0;
        while (i < count) {
            files[i] = new Path(st.nextToken().trim());
            ++i;
        }
        return files;
    }

    private Set getProjectRecursive(IResourceDelta delta) {
        TreeSet result = new TreeSet(projectManager.getProjectComparator());
        this.getProjectRecursive(delta, result);
        return result;
    }

    private void getProjectRecursive(IResourceDelta delta, Set set) {
        IResource resource = delta.getResource();
        if (resource instanceof IProject) {
            int i = 0;
            while (i < files.length) {
                IResourceDelta d = delta.findMember(files[i]);
                if (d != null && d.getKind() == 4 && (d.getFlags() & 0x100) == 256) {
                    set.add(resource);
                    break;
                }
                ++i;
            }
        } else {
            IResourceDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.getProjectRecursive(children[i], set);
                ++i;
            }
        }
    }

    private void createBuildFiles(Set set) {
        if (set.isEmpty()) {
            return;
        }
        try {
            final Set projects = set;
            final IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                    if (window != null) {
                        IProgressService ps = PlatformUI.getWorkbench().getProgressService();
                        try {
                            ps.runInUI((IRunnableContext)ps, new IRunnableWithProgress(this, projects, window){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ Set val$projects;
                                private final /* synthetic */ IWorkbenchWindow val$window;
                                {
                                    this.this$1 = var1_1;
                                    this.val$projects = set;
                                    this.val$window = iWorkbenchWindow;
                                }

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    try {
                                        AutorunBuildCreator.createDependentBuildFiles(this.val$projects, this.val$window.getShell(), monitor);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (BuildCreator.getAutorunMonitorFileChanges()) {
            switch (event.getType()) {
                case 1: {
                    Set projects = this.getProjectRecursive(event.getDelta());
                    this.createBuildFiles(projects);
                }
            }
        }
    }
}

