/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ant.service;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.higgins.ant.Higgins2AntPlugin;
import org.eclipse.higgins.ant.service.AbstractCreator;
import org.eclipse.higgins.ant.service.ExportUtil;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.TeamException;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;

public abstract class AbstractBuildFileCreator
extends AbstractCreator {
    protected static final String IMPORT_BUILDFILE_PROCESSING_TARGET = "eclipse.ant.import";
    protected static final String WARNING = " WARNING: Higgins2Ant v {0} auto-generated file." + ExportUtil.NEWLINE + "              Any modifications will be overwritten.";
    protected static final String NOTE = "              To include a user specific buildfile here, simply create one in the same" + ExportUtil.NEWLINE + "              directory with the processing instruction " + "<?" + "eclipse.ant.import" + "?>" + ExportUtil.NEWLINE + "              as the first entry and export the buildfile again. ";
    protected static final String COMMENT_SEPARATOR = " ======================================== ";
    protected Map variable2valueMap = new LinkedHashMap();

    public AbstractBuildFileCreator() {
    }

    public AbstractBuildFileCreator(IProject project) {
        super(project);
    }

    protected void Init(IProject project) {
        super.Init(project);
    }

    protected void createRoot(String defaultTarget) {
        this.root = this.doc.createElement("project");
        this.root.setAttribute("name", this.projectName);
        this.root.setAttribute("default", defaultTarget);
        this.root.setAttribute("basedir", ".");
        this.doc.appendChild(this.root);
        String v = MessageFormat.format(WARNING, Higgins2AntPlugin.getDefault().getVersion());
        Comment comment = this.doc.createComment(String.valueOf(v) + ExportUtil.NEWLINE + NOTE);
        this.doc.insertBefore(comment, this.root);
    }

    protected void createFetch() throws JavaModelException {
        Comment c = this.doc.createComment(COMMENT_SEPARATOR);
        this.root.appendChild(c);
        c = this.doc.createComment(" Fetch dependencies ");
        this.root.appendChild(c);
        Element target = this.doc.createElement("target");
        target.setAttribute("name", "fetch.dependencies");
        List dependencies = projectManager.getSubProjects(this.project);
        HashMap<String, TreeSet<IProject>> byProvider = new HashMap<String, TreeSet<IProject>>();
        int i = 0;
        while (i < dependencies.size()) {
            RepositoryProvider provider;
            IProject p = projectManager.getProject(dependencies.get(i));
            if (p != null && (provider = RepositoryProvider.getProvider((IProject)p)) != null) {
                String id = provider.getID();
                TreeSet<IProject> list = (TreeSet<IProject>)byProvider.get(id);
                if (list == null) {
                    list = new TreeSet<IProject>(projectManager.getProjectComparator());
                    byProvider.put(id, list);
                }
                list.add(p);
            }
            ++i;
        }
        Comparator comparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((Element)arg0).getAttribute("name").compareTo(((Element)arg1).getAttribute("name"));
            }
        };
        TreeSet<Element> fetchTargetList = new TreeSet<Element>(comparator);
        TreeSet<Element> checkoutTargetList = new TreeSet<Element>(comparator);
        TreeSet<Element> updateTargetList = new TreeSet<Element>(comparator);
        boolean taskdefReqired = true;
        boolean cvsTargetsReuired = true;
        boolean svnTargetsReuired = true;
        Iterator providersIt = byProvider.keySet().iterator();
        while (providersIt.hasNext()) {
            Element param;
            Element antcall;
            StringTokenizer tokenizer;
            Element echo;
            String id = (String)providersIt.next();
            Set list = (Set)byProvider.get(id);
            IProject[] projectArray = list.toArray(new IProject[list.size()]);
            RepositoryProviderType providerType = RepositoryProviderType.getProviderType((String)id);
            ProjectSetCapability capability = providerType.getProjectSetCapability();
            ProjectSetCapability.ensureBackwardsCompatible((RepositoryProviderType)providerType, (ProjectSetCapability)capability);
            String[] references = null;
            if (capability != null) {
                try {
                    references = capability.asReference(projectArray, new ProjectSetSerializationContext(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (TeamException e) {
                    e.printStackTrace();
                }
            }
            if (references == null) continue;
            if ("org.eclipse.team.cvs.core.cvsnature".equalsIgnoreCase(id)) {
                if (cvsTargetsReuired) {
                    Element element = this.doc.createElement("target");
                    element.setAttribute("name", "fetch.from.cvs");
                    element.setAttribute("depends", "check.project.existence,checkout.dependency.cvs,update.dependency.cvs");
                    echo = this.doc.createElement("echo");
                    echo.setAttribute("message", "fetch of ${id} - comlete");
                    element.appendChild(echo);
                    fetchTargetList.add(element);
                    element = this.doc.createElement("target");
                    element.setAttribute("name", "checkout.dependency.cvs");
                    element.setAttribute("unless", "${id}-exists");
                    Element cvs = this.doc.createElement("cvs");
                    cvs.setAttribute("cvsRoot", "${cvsroot}");
                    cvs.setAttribute("package", "${path}");
                    cvs.setAttribute("command", "checkout -d ../${id}");
                    cvs.setAttribute("tag", "${revision}");
                    cvs.setAttribute("taskname", "cvs - checkout ${id}");
                    element.appendChild(cvs);
                    checkoutTargetList.add(element);
                    element = this.doc.createElement("target");
                    element.setAttribute("name", "update.dependency.cvs");
                    element.setAttribute("if", "${id}-exists");
                    cvs = this.doc.createElement("cvs");
                    cvs.setAttribute("command", "update ../${id}");
                    element.appendChild(cvs);
                    updateTargetList.add(element);
                    cvsTargetsReuired = false;
                }
                int i2 = 0;
                while (i2 < references.length) {
                    tokenizer = new StringTokenizer(references[i2], ",");
                    tokenizer.nextToken();
                    antcall = this.doc.createElement("antcall");
                    antcall.setAttribute("target", "fetch.from.cvs");
                    param = this.doc.createElement("param");
                    param.setAttribute("name", "cvsroot");
                    param.setAttribute("value", tokenizer.nextToken());
                    antcall.appendChild(param);
                    param = this.doc.createElement("param");
                    param.setAttribute("name", "path");
                    param.setAttribute("value", tokenizer.nextToken());
                    antcall.appendChild(param);
                    param = this.doc.createElement("param");
                    param.setAttribute("name", "id");
                    param.setAttribute("value", tokenizer.nextToken());
                    antcall.appendChild(param);
                    param = this.doc.createElement("param");
                    param.setAttribute("name", "revision");
                    param.setAttribute("value", "HEAD");
                    antcall.appendChild(param);
                    target.appendChild(antcall);
                    ++i2;
                }
                continue;
            }
            if (!"org.eclipse.team.svn.core.svnnature".equalsIgnoreCase(id) && !"org.tigris.subversion.subclipse.core.svnnature".equalsIgnoreCase(id) && !"org.polarion.team.svn.core.svnnature".equalsIgnoreCase(id)) continue;
            if (taskdefReqired) {
                Element defaultSVNTaskDefTarget = this.doc.createElement("target");
                defaultSVNTaskDefTarget.setAttribute("unless", "svn.lib.path");
                defaultSVNTaskDefTarget.setAttribute("name", "default.svn.task.def");
                Element svnTaskDef = this.doc.createElement("taskdef");
                svnTaskDef.setAttribute("resource", "org/tigris/subversion/svnant/svnantlib.xml");
                defaultSVNTaskDefTarget.appendChild(svnTaskDef);
                Element svnTaskDefTarget = this.doc.createElement("target");
                svnTaskDefTarget.setAttribute("if", "svn.lib.path");
                svnTaskDefTarget.setAttribute("name", "svn.task.def");
                Element path = this.doc.createElement("path");
                path.setAttribute("id", "svn.classpath");
                Element pathelement = this.doc.createElement("pathelement");
                pathelement.setAttribute("location", "${svn.lib.path}/svnant.jar");
                path.appendChild(pathelement);
                pathelement = this.doc.createElement("pathelement");
                pathelement.setAttribute("location", "${svn.lib.path}/svnjavahl.jar");
                path.appendChild(pathelement);
                pathelement = this.doc.createElement("pathelement");
                pathelement.setAttribute("location", "${svn.lib.path}/javasvn.jar");
                path.appendChild(pathelement);
                pathelement = this.doc.createElement("pathelement");
                pathelement.setAttribute("location", "${svn.lib.path}/svnClientAdapter.jar");
                path.appendChild(pathelement);
                svnTaskDefTarget.appendChild(path);
                svnTaskDef = this.doc.createElement("taskdef");
                svnTaskDef.setAttribute("resource", "org/tigris/subversion/svnant/svnantlib.xml");
                svnTaskDef.setAttribute("classpathref", "svn.classpath");
                svnTaskDefTarget.appendChild(svnTaskDef);
                target.setAttribute("depends", "default.svn.task.def,svn.task.def");
                this.root.appendChild(defaultSVNTaskDefTarget);
                this.root.appendChild(svnTaskDefTarget);
                taskdefReqired = false;
            }
            if (svnTargetsReuired) {
                Element element = this.doc.createElement("target");
                element.setAttribute("name", "fetch.from.svn");
                element.setAttribute("depends", "check.project.existence,checkout.dependency.svn,update.dependency.svn");
                echo = this.doc.createElement("echo");
                echo.setAttribute("message", "fetch of ${id} - comlete");
                element.appendChild(echo);
                fetchTargetList.add(element);
                element = this.doc.createElement("target");
                element.setAttribute("name", "checkout.dependency.svn");
                element.setAttribute("unless", "${id}-exists");
                Element svn = this.doc.createElement("svn");
                svn.setAttribute("taskname", "svn - checkout ${id}");
                Element checkout = this.doc.createElement("checkout");
                checkout.setAttribute("url", "${url}");
                checkout.setAttribute("destpath", "../${id}");
                checkout.setAttribute("revision", "${revision}");
                svn.appendChild(checkout);
                element.appendChild(svn);
                checkoutTargetList.add(element);
                element = this.doc.createElement("target");
                element.setAttribute("name", "update.dependency.svn");
                element.setAttribute("if", "${id}-exists");
                svn = this.doc.createElement("svn");
                svn.setAttribute("taskname", "svn - update ${id}");
                Element update = this.doc.createElement("update");
                update.setAttribute("dir", "../${id}");
                svn.appendChild(update);
                element.appendChild(svn);
                updateTargetList.add(element);
                svnTargetsReuired = false;
            }
            int i3 = 0;
            while (i3 < references.length) {
                tokenizer = new StringTokenizer(references[i3], ",");
                tokenizer.nextToken();
                antcall = this.doc.createElement("antcall");
                antcall.setAttribute("target", "fetch.from.svn");
                param = this.doc.createElement("param");
                param.setAttribute("name", "url");
                param.setAttribute("value", tokenizer.nextToken());
                antcall.appendChild(param);
                param = this.doc.createElement("param");
                param.setAttribute("name", "id");
                param.setAttribute("value", tokenizer.nextToken());
                antcall.appendChild(param);
                param = this.doc.createElement("param");
                param.setAttribute("name", "revision");
                param.setAttribute("value", "HEAD");
                antcall.appendChild(param);
                target.appendChild(antcall);
                ++i3;
            }
        }
        this.root.appendChild(target);
        if (!cvsTargetsReuired || !svnTargetsReuired) {
            c = this.doc.createComment(" fetching ");
            this.root.appendChild(c);
            Element checkTarget = this.doc.createElement("target");
            checkTarget.setAttribute("name", "check.project.existence");
            Element available = this.doc.createElement("available");
            available.setAttribute("property", "${id}-exists");
            available.setAttribute("file", "../${id}");
            checkTarget.appendChild(available);
            this.root.appendChild(checkTarget);
            Iterator it = fetchTargetList.iterator();
            while (it.hasNext()) {
                this.root.appendChild((Element)it.next());
            }
            c = this.doc.createComment(" checkout ");
            this.root.appendChild(c);
            it = checkoutTargetList.iterator();
            while (it.hasNext()) {
                this.root.appendChild((Element)it.next());
            }
            c = this.doc.createComment(" update ");
            this.root.appendChild(c);
            it = updateTargetList.iterator();
            while (it.hasNext()) {
                this.root.appendChild((Element)it.next());
            }
        }
    }

    protected abstract boolean create(List var1, IProgressMonitor var2) throws Exception;
}

