/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ant.service;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.higgins.ant.service.AbstractProjectManager;
import org.eclipse.higgins.ant.service.ExportUtil;
import org.eclipse.higgins.ant.service.ICreator;
import org.eclipse.higgins.ant.service.IProjectManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractCreator
implements ICreator {
    protected static final String DEFAULT_EXCLUDES = "**/bin/,**/build/,**/temp.**/,**/doc/,**/cvs/,**/.svn/,**/*.psf,dependencies.xml";
    protected Element root;
    protected Document doc = null;
    protected IProject project;
    protected String projectName;
    protected String projectRoot;
    protected static IProjectManager projectManager = AbstractProjectManager.getInstance();

    protected AbstractCreator() {
    }

    public AbstractCreator(IProject project) {
        this.Init(project);
    }

    protected void Init(IProject project) {
        this.project = project;
        this.projectName = project.getName();
        this.projectRoot = projectManager.getProjectRoot(project);
    }

    protected void createDoc() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        this.doc = dbf.newDocumentBuilder().newDocument();
    }

    protected IProject getProject() {
        return this.project;
    }

    protected List getProjects(boolean handleProject, boolean handleSubProjects) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        if (handleProject) {
            projects.add(this.getProject());
        }
        if (handleSubProjects) {
            projects.addAll(this.getSubProjects());
        }
        return projects;
    }

    protected List getSubProjects() {
        return projectManager.getSubProjects(this.getProject());
    }

    public ByteArrayInputStream create(boolean handleProject, boolean handleSubProjects, IProgressMonitor pm) throws Exception {
        ByteArrayInputStream is = null;
        List projects = this.getProjects(handleProject, handleSubProjects);
        if (this.create(projects, pm)) {
            String xml = ExportUtil.toString(this.doc);
            is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        }
        return is;
    }

    protected abstract boolean create(List var1, IProgressMonitor var2) throws Exception;
}

