/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ant.service;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.higgins.ant.service.AbstractCreator;
import org.eclipse.higgins.ant.service.EclipseClasspath;
import org.eclipse.higgins.ant.service.ExportUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.w3c.dom.Element;

public abstract class AbstractDependenciesCreator
extends AbstractCreator {
    protected EclipseClasspath classpath;

    public AbstractDependenciesCreator() {
    }

    public AbstractDependenciesCreator(IProject project) {
        super(project);
    }

    protected void Init(IProject project) {
        super.Init(project);
        this.initClasspath();
    }

    protected void initClasspath() {
        if (projectManager.isJavaProject(this.project)) {
            IJavaProject javaProject = projectManager.getJavaProject(this.project);
            try {
                this.classpath = new EclipseClasspath(javaProject);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    protected void createDependencies(List projects) {
        Element dependencies = this.doc.createElement("dependencies");
        dependencies.setAttribute("id", this.projectName);
        Element e = this.createProjectDependencies(projects);
        if (e != null) {
            dependencies.appendChild(e);
        }
        if ((e = this.createLibDependencies()) != null) {
            dependencies.appendChild(e);
        }
        this.doc.appendChild(dependencies);
    }

    protected Element createProjectDependencies(List projects) {
        Element hProjects = this.doc.createElement("higginsProjects");
        int i = 0;
        while (i < projects.size()) {
            Element element = this.doc.createElement("project");
            IProject project = projectManager.getProject(projects.get(i));
            element.setAttribute("id", project.getName());
            hProjects.appendChild(element);
            ++i;
        }
        return hProjects;
    }

    private Element createLibDependencies() {
        Element libs = null;
        String prefix = "";
        if (this.classpath != null) {
            HashMap loc2map = new HashMap();
            Iterator iter = ExportUtil.removeDuplicates(this.classpath.rawClassPathEntries).iterator();
            while (iter.hasNext()) {
                String entry = (String)iter.next();
                if (EclipseClasspath.isUserLibraryReference(entry) || EclipseClasspath.isUserSystemLibraryReference(entry) || EclipseClasspath.isLibraryReference(entry) || EclipseClasspath.isProjectReference(entry) || entry.startsWith("${") || this.classpath.classDirs.contains(entry)) continue;
                String path = ExportUtil.getRelativePath(String.valueOf(prefix) + entry, this.projectRoot);
                Path p = new Path(path);
                String id = p.lastSegment();
                String loc = p.removeLastSegments(1).toString();
                ArrayList<String> ids = (ArrayList<String>)loc2map.get(loc);
                if (ids == null) {
                    ids = new ArrayList<String>();
                    loc2map.put(loc, ids);
                }
                if (ids.contains(id)) continue;
                ids.add(id);
            }
            Iterator itr = loc2map.keySet().iterator();
            while (itr.hasNext()) {
                String location = (String)itr.next();
                List list = (List)loc2map.get(location);
                if (list.size() <= 0) continue;
                libs = this.doc.createElement("remoteLibs");
                libs.setAttribute("location", location);
                int i = 0;
                while (i < list.size()) {
                    String lib = (String)list.get(i);
                    Element element = this.doc.createElement("library");
                    element.setAttribute("id", lib);
                    libs.appendChild(element);
                    ++i;
                }
            }
        }
        return libs;
    }

    protected boolean create(List projects, IProgressMonitor pm) throws Exception {
        this.createDoc();
        this.createDependencies(projects);
        return true;
    }

    public ByteArrayInputStream create(boolean handleProject, boolean handleSubProjects, IProgressMonitor pm) throws Exception {
        return super.create(false, handleSubProjects, pm);
    }
}

