/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ant.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.higgins.ant.service.ExtensionManager;
import org.eclipse.higgins.ant.service.IProjectManager;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.w3c.dom.Document;

public abstract class AbstractProjectManager
implements IProjectManager {
    public static final String TEMPLATES_LOCATION = "templates";
    private static Comparator projectComparator;
    protected static IProjectManager instance;

    static {
        instance = null;
    }

    public synchronized Comparator getProjectComparator() {
        if (projectComparator == null) {
            projectComparator = new ProjectComparator();
        }
        return projectComparator;
    }

    public static IProjectManager getInstance() {
        if (instance == null) {
            instance = ExtensionManager.createProjectManager();
        }
        return instance;
    }

    protected void addJavaProjects(List projects) {
        if (projects == null) {
            projects = new ArrayList<IProject>();
        }
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        try {
            IJavaProject[] javaProjects = javaModel.getJavaProjects();
            int i = 0;
            while (i < javaProjects.length) {
                IProject p = this.getProject(javaProjects[i]);
                projects.add(p);
                ++i;
            }
        }
        catch (Exception exception) {
            IJavaProject[] javaProjects = new IJavaProject[]{};
        }
    }

    protected void addOtherProjects(List projects) {
        IWorkspaceRoot rootWorkspace;
        IProject[] otherProjects;
        if (projects == null) {
            projects = new ArrayList<IProject>();
        }
        if ((otherProjects = (rootWorkspace = ResourcesPlugin.getWorkspace().getRoot()).getProjects()).length == projects.size()) {
            return;
        }
        int i = 0;
        while (i < otherProjects.length) {
            if (!projects.contains(otherProjects[i])) {
                projects.add(otherProjects[i]);
            }
            ++i;
        }
    }

    public List getWorkspaceProjects() {
        ArrayList projects = new ArrayList();
        this.addJavaProjects(projects);
        this.addOtherProjects(projects);
        return projects;
    }

    protected boolean addJavaProject(Set projects, IProject project, boolean requiredProjects) throws JavaModelException {
        boolean res = false;
        if (this.isJavaProject(project)) {
            IJavaProject javaProject = this.getJavaProject(project);
            if (requiredProjects) {
                projects.addAll(this.getClasspathProjectsRecursive(javaProject));
            }
            projects.add(javaProject);
            res = true;
        }
        return res;
    }

    public Set getBuildProjects(Iterator projects, boolean requiredProjects) throws JavaModelException {
        TreeSet res = new TreeSet(this.getProjectComparator());
        while (projects.hasNext()) {
            IProject project = (IProject)projects.next();
            this.addJavaProject(res, project, requiredProjects);
        }
        return res;
    }

    public abstract IProject getProject(Object var1);

    public IProject getProject(String projectId) {
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        return rootWorkspace.getProject(projectId);
    }

    public String getProjectRoot(Object project) {
        return this.getProject(project).getLocation().toString();
    }

    public String getProjectName(Object project) {
        return this.getProject(project).getName();
    }

    public IJavaProject getJavaProject(IProject project) {
        if (!this.isJavaProject(project)) {
            return null;
        }
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        IJavaProject javaProject = javaModel.getJavaProject(project.getName());
        if (javaProject != null) {
            return javaProject;
        }
        try {
            IJavaProject[] javaProjects = javaModel.getJavaProjects();
            int i = 0;
            while (i < javaProjects.length) {
                IJavaProject jp = javaProjects[i];
                if (project.equals((Object)jp)) {
                    javaProject = jp;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return javaProject;
    }

    public IJavaProject getJavaProject(String root) {
        IJavaProject[] javaProjects;
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        try {
            javaProjects = javaModel.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        int i = 0;
        while (i < javaProjects.length) {
            IJavaProject javaProject = javaProjects[i];
            if (root.equals(javaProject.getPath().toString())) {
                return javaProject;
            }
            ++i;
        }
        return null;
    }

    public IJavaProject getJavaProjectByName(String name) {
        IJavaProject[] javaProjects;
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        try {
            javaProjects = javaModel.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        int i = 0;
        while (i < javaProjects.length) {
            IJavaProject javaProject = javaProjects[i];
            if (name.equals(javaProject.getProject().getName())) {
                return javaProject;
            }
            ++i;
        }
        return null;
    }

    public final List getSubProjects(IProject project) {
        ArrayList res = new ArrayList();
        TreeSet set = new TreeSet(this.getProjectComparator());
        this.getSubProjects(project, set);
        res.addAll(set);
        return res;
    }

    protected boolean getJavaSubProjects(IProject project, Set set) {
        boolean res = false;
        try {
            if (this.isJavaProject(project)) {
                res = true;
                IJavaProject javaProject = this.getJavaProject(project);
                if (javaProject != null && !set.contains(javaProject)) {
                    List l = this.getClasspathProjectsRecursive(javaProject);
                    int j = 0;
                    while (j < l.size()) {
                        set.add(this.getProject(l.get(j)));
                        ++j;
                    }
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return res;
    }

    public void getSubProjects(IProject project, Set set) {
        this.getJavaSubProjects(project, set);
    }

    public List getClasspathProjectsRecursive(Object object) throws JavaModelException {
        List classpath = null;
        if (object instanceof IJavaProject) {
            classpath = this.getClasspathProjectsRecursive((IJavaProject)object);
        }
        return classpath;
    }

    protected List getClasspathProjectsRecursive(IJavaProject project) throws JavaModelException {
        LinkedList result = new LinkedList();
        this.getClasspathProjectsRecursive(project, result);
        return this.sortProjectsUsingBuildOrder(result);
    }

    protected void getClasspathProjectsRecursive(IJavaProject project, LinkedList result) throws JavaModelException {
        List projects = this.getClasspathProjects(project);
        Iterator iter = projects.iterator();
        while (iter.hasNext()) {
            IJavaProject javaProject = (IJavaProject)iter.next();
            if (result.contains(javaProject)) continue;
            result.addFirst(javaProject);
            this.getClasspathProjectsRecursive(javaProject, result);
        }
    }

    protected List sortProjectsUsingBuildOrder(List javaProjects) {
        IJavaProject javaProject;
        Iterator iter;
        if (javaProjects.isEmpty()) {
            return javaProjects;
        }
        ArrayList<IJavaProject> result = new ArrayList<IJavaProject>(javaProjects.size());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String[] buildOrder = workspace.getDescription().getBuildOrder();
        if (buildOrder == null) {
            IProject[] projects = new IProject[javaProjects.size()];
            int i = 0;
            iter = javaProjects.iterator();
            while (iter.hasNext()) {
                javaProject = (IJavaProject)iter.next();
                projects[i] = javaProject.getProject();
                ++i;
            }
            IWorkspace.ProjectOrder po = ResourcesPlugin.getWorkspace().computeProjectOrder(projects);
            projects = po.projects;
            buildOrder = new String[projects.length];
            i = 0;
            while (i < projects.length) {
                buildOrder[i] = projects[i].getName();
                ++i;
            }
        }
        int i = 0;
        while (i < buildOrder.length && !javaProjects.isEmpty()) {
            String projectName = buildOrder[i];
            iter = javaProjects.iterator();
            while (iter.hasNext()) {
                javaProject = (IJavaProject)iter.next();
                if (!javaProject.getProject().getName().equals(projectName)) continue;
                result.add(javaProject);
                iter.remove();
            }
            ++i;
        }
        result.addAll(javaProjects);
        return result;
    }

    public List getClasspathProjects(IJavaProject project) throws JavaModelException {
        ArrayList projects = new ArrayList();
        IClasspathEntry[] entries = project.getRawClasspath();
        AbstractProjectManager.addClasspathProjects(project, projects, entries);
        return this.sortProjectsUsingBuildOrder(projects);
    }

    private static void addClasspathProjects(IJavaProject project, List projects, IClasspathEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry classpathEntry = entries[i];
            if (classpathEntry.getContentKind() == 1 && classpathEntry.getEntryKind() == 2) {
                String subProjectRoot = classpathEntry.getPath().toString();
                IJavaProject subProject = instance.getJavaProject(subProjectRoot);
                if (subProject != null) {
                    projects.add(subProject);
                }
            } else if (classpathEntry.getContentKind() == 1 && classpathEntry.getEntryKind() == 5) {
                try {
                    String jar;
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)classpathEntry.getPath(), (IJavaProject)project);
                    if (container != null && !(jar = container.getPath().toString()).startsWith(JavaRuntime.JRE_CONTAINER) && !jar.startsWith("org.eclipse.jdt.USER_LIBRARY")) {
                        AbstractProjectManager.addClasspathProjects(project, projects, container.getClasspathEntries());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public boolean isJavaProject(IProject project) {
        boolean res = false;
        try {
            if (project.getNature("org.eclipse.jdt.core.javanature") != null) {
                res = true;
            }
        }
        catch (CoreException coreException) {
            res = false;
        }
        return res;
    }

    public boolean isFeatureProject(IProject project) {
        boolean res = false;
        try {
            if (project.getNature("org.eclipse.pde.FeatureNature") != null) {
                res = true;
            }
        }
        catch (CoreException coreException) {
            res = false;
        }
        return res && project.isOpen() && project.exists(IConstants.FEATURE_PATH);
    }

    public boolean isPluginProject(IProject project) {
        boolean res = false;
        try {
            if (project.getNature("org.eclipse.pde.PluginNature") != null) {
                res = true;
            }
        }
        catch (CoreException coreException) {
            res = false;
        }
        return res && project.isOpen() && (project.exists(IConstants.PLUGIN_PATH) || project.exists(IConstants.MANIFEST_PATH));
    }

    public boolean isSiteProject(IProject project) {
        boolean res = false;
        try {
            if (project.getNature("org.eclipse.pde.UpdateSiteNature") != null) {
                res = true;
            }
        }
        catch (CoreException coreException) {
            res = false;
        }
        return res && project.isOpen() && project.exists(IConstants.SITE_PATH);
    }

    /*
     * Exception decompiling
     */
    public Document getTemplate(String bundle, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 143->146)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static interface IConstants {
        public static final IPath MANIFEST_PATH = new Path("META-INF/MANIFEST.MF");
        public static final IPath PLUGIN_PATH = new Path("plugin.xml");
        public static final IPath FEATURE_PATH = new Path("feature.xml");
        public static final IPath SITE_PATH = new Path("site.xml");
    }

    private static class ProjectComparator
    implements Comparator {
        private ProjectComparator() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = instance.getProject(o1).getName();
            String name2 = instance.getProject(o2).getName();
            return name1.compareTo(name2);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.compare(this, obj) == 0;
        }
    }
}

