package org.eclipse.higgins.ant.internal.ui;

import org.eclipse.higgins.ant.Higgins2AntPlugin;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GeneralPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

	public GeneralPreferencePage() {
		super(GRID);
		setDescription(DataTransferMessages.GeneralPreferencePage);
		setPreferenceStore(Higgins2AntPlugin.getDefault().getPreferenceStore());
	}

	protected void createFieldEditors() {
		createSpace();
		createLabel(DataTransferMessages.GeneralPreferencePage_Enter);
		
		addField(new StringFieldEditor(IPreferenceConstants.GENERAL_FILE_NAME_BUILD, DataTransferMessages.GeneralPreferencePage_FileName_Build, getFieldEditorParent()));

		addField(new BooleanFieldEditor(IPreferenceConstants.GENERAL_CREATE_DEP_FILE, DataTransferMessages.GeneralPreferencePage_Create_Dep, getFieldEditorParent()));
		addField(new StringFieldEditor(IPreferenceConstants.GENERAL_FILE_NAME_DEP, DataTransferMessages.GeneralPreferencePage_FileName_Dep, getFieldEditorParent()));

		addField(new BooleanFieldEditor(IPreferenceConstants.GENERAL_CREATE_PSF_FILE, DataTransferMessages.GeneralPreferencePage_Create_PSF, getFieldEditorParent()));
		addField(new StringFieldEditor(IPreferenceConstants.GENERAL_FILE_NAME_PSF, DataTransferMessages.GeneralPreferencePage_FileName_PSF, getFieldEditorParent()));
		
		addField(new BooleanFieldEditor(IPreferenceConstants.GENERAL_CREATE_DEEP_PSF_FILE, DataTransferMessages.GeneralPreferencePage_Create_Deep_PSF, getFieldEditorParent()));
		addField(new StringFieldEditor(IPreferenceConstants.GENERAL_FILE_NAME_DEEP_PSF, DataTransferMessages.GeneralPreferencePage_FileName_Deep_PSF, getFieldEditorParent()));
		
		addField(new BooleanFieldEditor(IPreferenceConstants.GENERAL_CREATE_BUILDFILES_FOR_DEP, DataTransferMessages.GeneralPreferencePage_Create_Buildfiles_Dep, getFieldEditorParent()));
		
		createSpace();
		createLabel(DataTransferMessages.GeneralPreferencePage_Autorun);
		
		addField(new BooleanFieldEditor(IPreferenceConstants.GENERAL_AUTORUN_AT_STARTUP, DataTransferMessages.GeneralPreferencePage_Autorun_At_StrartUp, getFieldEditorParent()));

		addField(new BooleanFieldEditor(IPreferenceConstants.GENERAL_AUTORUN_MONITOR_FILE_CHANGES, DataTransferMessages.GeneralPreferencePage_Autorun_Monitor_File_Changes, getFieldEditorParent()));
	}

	public void init(IWorkbench workbench) {
	}

	private void createSpace() {
		Label label= new Label(getFieldEditorParent(), SWT.NONE);
		GridData gd= new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		gd.horizontalSpan= 3;
		label.setLayoutData(gd);
	}
	
	private void createLabel(String message) {
		Font font= getFieldEditorParent().getFont();
		Label label= new Label(getFieldEditorParent(), SWT.WRAP);
		label.setText(message);
		GridData gd= new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		gd.horizontalSpan= 3;
		gd.widthHint= convertWidthInCharsToPixels(60);
		label.setLayoutData(gd);
		label.setLayoutData(gd);
		label.setFont(font);
	}

}
