/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.ant.service;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.w3c.dom.Element;

public abstract class AbstractDependenciesCreator extends AbstractCreator {
	protected EclipseClasspath classpath;
	
	public AbstractDependenciesCreator() {
		super();
	}
	
	public AbstractDependenciesCreator(IProject project) {
		super(project);
	}
	
	protected void Init(IProject project) {
		super.Init(project);
		initClasspath();
	}
	
    protected void initClasspath() {
    	if (projectManager.isJavaProject(project)) {
    		IJavaProject javaProject = projectManager.getJavaProject(project);
    		try {
				classpath = new EclipseClasspath(javaProject);
			} catch (JavaModelException e) {
			}
    	}
    }
	
    protected void createDependencies(List projects) {
    	Element dependencies = doc.createElement("dependencies");
    	dependencies.setAttribute("id", projectName);
		Element e = createProjectDependencies(projects);
		if (e != null) {
			dependencies.appendChild(e);
		}
		e = createLibDependencies();
		if (e != null) {
			dependencies.appendChild(e);
		}
		doc.appendChild(dependencies);
    }

    protected Element createProjectDependencies(List projects) {
    	Element hProjects = doc.createElement("higginsProjects");
    	for (int i = 0; i < projects.size(); i++){ 
    		Element element = doc.createElement("project");
    		IProject project = projectManager.getProject(projects.get(i));
    		element.setAttribute("id", project.getName());
    		hProjects.appendChild(element);
    	}
    	return hProjects;
    }
    
    private Element createLibDependencies() {
    	Element libs = null;
    	String prefix = "";
    	if (classpath != null) {
        	HashMap loc2map = new HashMap();
        	
        	for (Iterator iter = ExportUtil.removeDuplicates(classpath.rawClassPathEntries).iterator(); iter.hasNext();)
        	{
        		String entry = (String) iter.next(); 

        		if (EclipseClasspath.isUserLibraryReference(entry)) {

        		} else if (EclipseClasspath.isUserSystemLibraryReference(entry)) {

        		} else if (EclipseClasspath.isLibraryReference(entry)) {

        		} else if (EclipseClasspath.isProjectReference(entry)) {

        		} else {
        			if (!entry.startsWith("${") && !classpath.classDirs.contains(entry)) {
        				String path = ExportUtil.getRelativePath(prefix + entry, projectRoot);
        				IPath p = new Path(path);
        				String id = p.lastSegment();
        				String loc = p.removeLastSegments(1).toString();
        				List ids = (List) loc2map.get(loc);
        				if (ids == null) {
        					ids = new ArrayList();
        					loc2map.put(loc, ids);
        				}
        				if (!ids.contains(id)) {
        					ids.add(id);
        				}
        			}
        		}
        	}

        	for (Iterator itr = loc2map.keySet().iterator(); itr.hasNext(); ) {
        		String location = (String) itr.next();
        		List list = (List) loc2map.get(location);
        		if (list.size() > 0) {
        			libs = doc.createElement("remoteLibs");
        			libs.setAttribute("location", location);
        			for (int i = 0; i < list.size(); i++) {
        				String lib = (String) list.get(i);
        				Element element = doc.createElement("library");
        				element.setAttribute("id", lib);
        				libs.appendChild(element);
        			}
        		}
        	}
    	}
    	return libs;
    }

	protected boolean create(List projects, IProgressMonitor pm) throws Exception {
		createDoc();
		createDependencies(projects);
		return true;
	}
	
	public ByteArrayInputStream create(boolean handleProject, boolean handleSubProjects, IProgressMonitor pm) throws Exception {
		return super.create(false, handleSubProjects, pm);
	}

}
