/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.ant.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.w3c.dom.Element;

public abstract class AbstractPSFCreator extends AbstractCreator {
	
	protected static Set notSublipse = new TreeSet(projectManager.getProjectComparator());
	
	public AbstractPSFCreator() {
		super();
	}
	
	public AbstractPSFCreator(IProject project) {
		super(project);
	}
	
	protected void Init(IProject project) {
		super.Init(project);
	}

	protected boolean create(List projects, IProgressMonitor pm) throws Exception {
		boolean allowOverwrite = false;
		// sort projects by provider
		Map byProvider = new HashMap();
		for (int i = 0; i < projects.size(); i++) {
			//IProject p = ExportUtil.getProject(projects.get(i));
			IProject p = projectManager.getProject(projects.get(i));
			// ---------------------------------------
			RepositoryProvider provider = RepositoryProvider.getProvider(p);
			if (provider != null) {
				String id = provider.getID();
				if ("org.eclipse.team.cvs.core.cvsnature".equalsIgnoreCase(id)
						|| "org.tigris.subversion.subclipse.core.svnnature".equalsIgnoreCase(id) || "org.eclipse.team.svn.core.svnnature".equalsIgnoreCase(id)) {
					Set list = (Set) byProvider.get(id);
					if (list == null) {
						//list = new TreeSet(ExportUtil.getProjectComparator());
						list = new TreeSet(projectManager.getProjectComparator());
						byProvider.put(id, list);
					}
					list.add(p);
					if ("org.tigris.subversion.subclipse.core.svnnature".equalsIgnoreCase(id) || "org.eclipse.team.svn.core.svnnature".equalsIgnoreCase(id)) {
						allowOverwrite = true;
					}
				} else {
					notSublipse.add(p);
				}
			} else {
				notSublipse.add(p);
			}
		}
		
		if (allowOverwrite) {
			createDoc();

			Element psf = doc.createElement("psf");
			psf.setAttribute("version", "2.0");
			doc.appendChild(psf);

			for (Iterator providersIt = byProvider.keySet().iterator(); providersIt.hasNext(); ) {
				String id = (String) providersIt.next();

				Set list = (Set) byProvider.get(id);
				IProject[] projectArray = (IProject[]) list.toArray(new IProject[list.size()]);

				RepositoryProviderType providerType = RepositoryProviderType.getProviderType(id);
				ProjectSetCapability capability = providerType.getProjectSetCapability();
				ProjectSetCapability.ensureBackwardsCompatible(providerType, capability);

				String[] references = null;
				if (capability != null) {
					IProgressMonitor spm = null;
//					if (pm != null) {
//						spm = new SubProgressMonitor(pm, 100);
//					} else {
						spm = new NullProgressMonitor();
//					}
					references = capability.asReference(projectArray, new ProjectSetSerializationContext(), spm);
				}
				if (references != null) {
					Element psfProvider = doc.createElement("provider");
					psfProvider.setAttribute("id", id);
					for (int i = 0; i < references.length; i++) {
						Element project = doc.createElement("project");
						project.setAttribute("reference", references[i]);
						psfProvider.appendChild(project);
					}
					psf.appendChild(psfProvider);
				}
			}
		}
		return allowOverwrite;
	}

}
