/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.ant.service;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Constants;

public class ExtensionManager {	
	/**
	 * The fully-qualified name of the higgins2ant extension-point for this plug-in.
	 */
	private static final String XP_NAME = "higgins2ant.higgins2ant";

	private static final String ELEMENT_PROJECT = "projectManager";

	private static IProjectManager projectManager = null;

	/**
	 * Name of the XML attribute designating a function's name.
	 */
	//private static final String NAME_ATTRIBUTE = "name";

	/**
	 * Name of the XML attribute designating the fully-qualified name 
	 * of the implementation class of a ICreator.
	 */
	private static final String CLASS_ATTRIBUTE = "class";

/*	private static IConfigurationElement[] getElements(String extensionPoint) {
		IPluginRegistry registry = Platform.getPluginRegistry();
		IExtensionPoint xp = registry.getExtensionPoint(extensionPoint);
		IConfigurationElement[] members = xp.getConfigurationElements();
		return members;
	}*/

	private static IConfigurationElement[] getElements(String extensionPoint, String elementName) {
		IConfigurationElement[] elements = null;
		IPluginRegistry registry = Platform.getPluginRegistry();
		IExtensionPoint xp = registry.getExtensionPoint(extensionPoint);
		IConfigurationElement[] members = xp.getConfigurationElements();
		
		List list = new LinkedList();
		
		for (int i = 0; i < members.length; i++) {
			String name = members[i].getName();
			if (name.equals(elementName))
				list.add((IConfigurationElement)members[i]);
		}
		Object[] objects = list.toArray();
		elements = new IConfigurationElement[objects.length];
		for (int i = 0; i < objects.length; i++) {
			elements[i] = (IConfigurationElement)objects[i];
		}
		return elements;
	}

/*	private static IExtension[] getExtensions(String extensionPoint) {
		IPluginRegistry registry = Platform.getPluginRegistry();
		IExtensionPoint xp = registry.getExtensionPoint(extensionPoint);
		IExtension[] members = xp.getExtensions();
		return members;
	}*/
	
/*	private static ICreator getCreator(IConfigurationElement element) throws CoreException {
		ICreator creator = null;
		try {
			Object callback = element.createExecutableExtension(CLASS_ATTRIBUTE);
			if (!(callback instanceof ICreator)) {
				String message =
					"class '"
					+ callback.getClass().getName()
					+ "' is not an ICreator";
				System.err.println(message);
				throw new ClassCastException(message);
			}
			creator = (ICreator)callback;
		}
		catch (CoreException ex) {
			System.err.println(ex.getMessage());
			ex.printStackTrace();
			throw ex;
		}
		catch (Error err) {
			System.err.println(err.getMessage());
			err.printStackTrace();
			throw err;
		}
		return creator;
	}*/
	
	private static Object getExecutableExtension(IConfigurationElement element) throws CoreException {
		Object extension = null;
		extension = element.createExecutableExtension(CLASS_ATTRIBUTE);
		return extension;
	}
	
	private static List getDependencies(IConfigurationElement element) {
		List dependencies = new LinkedList();
		Plugin plugin = Platform.getPlugin(element.getNamespaceIdentifier());
		Bundle bundle = plugin.getBundle();
		String requires = (String)bundle.getHeaders().get(Constants.REQUIRE_BUNDLE);
		try {
			ManifestElement[] elements = ManifestElement.parseHeader(Constants.REQUIRE_BUNDLE, requires);
			for (int i = 0; i < elements.length; i++) {
				dependencies.add((String)elements[i].getValue());
			}
		} catch (BundleException e) {
			e.printStackTrace();
		}
		return dependencies;
	}
	
	private static List getModelNamespaces() {
		String[] namespaces = Platform.getExtensionRegistry().getNamespaces();
		return Arrays.asList(namespaces);
	}
	
/*	private static boolean isElementAvailable(IConfigurationElement element) {
		return getModelNamespaces().containsAll(getDependencies(element));
	}*/
	
/*	private static void printList(List list) {
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			String element = (String) iter.next();
			System.out.println(element);
		}
	}*/
	
	private static IConfigurationElement getProperElement(String elementName) {
		IConfigurationElement element = null;
		IConfigurationElement[] members = getElements(XP_NAME, elementName);
		int maxDependencies = -1;
		for (int i = 0; i < members.length; i++) {
			List modelNamespaces = getModelNamespaces();
			List dependencies = getDependencies(members[i]);
			boolean isAvailable = modelNamespaces.containsAll(dependencies);
			if ((isAvailable) && (maxDependencies < dependencies.size())) {
				maxDependencies = dependencies.size();
				element = members[i];
			}
		}
		return element;
	}

//	private static ICreator createCreator(String elementName, IProject project) {
//		ICreator creator = null;
//		IConfigurationElement member = getProperElement(elementName);
//		try {
//			creator = (ICreator)getExecutableExtension(member);
//			if (creator != null)
//				((AbstractCreator)creator).Init(project);
//		} catch (CoreException e) {
//			e.printStackTrace();
//		}
//		return creator;
//	}

//	public static ICreator createDependenciesCreator(IProject project) {
//		ICreator creator = createCreator(ELEMENT_DEP, project);
//		return creator;
//	}
//	
//	public static ICreator craetePSFCreator(IProject project) {
//		ICreator creator = createCreator(ELEMENT_PSF, project);
//		return creator;
//	}
	
/*	public static ICreator createBuildFileCreator(IProject project) {
		ICreator creator = createCreator(ELEMENT_BUILD, project);
		return creator;
	}*/
	
	public static IProjectManager createProjectManager() {
		if (projectManager != null)
			return projectManager;
		IConfigurationElement member = getProperElement(ELEMENT_PROJECT);
		try {
			projectManager = (IProjectManager)getExecutableExtension(member);
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return projectManager;
	}
}
