package org.eclipse.higgins.ant.autorun;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.higgins.ant.service.BuildCreator;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Shell;

public class AutorunBuildCreator extends BuildCreator {

	/**
	 * Generates build files for all projects in Workspace
	 */
	public static void createBuildFilesWorkspaceProjects(Shell shell, IProgressMonitor monitor) {
		List projectsList = projectManager.getWorkspaceProjects();
		try {
			Set projects = projectManager.getBuildProjects(projectsList.iterator(), false);
			createBuildFiles(projects, null, monitor);
		} catch (JavaModelException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private static Set getBuildProjects(IProject project) throws JavaModelException {
		Set projects = null;
		List projectsList = new ArrayList(1);
		projectsList.add(project);
		projects = projectManager.getBuildProjects(projectsList.iterator(), false);
		return projects;
	}

	/**
	 * Generates build files for once project
	 * 
	 * @param project
	 * @param monitor
	 * @throws Exception
	 */
	public static void createBuildFiles(IProject project, Shell shell, IProgressMonitor monitor) throws Exception {
		Set projects = getBuildProjects(project);
		createBuildFiles(projects, shell, monitor);
	}

	private static Set findDependentProjects(Set projects) {
		Set res = new TreeSet(projectManager.getProjectComparator());
		List list = projectManager.getWorkspaceProjects();
		for (Iterator itr = projects.iterator(); itr.hasNext(); ) {
			IProject project = (IProject) itr.next();
			for (Iterator iterator = list.iterator(); iterator.hasNext();) {	
				IProject proj = projectManager.getProject(iterator.next());
				Set projs = new TreeSet(projectManager.getProjectComparator());
				projectManager.getSubProjects(proj, projs);
				if (projs.contains(project) && !res.contains(proj)) {
					res.add(proj);
					//System.out.println(proj.getName());
				}
			}
		}
		return res;
	}

	public static void createDependentBuildFiles(Set list, Shell shell, IProgressMonitor monitor) throws Exception {
		Set projects = findDependentProjects(list);
		projects.addAll(list);
		createBuildFiles(projects, shell, monitor);
	}
}