package org.eclipse.higgins.ant.autorun;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.higgins.ant.service.AbstractProjectManager;
import org.eclipse.higgins.ant.service.BuildCreator;
import org.eclipse.higgins.ant.service.IProjectManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ResourceChangeListener implements IResourceChangeListener {

	protected final static String MANIFEST = "META-INF/MANIFEST.MF";
	protected final static String PLUGIN_XML = "plugin.xml";
	protected final static String SITE_XML = "site.xml";
	protected final static String FEATURE_XML = "feature.xml";
	protected final static String DOT_PROJECT = ".project";
	protected final static String DOT_CLASSPATH = ".classpath";

	/**
	 * Filenames for listening changes
	 */
	protected final static String[] fileNames = { DOT_PROJECT, DOT_CLASSPATH, PLUGIN_XML, FEATURE_XML, SITE_XML, MANIFEST };
	protected final static IPath[] files = getMonitorFilePath();// = { new Path(DOT_PROJECT), new Path(DOT_CLASSPATH), new Path(PLUGIN_XML), new Path(FEATURE_XML), new Path(SITE_XML), new Path(MANIFEST) };
	
	protected static IProjectManager projectManager = AbstractProjectManager.getInstance();
	
	private static IPath[] getMonitorFilePath() {
		IPath [] files = null;
		String s = BuildCreator.getAutorunMonitorFileNames();
		StringTokenizer st = new StringTokenizer(s, ",", false);
		int count = st.countTokens();
		files = new IPath[count];
		for (int i = 0; i < count; i++) {
			files[i] = new Path(st.nextToken().trim());
		}
		return files;
	}
	
	/**
	 * Find project in which files were changed
	 *  
	 * @param delta ResourceDelta which contain project
	 * @return project which configuration was changed
	 */
	private Set getProjectRecursive(IResourceDelta delta) {
		Set result = new TreeSet(projectManager.getProjectComparator());
		getProjectRecursive(delta, result);
		return result;
	}
	
	private void getProjectRecursive(IResourceDelta delta, Set set) {
		IResource resource = delta.getResource();
		if (resource instanceof IProject) {
			for (int i = 0; i < files.length; i++) {
				IResourceDelta d = delta.findMember(files[i]); 
				if (d != null && d.getKind() == IResourceDelta.CHANGED && (d.getFlags() & IResourceDelta.CONTENT) == IResourceDelta.CONTENT) {
					set.add(resource);
					break;
				}
			}
			
			/*
			IResourceDelta[] children = delta.getAffectedChildren();
			for (int i = 0; i < children.length; i++) {
				String path = children[i].getProjectRelativePath().toString();
				for (int j = 0; j < fileNames.length; j++) {
					if (path.equalsIgnoreCase(fileNames[j].toUpperCase())) {
						result = (IProject) resource;
						return result;
					}
				}
			}
			*/
		} else {
			IResourceDelta[] children = delta.getAffectedChildren();
			for (int i = 0; i < children.length; i++) {
				getProjectRecursive(children[i], set);
			}
		}
	}

	/**
	 * (Re)generates build files for project
	 */
	private void createBuildFiles(Set set) {
		if (set.isEmpty())
			return;
		try {
			//AutorunBuildCreator.createDependentBuildFiles(project, null, null);
			final Set projects = set;
			final IWorkbench workbench = PlatformUI.getWorkbench();
			workbench.getDisplay().asyncExec(new Runnable() {
				public void run() {
					final IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
					if (window != null) {
//						Workspace workspace = (Workspace) ResourcesPlugin.getWorkspace();
//						boolean oldLock = workspace.isTreeLocked();
//						workspace.setTreeLocked(false);
						IProgressService ps = PlatformUI.getWorkbench().getProgressService();
						try {
							ps.runInUI(ps, new IRunnableWithProgress() {

								public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
									try {
										AutorunBuildCreator.createDependentBuildFiles(projects, window.getShell(), monitor);
									} catch (Exception e) {
										e.printStackTrace();
									}
								}}, ResourcesPlugin.getWorkspace().getRoot());
						} catch (InvocationTargetException e) {
							e.printStackTrace();
						} catch (InterruptedException e) {
							e.printStackTrace();
						}
//						workspace.setTreeLocked(oldLock);		
					}
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void resourceChanged(IResourceChangeEvent event) {
		if (BuildCreator.getAutorunMonitorFileChanges()) {
			switch (event.getType()) {
			case IResourceChangeEvent.POST_CHANGE:
				Set projects = getProjectRecursive(event.getDelta());
				createBuildFiles(projects);
				break;
			}
		}
	}
}
