/*******************************************************************************
 * Copyright (c) 2004, 2006 Richard Hoefter and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Richard Hoefter (richard.hoefter@web.de) - initial API and implementation, bug 95296, bug 128512
 *     IBM Corporation - adapted to wizard export page
 *     Valery Kokhan - changes in order to produce correct build 
 *                     files for plug-in projects 
 *                     (original sourses from eclipse2ant)
 *******************************************************************************/

package org.eclipse.higgins.ant.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.higgins.ant.Higgins2AntPlugin;
import org.eclipse.higgins.ant.service.BuildCreator;
import org.eclipse.higgins.ant.service.ExportUtil;
import org.eclipse.higgins.ant.service.ExtensionManager;
import org.eclipse.higgins.ant.service.IProjectManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBasicPropertyConstants;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BuildfileExportPage extends WizardPage {
	
	static class NameSorter extends ViewerSorter {
		public boolean isSorterProperty(Object element, Object propertyId) {
			return propertyId.equals(IBasicPropertyConstants.P_TEXT);
		}
	}
	
	static class BaseSorter extends NameSorter {
		public int compare(Viewer viewer, Object e1, Object e2) {
			int result = 0;
			//String name1 = ExportUtil.getProjectName(e1);
			//String name2 = ExportUtil.getProjectName(e2);
			String name1 = projectManager.getProjectName(e1);
			String name2 = projectManager.getProjectName(e2);
			if (name1 != null && name2 != null)
				result = collator.compare(name1, name2);
			return (result != 0) ? result : super.compare(viewer, e1, e2);
		}
		
	}
	
	/*static class BaseLabelProvider extends SharedLabelProvider {

		public Image getImage(Object element) {
			if (element instanceof IFeatureModel) {
				return get(PDEPluginImages.DESC_FEATURE_OBJ, 0);
			}
			
			//obtain the base image by querying the element
			IWorkbenchAdapter adapter = getAdapter(element);
			if (adapter == null) {
				return null;
			}
			ImageDescriptor descriptor = adapter.getImageDescriptor(element);
			if (descriptor == null) {
				return null;
			}

			Image image = (Image) SWTResourceUtil.getImageTable().get(descriptor);
			if (image == null) {
				image = descriptor.createImage();
				SWTResourceUtil.getImageTable().put(descriptor, image);
			}
	        return image;
		}

		public String getText(Object element) {
			if (element instanceof IJavaProject) 
				return ExportUtil.getProjectName((IJavaProject) element);
			else if (element instanceof IFeatureModel)
				return ExportUtil.getProjectName((IFeatureModel) element);
			return super.getText(element);
		}
		
	    protected final IWorkbenchAdapter getAdapter(Object o) {
	        if (!(o instanceof IAdaptable)) {
	            return null;
	        }
	        return (IWorkbenchAdapter) ((IAdaptable) o).getAdapter(IWorkbenchAdapter.class);
	    }
	}*/

	private CheckboxTableViewer fTableViewer;
    private List fSelectedJavaProjects = new ArrayList();

    private Button requiredProjectsCheckbox;
//    private Text buildfilenameText;
//    private Text junitdirText;
//    
//    private Text buildfilenameTextDEP;
//    private Text buildfilenameTextPSF;
//    private Text buildfilenameTextPSFDEP;
    
    private static IProjectManager projectManager = ExtensionManager.createProjectManager();
    
    public BuildfileExportPage()
    {
        super("ProjectExportWizardPage"); //$NON-NLS-1$
        setPageComplete(false);
        String messageDesc = DataTransferMessages.AntBuildfileExportPage_1+"\n"+DataTransferMessages.AntAUXBuildfileExportPage_1+"\n"+DataTransferMessages.AntDependenciesExportPage_1+"\n"+DataTransferMessages.PSFExportPage_1;
        String messageTitle = DataTransferMessages.BuildfileExportPage_0;
        setTitle(messageTitle);
        setDescription(messageDesc);
    }
    
    /*
     * @see IDialogPage#createControl(Composite)
     */
    public void createControl(Composite parent) {
        
        initializeDialogUnits(parent);

        Composite workArea = new Composite(parent, SWT.NONE);
        setControl(workArea);

        workArea.setLayout(new GridLayout());
        workArea.setLayoutData(new GridData(GridData.FILL_BOTH
                | GridData.GRAB_HORIZONTAL | GridData.GRAB_VERTICAL));
        
        Label title= new Label(workArea, SWT.NONE);
        title.setText(DataTransferMessages.AntBuildfileExportPage_2);

        Composite listComposite = new Composite(workArea, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout(layout);

        listComposite.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL
                | GridData.GRAB_VERTICAL | GridData.FILL_BOTH));         

        //TODO set F1 help

        Table table = new Table(listComposite, SWT.CHECK | SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
        fTableViewer = new CheckboxTableViewer(table);
        table.setLayout(new TableLayout());
        GridData data = new GridData(SWT.FILL, SWT.FILL, true, true);
        data.heightHint = 200;
        table.setLayoutData(data);
        fTableViewer.setContentProvider(new WorkbenchContentProvider() {
            public Object[] getElements(Object element) {
                if (element instanceof Object[]) {
                    return (Object[]) element;
                }
                return null;
            }
        });
        fTableViewer.setLabelProvider(new WorkbenchLabelProvider());
        //fTableViewer.setLabelProvider(new BaseLabelProvider());
        
        fTableViewer.setSorter(new BaseSorter());
        
        //fTableViewer.setLabelProvider(PDEPlugin.getDefault().getLabelProvider());
        fTableViewer.addCheckStateListener(new ICheckStateListener() {
            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    fSelectedJavaProjects.add(event.getElement());
                } else {
                    fSelectedJavaProjects.remove(event.getElement());
                }
                updateEnablement();
            }
        });
       
        initializeProjects();
        createSelectionButtons(listComposite);

        createCheckboxes(workArea);

        /*
        createTextFields(workArea);        
        createTextFieldsDEP(workArea);
        createTextFieldsPSF(workArea);
        */
        
        setControl(workArea);
        updateEnablement();
        Dialog.applyDialogFont(parent);
    }

    private void createSelectionButtons(Composite composite) {

        Composite buttonsComposite = new Composite(composite, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout(layout);

        buttonsComposite.setLayoutData(new GridData(
                GridData.VERTICAL_ALIGN_BEGINNING));

        Button selectAll = new Button(buttonsComposite, SWT.PUSH);
        selectAll.setText(DataTransferMessages.AntBuildfileExportPage_11);
        selectAll.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                for (int i = 0; i < fTableViewer.getTable().getItemCount(); i++) {
                    fSelectedJavaProjects.add(fTableViewer.getElementAt(i));
                }
                fTableViewer.setAllChecked(true);
                updateEnablement();
            }
        });
        setButtonLayoutData(selectAll);
        
        Button deselectAll = new Button(buttonsComposite, SWT.PUSH);
        deselectAll.setText(DataTransferMessages.AntBuildfileExportPage_12);
        deselectAll.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                fSelectedJavaProjects.clear();
                fTableViewer.setAllChecked(false);
                updateEnablement();
            }
        });
        setButtonLayoutData(deselectAll); 
    }

    private void createCheckboxes(Composite composite) {
        requiredProjectsCheckbox = new Button(composite, SWT.CHECK);
        requiredProjectsCheckbox.setSelection(BuildCreator.getCreateBuildFilesForDeps());
        requiredProjectsCheckbox.setText(DataTransferMessages.AntBuildfileExportPage_22);
    }
    
    /*
    private void createTextFields(Composite composite) {

        // buildfilename and junitdir group
        Composite containerGroup = new Composite(composite, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        containerGroup.setLayout(layout);
        containerGroup.setLayoutData(new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL));

        // label        
        Label buildfilenameLabel = new Label(containerGroup, SWT.NONE);
        buildfilenameLabel.setText(DataTransferMessages.AntBuildfileExportPage_16);

        // text field
        buildfilenameText = new Text(containerGroup, SWT.SINGLE | SWT.BORDER);
        buildfilenameText.setText("build.xml"); //$NON-NLS-1$
        GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL
                | GridData.GRAB_HORIZONTAL);
        buildfilenameText.setLayoutData(data);

        // label
        Label junitdirLabel = new Label(containerGroup, SWT.NONE);
        junitdirLabel.setText(DataTransferMessages.AntBuildfileExportPage_17);

        // text field
        junitdirText = new Text(containerGroup, SWT.SINGLE | SWT.BORDER);
        junitdirText.setText("junit"); //$NON-NLS-1$
        junitdirText.setLayoutData(data);
        
        ModifyListener listener = new ModifyListener() {
            public void modifyText(ModifyEvent e) {
                updateEnablement();
            }
        };
        buildfilenameText.addModifyListener(listener);
        junitdirText.addModifyListener(listener);        
    }
    */

    /*
    private void createTextFieldsDEP(Composite composite) {

        // buildfilename and junitdir group
        Composite containerGroup = new Composite(composite, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        containerGroup.setLayout(layout);
        containerGroup.setLayoutData(new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL));

        // label        
        Label buildfilenameLabel = new Label(containerGroup, SWT.NONE);
        buildfilenameLabel.setText(DataTransferMessages.AntDependenciesExportPage_16);

        // text field
        buildfilenameTextDEP = new Text(containerGroup, SWT.SINGLE | SWT.BORDER);
        buildfilenameTextDEP.setText("dependencies.xml"); //$NON-NLS-1$
        GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL
                | GridData.GRAB_HORIZONTAL);
        buildfilenameTextDEP.setLayoutData(data);

        ModifyListener listener = new ModifyListener() {
            public void modifyText(ModifyEvent e) {
                updateEnablement();
            }
        };
        buildfilenameTextDEP.addModifyListener(listener);
    }
    */
    
    /*
    private void createTextFieldsPSF(Composite composite) {

        // psffilename and psffilename with deps group
        Composite containerGroup = new Composite(composite, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        containerGroup.setLayout(layout);
        containerGroup.setLayoutData(new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL));

        // label        
        Label psffilenameLabel = new Label(containerGroup, SWT.NONE);
        psffilenameLabel.setText(DataTransferMessages.PSFExportPage_3);
        
        // text field
        buildfilenameTextPSF = new Text(containerGroup, SWT.SINGLE | SWT.BORDER);
        buildfilenameTextPSF.setText(BuildCreator.getPSF_XML()); //$NON-NLS-1$
        GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL
                | GridData.GRAB_HORIZONTAL);
        buildfilenameTextPSF.setLayoutData(data);

        ModifyListener listener = new ModifyListener() {
            public void modifyText(ModifyEvent e) {
                updateEnablement();
            }
        };
        buildfilenameTextPSF.addModifyListener(listener);
        
        //lable
        Label psfdepfilenameLabel = new Label(containerGroup, SWT.NONE);
        psfdepfilenameLabel.setText(DataTransferMessages.PSFExportPage_4);
        
        //text field
        buildfilenameTextPSFDEP = new Text(containerGroup, SWT.SINGLE | SWT.BORDER);
        buildfilenameTextPSFDEP.setText(BuildCreator.getPSF_DEP_XML()); //$NON-NLS-1$
        data = new GridData(GridData.HORIZONTAL_ALIGN_FILL
                | GridData.GRAB_HORIZONTAL);
        buildfilenameTextPSFDEP.setLayoutData(data);

        listener = new ModifyListener() {
            public void modifyText(ModifyEvent e) {
                updateEnablement();
            }
        };
        buildfilenameTextPSFDEP.addModifyListener(listener);
    }
    */

    private void initializeProjects() {
/*        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create(rootWorkspace);
        List projects = new ArrayList();
        IJavaProject[] javaProjects;
        try {
            javaProjects = javaModel.getJavaProjects();
            for(int i = 0; i < javaProjects.length; i++) {
            	projects.add(ExportUtil.getProject(javaProjects[i]));
            }
        }
        catch (Exception e) {
            javaProjects= new IJavaProject[0];
        }*/
    	List projects = projectManager.getWorkspaceProjects();
		/*FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
		IFeatureModel[] features;
		
        try {
        	features = manager.getWorkspaceModels();// getFeatureModels();
            for(int i = 0; i < features.length; i++) {
            	projects.add(ExportUtil.getProject(features[i]));
            }
        }
        catch (Exception e) {
        	features= new IFeatureModel[0];
        	
        }*/
//        Object[] input = new Object[javaProjects.length + features.length];
//        System.arraycopy(javaProjects, 0, input, 0, javaProjects.length);
//        System.arraycopy(features, 0, input, javaProjects.length, features.length);
        Object[] input = projects.toArray(new IProject[projects.size()]);
        fTableViewer.setInput(input);
        // Check any necessary projects
        if (fSelectedJavaProjects != null) {
            //fTableViewer.setCheckedElements(fSelectedJavaProjects.toArray(new IJavaProject[fSelectedJavaProjects.size()]));
            fTableViewer.setCheckedElements(fSelectedJavaProjects.toArray());
        }
    }
    
    private void updateEnablement() {
        boolean complete= true;
        if (fSelectedJavaProjects.size() == 0) {
        	setErrorMessage(DataTransferMessages.AntBuildfileExportPage_18);
            complete = false;
        }
        /*
        if (buildfilenameText.getText().length() == 0) {
            setErrorMessage(DataTransferMessages.AntBuildfileExportPage_19);
            complete = false;            
        }
        if (junitdirText.getText().length() == 0) {
        	setErrorMessage(DataTransferMessages.AntBuildfileExportPage_20);
        	complete = false;
        }
        */
        if (complete) {
            setErrorMessage(null);
        }
        setPageComplete(complete);
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.dialogs.IDialogPage#setVisible(boolean)
     */
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            fTableViewer.getTable().setFocus();
        }
    }
    
    protected void setSelectedProjects(List selectedJavaProjects) {
    	fSelectedJavaProjects.clear();
//    	for (int i = 0; i < selectedJavaProjects.size(); i++) {
//    		Object o = selectedJavaProjects.get(i);
//    		if (o instanceof IProject) {
//    			IProject project = (IProject) selectedJavaProjects.get(i);
//    			IFeatureModel m = PDECore.getDefault().getWorkspaceModelManager().getFeatureModel(project);
//    			if (m == null) {
//    				fSelectedJavaProjects.add(project);
//    			} else {
//    				fSelectedJavaProjects.add(m);
//    			}
//    		} else {
//    			fSelectedJavaProjects.add(o);
//    		}
//
//    	}
        fSelectedJavaProjects.addAll(selectedJavaProjects);
    }
    
    /**
     * Convert Eclipse Java projects to Ant build files. Displays error dialogs.
     */
    public boolean generateBuildfiles() 
    {
        setErrorMessage(null);
        final List projectNames = new ArrayList();
        final Set projects;
        try {
            projects = getProjects();
        } catch (JavaModelException e) {
            Higgins2AntPlugin.log(e);
            setErrorMessage(MessageFormat.format(
                    DataTransferMessages.AntBuildfileExportPage_10,
                    new String[] { e.toString() }));
            return false;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress() {
            public void run(IProgressMonitor pm) throws InterruptedException {
                Exception problem= null;
                try {

                	//BuildCreator.setOptions(buildfilenameText.getText(), buildfilenameTextDEP.getText(), buildfilenameTextPSF.getText(), buildfilenameTextPSFDEP.getText());
                	projectNames.addAll(BuildCreator.createBuildFiles(projects, getShell(), pm));
                	
//                	BuildFileCreatorAll.setOptions(buildfilenameText.getText(), junitdirText.getText());
//                    projectNames.addAll(BuildFileCreatorAll.createBuildFiles(projects, getShell(), pm));
//                    
//                    DependenciesFileCreator.setOptions(buildfilenameTextDEP.getText());                    
//                    DependenciesFileCreator.createBuildFiles(projects, getShell(), pm);
//                    
//                    PSFFileCreatorAll.setOptions(buildfilenameTextPSF.getText(), buildfilenameTextPSFDEP.getText());
//                    PSFFileCreatorAll.createPSFFiles(projects, getShell(), pm);
                    
                    
                } catch (Exception e) {
                    problem= e;
                }
                if (problem != null) {
                    Higgins2AntPlugin.log(problem);
                    setErrorMessage(MessageFormat.format(DataTransferMessages.AntBuildfileExportPage_10, new String[] {problem.toString()}));
                }
            }
        };

        try {
            // NOTE: not cancelable, don't know why
            PlatformUI.getWorkbench().getProgressService().run(false, false, runnable);
        } catch (InvocationTargetException e) {
            Higgins2AntPlugin.log(e);
            return false;
        } catch (InterruptedException e) {
            Higgins2AntPlugin.log(e);
            return false;
        }
        if (getErrorMessage() != null) {
            return false;
        }
        
        // show success message
        if (projectNames.size() > 0)
        {
            String message = MessageFormat.format(DataTransferMessages.AntBuildfileExportPage_5 + ExportUtil.NEWLINE, new String[] {ExportUtil.NEWLINE + ExportUtil.toString(projectNames, ExportUtil.NEWLINE)});
            MessageDialog.openInformation(getShell(), DataTransferMessages.AntBuildfileExportPage_0, message);
            
            List cyclicProjects;
            try {
                cyclicProjects = getCyclicProjects(projects);
            } catch (CoreException e) {
                Higgins2AntPlugin.log(e);
                setErrorMessage(MessageFormat.format(
                        DataTransferMessages.AntBuildfileExportPage_10,
                        new String[] { e.toString() }));
                return false;
            }
            if (cyclicProjects.size() > 0)
            {
                String warningMessage= MessageFormat.format(DataTransferMessages.AntBuildfileExportPage_6 + ExportUtil.NEWLINE + ExportUtil.NEWLINE +
                        DataTransferMessages.AntBuildfileExportPage_7 + " " + //$NON-NLS-1$
                        DataTransferMessages.AntBuildfileExportPage_8,
                        new String[] { ExportUtil.NEWLINE + ExportUtil.toString(cyclicProjects, ExportUtil.NEWLINE)});
                MessageDialog.openWarning(getShell(), DataTransferMessages.AntBuildfileExportPage_9, warningMessage);
            }
        }

        return true;
    }

    /**
     * Get projects to write buildfiles for. Opens confirmation dialog.
     * @return set of project names 
     */
    private Set getProjects() throws JavaModelException
    {
        // collect all projects to create buildfiles for
/*        Set projects = new TreeSet(ExportUtil.getProjectComparator());
        Iterator javaProjects = fSelectedJavaProjects.iterator();
        while (javaProjects.hasNext()) {
        	IProject project = (IProject) javaProjects.next();
        	if (ExportUtil.isJavaProject(project)) {
                IJavaProject javaProject = ExportUtil.getJavaProject(project);
                if (requiredProjectsCheckbox.getSelection()){
                	projects.addAll(ExportUtil.getClasspathProjectsRecursive(javaProject));
                }
                projects.add(javaProject);
        	} /*else if (ExportUtil.isFeatureProject(project)) {
        		IFeatureModel model = ExportUtil.getFeatureModel(project);
                if (requiredProjectsCheckbox.getSelection()){
            		IFeaturePlugin[] plugins = model.getFeature().getPlugins();
            		for (int i = 0; i < plugins.length; i++) {
            			IJavaProject javaProject = ExportUtil.getJavaProject(plugins[i]);
            			if (javaProject != null) {
                        	projects.addAll(ExportUtil.getClasspathProjectsRecursive(javaProject));
            			}
            		}
                }
                projects.add(model);
        	}*/
//        }*/

    	// Set projects = projectManager.getBuildProjects(fSelectedJavaProjects.iterator(), BuildCreator.getCreateBuildFilesForDeps());
    	Set projects = projectManager.getBuildProjects(fSelectedJavaProjects.iterator(), requiredProjectsCheckbox.getSelection());
        
        // confirm overwrite
        List confirmOverwrite = getConfirmOverwriteSet(projects);
        if (confirmOverwrite.size() > 0)
        {
            String message = DataTransferMessages.AntBuildfileExportPage_3 + ExportUtil.NEWLINE +
                ExportUtil.toString(confirmOverwrite, ExportUtil.NEWLINE);
            if (! ExportUtil.confirm(message, getShell()))
            {
                //return new TreeSet(ExportUtil.getProjectComparator());
            	return new TreeSet(ExtensionManager.createProjectManager().getProjectComparator());
            }
        }
        return projects;
    }

    /**
     * Returns given projects that have cyclic dependencies.
     * 
     * @param javaProjects list of IJavaProject objects
     * @return set of project names
     */
    private List getCyclicProjects(Set projects) throws CoreException {
        
        List cyclicProjects = new ArrayList();
        for (Iterator iter = projects.iterator(); iter.hasNext();)
        {
            IJavaProject javaProject = (IJavaProject) iter.next();
            if (ExportUtil.hasCyclicDependency(javaProject))
            {
                cyclicProjects.add(javaProject.getProject().getName());
            }
        }
        return cyclicProjects;
    }

    /**
     * Get list of projects which have already a buildfile that was not
     * created by eclipse2ant.
     * 
     * @param javaProjects list of IJavaProject objects
     * @return set of project names
     */
    private List getConfirmOverwriteSet(Set javaProjects)
    {
        List result = new ArrayList(javaProjects.size());
        for (Iterator iter = javaProjects.iterator(); iter.hasNext();) {
            Object o = iter.next();
            //String projectRoot = ExportUtil.getProjectRoot(o);
            String projectRoot = ExtensionManager.createProjectManager().getProjectRoot(o);
            if (ExportUtil.existsUserFile(projectRoot + '/' + BuildCreator.getBUILD_XML())) {
                result.add(ExtensionManager.createProjectManager().getProjectName(o));
            }
        }
        return result;
    }
}