/*******************************************************************************
 * Copyright (c) 2004, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Valery Kokhan - changes in order to produce correct build 
 *                     files for plug-in projects 
 *                     (original sourses from eclipse2ant)
 *******************************************************************************/

package org.eclipse.higgins.ant.internal.ui;

import java.net.URL;
import java.util.List;

import org.eclipse.higgins.ant.Higgins2AntPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

/**
 * Exports currently selected Eclipse Java project as an Ant buildfile.
 */
public class BuildfileExportWizard extends Wizard implements IExportWizard
{
    private IStructuredSelection fSelection;
    private BuildfileExportPage fMainPage;
    
    /**
     * Creates buildfile.
     */
    public boolean performFinish()
    {
        return fMainPage.generateBuildfiles();
    }
 
    public void addPages()
    {
        fMainPage = new BuildfileExportPage();
        List projects = fSelection.toList();
        fMainPage.setSelectedProjects(projects);
        addPage(fMainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection)
    {
        //setWindowTitle(DataTransferMessages.AntBuildfileExportWizard_0);
        setWindowTitle("Project Export Wizard");
        //setDefaultPageImageDescriptor(AntUIImages.getImageDescriptor(IAntUIConstants.IMG_WIZARD_BANNER)); // Eclipse 3.1
        //setDefaultPageImageDescriptor(AntUIImages.getImageDescriptor(IAntUIConstants.IMG_EXPORT_WIZARD_BANNER)); // bug 117776 // Eclipse 3.2
        // eclipse2ant specific code 
        URL url = Higgins2AntPlugin.getDefault().getBundle().getEntry("icons/full/wizban/export_ant_wiz.gif");
        ImageDescriptor desc = ImageDescriptor.createFromURL(url);
        setDefaultPageImageDescriptor(desc);
        
        fSelection= selection;
    }
}
