/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ant.core;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.higgins.ant.core.Higgins2AntCorePlugin;
import org.eclipse.higgins.ant.service.AbstractBuildFileCreator;
import org.eclipse.higgins.ant.service.BuildCreator;
import org.eclipse.higgins.ant.service.EclipseClasspath;
import org.eclipse.higgins.ant.service.ExportUtil;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class JavaProjectBuildFileCreator
extends AbstractBuildFileCreator {
    private IJavaProject javaProject;
    private EclipseClasspath classpath;
    private Set visited = new TreeSet();
    private Node classpathNode;

    public JavaProjectBuildFileCreator() {
    }

    public JavaProjectBuildFileCreator(IJavaProject project) throws Exception {
        super(projectManager.getProject((Object)project));
        this.javaProject = project;
        this.classpath = new EclipseClasspath(project);
        this.variable2valueMap = new LinkedHashMap();
    }

    protected void Init(IProject project) {
        super.Init(project);
        this.javaProject = projectManager.getJavaProject(project);
        try {
            this.classpath = new EclipseClasspath(this.javaProject);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        this.variable2valueMap = new LinkedHashMap();
    }

    protected void createProperty(EclipseClasspath classpath) {
        LinkedHashMap<String, Object> v2p = new LinkedHashMap<String, Object>();
        ArrayList<String> srcDirs = new ArrayList<String>();
        ArrayList<String> pkgNames = new ArrayList<String>();
        int i = 0;
        while (i < classpath.getSrcDirs().size()) {
            String dir = (String)classpath.getSrcDirs().get(i);
            if (!EclipseClasspath.isReference((String)dir)) {
                srcDirs.add(dir);
                pkgNames.add(this.getRootPackageName(dir, (IClasspathEntry)classpath.getSrcDir2Entry().get(dir)));
            }
            ++i;
        }
        Comment c = this.doc.createComment(" ======================================== ");
        v2p.put("c1", c);
        if (srcDirs.size() == 1) {
            v2p.put("source.dir", "${basedir}/" + srcDirs.get(0));
        } else {
            int i2 = 0;
            while (i2 < srcDirs.size()) {
                v2p.put("source.dir." + i2, "${basedir}/" + srcDirs.get(i2));
                ++i2;
            }
        }
        v2p.put("sources.dir", "${basedir}/..");
        v2p.put("build.dir", "${basedir}/build");
        v2p.put("build.dir.bin", "${build.dir}/bin");
        v2p.put("build.dir.lib", "${build.dir}/lib");
        v2p.put("build.dir.doc", "${build.dir}/doc");
        c = this.doc.createComment(" ======================================== ");
        v2p.put("c1.1", c);
        String jarName = this.projectName;
        jarName = jarName.replaceAll("org\\.eclipse\\.higgins", "higgins");
        jarName = jarName.replaceAll("\\.", "-");
        v2p.put("build.file.name", jarName);
        String javadocPackages = "";
        boolean first = true;
        int i3 = 0;
        while (i3 < pkgNames.size()) {
            if (first) {
                first = false;
            } else {
                javadocPackages = String.valueOf(javadocPackages) + ",";
            }
            javadocPackages = String.valueOf(javadocPackages) + pkgNames.get(i3);
            ++i3;
        }
        v2p.put("build.doc.packages", javadocPackages);
        try {
            Document tdoc = projectManager.getTemplate("higgins2ant.core", "properties");
            Element troot = tdoc.getDocumentElement();
            NodeList nl = troot.getChildNodes();
            int length = nl.getLength();
            first = true;
            Node node = this.root.getFirstChild();
            int i4 = 0;
            while (i4 < length) {
                Node n = nl.item(i4);
                Node n1 = this.doc.importNode(n, true);
                if (first) {
                    first = false;
                } else {
                    node = node.getNextSibling();
                }
                node = this.root.insertBefore(n1, node);
                ++i4;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        c = this.doc.createComment(" ======================================== ");
        v2p.put("c11", c);
        Element path = this.doc.createElement("path");
        path.setAttribute("id", "project.source");
        if (srcDirs.size() == 1) {
            Element pathelement = this.doc.createElement("pathelement");
            pathelement.setAttribute("location", "${source.dir}");
            path.appendChild(pathelement);
        } else {
            int i5 = 0;
            while (i5 < srcDirs.size()) {
                Element pathelement = this.doc.createElement("pathelement");
                pathelement.setAttribute("location", "${source.dir." + i5 + "}");
                path.appendChild(pathelement);
                ++i5;
            }
        }
        v2p.put("path", path);
        first = true;
        Node node = this.root.getFirstChild();
        Iterator iterator = v2p.keySet().iterator();
        while (iterator.hasNext()) {
            Node prop = null;
            String key = (String)iterator.next();
            Object o = v2p.get(key);
            if (o instanceof Node) {
                prop = (Node)o;
            } else if (o instanceof String) {
                String value = (String)o;
                Element e = this.doc.createElement("property");
                e.setAttribute("name", key);
                e.setAttribute("value", value);
                prop = e;
            }
            if (prop == null) continue;
            if (first) {
                first = false;
            } else {
                node = node.getNextSibling();
            }
            node = this.root.insertBefore(prop, node);
        }
    }

    private void addSubProperties(IJavaProject subproject, EclipseClasspath classpath) throws JavaModelException {
        String location = String.valueOf(subproject.getProject().getName()) + ".location";
        String relativePath = ExportUtil.getRelativePath((String)this.projectRoot, (String)this.projectRoot);
        this.variable2valueMap.put(location, relativePath);
        this.variable2valueMap.putAll(classpath.getVariable2valueMap());
        Iterator iterator = projectManager.getClasspathProjectsRecursive((Object)subproject).iterator();
        while (iterator.hasNext()) {
            IJavaProject subProject = (IJavaProject)iterator.next();
            location = String.valueOf(subProject.getProject().getName()) + ".location";
            String subProjectRoot = projectManager.getProjectRoot((Object)subProject);
            relativePath = ExportUtil.getRelativePath((String)subProjectRoot, (String)this.projectRoot);
            this.variable2valueMap.put(location, relativePath);
        }
    }

    protected void createVersion() {
        Comment c = this.doc.createComment(" Reads project version from plugin's manifest file ");
        this.root.appendChild(c);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "-version");
        element.setAttribute("unless", "project.version");
        Element property = this.doc.createElement("property");
        property.setAttribute("file", "${project.manifest}");
        property.setAttribute("prefix", "project.mf");
        element.appendChild(property);
        property = this.doc.createElement("xmlproperty");
        property.setAttribute("file", "${project.xml}");
        property.setAttribute("prefix", "project.xml");
        property.setAttribute("collapseattributes", "true");
        element.appendChild(property);
        Element condition = this.doc.createElement("condition");
        condition.setAttribute("property", "project.version");
        condition.setAttribute("value", "${project.mf.Bundle-Version}");
        element.appendChild(condition);
        Element isset = this.doc.createElement("isset");
        isset.setAttribute("property", "project.mf.Bundle-Version");
        condition.appendChild(isset);
        condition = this.doc.createElement("condition");
        condition.setAttribute("property", "project.version");
        condition.setAttribute("value", "${project.xml.plugin.version}");
        element.appendChild(condition);
        isset = this.doc.createElement("isset");
        isset.setAttribute("property", "project.xml.plugin.version");
        condition.appendChild(isset);
        property = this.doc.createElement("property");
        property.setAttribute("name", "project.version");
        property.setAttribute("value", "0.1.0");
        element.appendChild(property);
        condition = this.doc.createElement("condition");
        condition.setAttribute("property", "project.name");
        condition.setAttribute("value", "${project.mf.Bundle-Name}");
        element.appendChild(condition);
        isset = this.doc.createElement("isset");
        isset.setAttribute("property", "project.mf.Bundle-Name");
        condition.appendChild(isset);
        condition = this.doc.createElement("condition");
        condition.setAttribute("property", "project.name");
        condition.setAttribute("value", "${project.xml.plugin.name}");
        element.appendChild(condition);
        isset = this.doc.createElement("isset");
        isset.setAttribute("property", "project.xml.plugin.name");
        condition.appendChild(isset);
        this.root.appendChild(element);
    }

    protected void createOverride(EclipseClasspath classpath) {
        Element path;
        String name;
        Comment c = this.doc.createComment(" Overrides plug-in dependencies classpath ");
        this.root.appendChild(c);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "-override");
        element.setAttribute("depends", "-override_e,-override_n");
        this.root.appendChild(element);
        element = this.doc.createElement("target");
        element.setAttribute("name", "-override_e");
        element.setAttribute("if", "eclipse.available");
        IClasspathContainer container = classpath.resolveUserLibraryReference(classpath.getPluginRef());
        if (container != null) {
            name = ExportUtil.removePrefixAndSuffix((String)classpath.getPluginRef(), (String)"${", (String)"}");
            path = this.doc.createElement("path");
            path.setAttribute("id", name);
            element.appendChild(path);
            Element fileset = this.doc.createElement("fileset");
            fileset.setAttribute("dir", "${eclipse.home}/plugins");
            IClasspathEntry[] entries = container.getClasspathEntries();
            int i = 0;
            while (i < entries.length) {
                String jarFile = entries[i].getPath().toString();
                IPath home = JavaCore.getClasspathVariable((String)"ECLIPSE_HOME");
                if (home.isPrefixOf(entries[i].getPath())) {
                    jarFile = "${eclipse.home}" + jarFile.substring(home.toString().length());
                    Pattern p = Pattern.compile("(\\$\\{eclipse.home}/plugins/)([^_]*)_([^/]*)(.*).jar");
                    Matcher m = p.matcher(jarFile);
                    if (m.matches()) {
                        String jname = m.replaceAll("$2_*$4.jar");
                        Element includeElement = this.doc.createElement("include");
                        includeElement.setAttribute("name", jname);
                        fileset.appendChild(includeElement);
                    }
                }
                ++i;
            }
            if (fileset.hasChildNodes()) {
                path.appendChild(fileset);
            }
        }
        this.root.appendChild(element);
        element = this.doc.createElement("target");
        element.setAttribute("name", "-override_n");
        element.setAttribute("unless", "eclipse.available");
        if (container != null) {
            name = ExportUtil.removePrefixAndSuffix((String)classpath.getPluginRef(), (String)"${", (String)"}");
            path = this.doc.createElement("path");
            path.setAttribute("id", name);
            element.appendChild(path);
        }
        this.root.appendChild(element);
    }

    protected void createCopyJar(List srcDirs) {
        Comment c = this.doc.createComment("Copies project's JAR file to user defined dir");
        this.root.appendChild(c);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "copy.jar");
        element.setAttribute("depends", "jar");
        element.setAttribute("if", "toDir");
        if (srcDirs.size() > 0) {
            Element copy = this.doc.createElement("copy");
            copy.setAttribute("file", "${build.dir.lib}/${build.file.name}_${project.version}.jar");
            copy.setAttribute("todir", "${toDir}");
            element.appendChild(copy);
        }
        this.root.appendChild(element);
    }

    protected void createCopyDepJars() throws JavaModelException {
        Comment c = this.doc.createComment("Copies all dependency JARs to user defined dir");
        this.root.appendChild(c);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "-copy.dep.jars");
        element.setAttribute("if", "toDir");
        element.setAttribute("depends", "-load.build.properties");
        element.setAttribute("unless", "build.properties." + this.projectName + ".copy.all.jars.done");
        Iterator iterator = projectManager.getClasspathProjectsRecursive((Object)this.javaProject).iterator();
        while (iterator.hasNext()) {
            IJavaProject subProject = (IJavaProject)iterator.next();
            Element ant = this.doc.createElement("ant");
            ant.setAttribute("antfile", "build.xml");
            ant.setAttribute("dir", "${" + subProject.getProject().getName() + ".location}");
            ant.setAttribute("inheritAll", "false");
            ant.setAttribute("target", "copy.all.jars");
            Element proptwo = this.doc.createElement("propertyset");
            proptwo.setAttribute("refid", "copy.properties");
            ant.appendChild(proptwo);
            element.appendChild(ant);
        }
        this.root.appendChild(element);
    }

    protected void createCopyAllJars() throws JavaModelException {
        Comment c = this.doc.createComment("Copies all JARs to user defined dir");
        this.root.appendChild(c);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "copy.all.jars");
        element.setAttribute("if", "toDir");
        element.setAttribute("depends", "copy.jar,-copy.dep.jars");
        element.setAttribute("unless", "build.properties." + this.projectName + ".copy.all.jars.done");
        Element property = this.doc.createElement("property");
        property.setAttribute("name", "build.properties." + this.projectName + ".copy.all.jars.done");
        property.setAttribute("value", "true");
        element.appendChild(property);
        Element antcall = this.doc.createElement("antcall");
        antcall.setAttribute("target", "-save.build.properties");
        element.appendChild(antcall);
        this.root.appendChild(element);
    }

    protected void createCopyLibraries(EclipseClasspath classpath) throws JavaModelException {
        ArrayList<String> l;
        Comment c = this.doc.createComment("Copies all project required libraries to user defined dir");
        this.root.appendChild(c);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "copy.libs");
        element.setAttribute("if", "toDir");
        HashMap<String, ArrayList<String>> paths = new HashMap<String, ArrayList<String>>();
        List list = ExportUtil.removeDuplicates((List)classpath.getRawClassPathEntries());
        int i = 0;
        while (i < list.size()) {
            if (!((String)list.get(i)).endsWith("}") && (((String)list.get(i)).endsWith(".jar") || ((String)list.get(i)).endsWith(".zip"))) {
                String path;
                String folderPath;
                String rawPath = (String)list.get(i);
                if (rawPath.startsWith("${")) {
                    folderPath = rawPath.substring(0, rawPath.lastIndexOf(125) + 1);
                    path = rawPath.substring(rawPath.lastIndexOf(125) + 2);
                } else {
                    folderPath = rawPath.substring(0, rawPath.lastIndexOf(47));
                    path = rawPath.substring(rawPath.lastIndexOf(47) + 1);
                }
                l = (List)paths.get(folderPath);
                if (l == null) {
                    l = new ArrayList<String>();
                    paths.put(folderPath, l);
                }
                l.add(path);
            }
            ++i;
        }
        Iterator itr = paths.keySet().iterator();
        if (itr.hasNext()) {
            Element copy = this.doc.createElement("copy");
            copy.setAttribute("todir", "${toDir}");
            copy.setAttribute("flatten", "true");
            while (itr.hasNext()) {
                String curFolder = (String)itr.next();
                Element fileset = this.doc.createElement("fileset");
                l = (ArrayList<String>)paths.get(curFolder);
                int k = 0;
                while (k < l.size()) {
                    String s = (String)l.get(k);
                    Element lib = this.doc.createElement("include");
                    lib.setAttribute("name", s);
                    fileset.appendChild(lib);
                    ++k;
                }
                Iterator iterator = projectManager.getClasspathProjectsRecursive((Object)this.javaProject).iterator();
                while (iterator.hasNext()) {
                    IJavaProject subProject = (IJavaProject)iterator.next();
                    String subProjectRoot = projectManager.getProjectRoot((Object)subProject);
                    int pathIsHere = curFolder.indexOf(subProjectRoot);
                    if (pathIsHere <= -1 || curFolder.charAt(pathIsHere + subProjectRoot.length()) != '/') continue;
                    curFolder = "${" + subProject.getProject().getName() + ".location}" + curFolder.substring(subProjectRoot.length());
                    break;
                }
                if (!curFolder.startsWith("${")) {
                    curFolder = "${basedir}/" + ExportUtil.getRelativePath((String)curFolder, (String)this.projectRoot);
                }
                fileset.setAttribute("dir", curFolder);
                copy.appendChild(fileset);
            }
            element.appendChild(copy);
        }
        this.root.appendChild(element);
    }

    protected void createJar(List srcDirs) {
        Comment c = this.doc.createComment(" Creates jar file ");
        this.root.appendChild(c);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "jar");
        element.setAttribute("depends", "build");
        element.setAttribute("unless", "build.properties." + this.projectName + ".jar.done");
        if (srcDirs.size() > 0) {
            Element jar = this.doc.createElement("jar");
            jar.setAttribute("jarfile", "${build.dir.lib}/${build.file.name}_${project.version}.jar");
            jar.setAttribute("basedir", "${build.dir.bin}");
            jar.setAttribute("filesonly", "false");
            element.appendChild(jar);
            Element property = this.doc.createElement("property");
            property.setAttribute("name", "build.properties." + this.projectName + ".jar.done");
            property.setAttribute("value", "true");
            Element antcall = this.doc.createElement("antcall");
            antcall.setAttribute("target", "-save.build.properties");
            element.appendChild(property);
            element.appendChild(antcall);
        }
        this.root.appendChild(element);
    }

    protected void createPlugin(EclipseClasspath classpath) {
        try {
            if (projectManager.isPluginProject(this.javaProject.getProject())) {
                Document tdoc = projectManager.getTemplate("higgins2ant.core", "pluginBuilder");
                Element troot = tdoc.getDocumentElement();
                NodeList nl = troot.getChildNodes();
                int length = nl.getLength();
                int i = 0;
                while (i < length) {
                    Element e;
                    Node n = nl.item(i);
                    Node n1 = this.doc.importNode(n, true);
                    if (n1.getNodeType() == 1 && (e = (Element)n1).getNodeName().equals("target") && e.getAttribute("name").equals("-initPluginSources")) {
                        this.createInitPluginSources(classpath, e);
                    }
                    this.root.appendChild(n1);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createInitPluginSources(EclipseClasspath classpath, Element target) throws JavaModelException {
        Element copy = this.createCopyProjectSources(this.javaProject, classpath);
        target.appendChild(copy);
        List subProjects = projectManager.getClasspathProjectsRecursive((Object)this.javaProject);
        Iterator iterator = subProjects.iterator();
        while (iterator.hasNext()) {
            IJavaProject subProject = (IJavaProject)iterator.next();
            EclipseClasspath cp = new EclipseClasspath(subProject);
            copy = this.createCopyProjectSources(subProject, cp);
            target.appendChild(copy);
        }
    }

    private Element createCopyProjectSources(IJavaProject project, EclipseClasspath classpath) {
        String projectName = project.getProject().getName();
        Element copy = this.doc.createElement("copy");
        copy.setAttribute("todir", "${temp.dir.plugins}/" + projectName);
        copy.setAttribute("failonerror", "true");
        Element fileset = this.doc.createElement("fileset");
        fileset.setAttribute("dir", "${" + projectName + ".location}");
        fileset.setAttribute("excludes", "**/bin/,**/build/,**/temp.**/,**/doc/,**/cvs/,**/.svn/,**/*.psf,dependencies.xml");
        copy.appendChild(fileset);
        if (classpath.getSrcDirs().size() > 0) {
            int size = classpath.getSrcDirs().size();
            int i = 0;
            while (i < size) {
                String srcDir = (String)classpath.getSrcDirs().get(i);
                if (!EclipseClasspath.isReference((String)srcDir)) {
                    List exclusions = (List)classpath.getExclusionLists().get(i);
                    Iterator iter = exclusions.iterator();
                    while (iter.hasNext()) {
                        String exclusion = (String)iter.next();
                        Element excludeElement = this.doc.createElement("exclude");
                        excludeElement.setAttribute("name", String.valueOf(srcDir) + "/" + exclusion);
                        fileset.appendChild(excludeElement);
                    }
                }
                ++i;
            }
        }
        return copy;
    }

    protected void createJavadoc() {
        Comment c = this.doc.createComment(" ======================================== ");
        this.root.appendChild(c);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "-prejavadoc");
        element.setAttribute("depends", "-init");
        Element delete = this.doc.createElement("delete");
        element.appendChild(delete);
        Element fileset = this.doc.createElement("fileset");
        fileset.setAttribute("dir", "${build.dir.doc}");
        delete.appendChild(fileset);
        Element include = this.doc.createElement("include");
        include.setAttribute("name", "**/*");
        fileset.appendChild(include);
        Element exclude = this.doc.createElement("exclude");
        exclude.setAttribute("name", "**/CVS");
        fileset.appendChild(exclude);
        exclude = this.doc.createElement("exclude");
        exclude.setAttribute("name", "**/Entries");
        fileset.appendChild(exclude);
        exclude = this.doc.createElement("exclude");
        exclude.setAttribute("name", "**/Repository");
        fileset.appendChild(exclude);
        exclude = this.doc.createElement("exclude");
        exclude.setAttribute("name", "**/Root");
        fileset.appendChild(exclude);
        this.root.appendChild(element);
        c = this.doc.createComment(" Creates javadoc for the project ");
        this.root.appendChild(c);
        element = this.doc.createElement("target");
        element.setAttribute("name", "javadoc");
        element.setAttribute("depends", "-init, -override");
        Element javadoc = this.doc.createElement("javadoc");
        javadoc.setAttribute("packagenames", "${build.doc.packages}");
        javadoc.setAttribute("excludepackagenames", "${build.src.excludes}");
        javadoc.setAttribute("sourcepathref", "project.source");
        javadoc.setAttribute("defaultexcludes", "yes");
        javadoc.setAttribute("destdir", "${build.dir.doc}");
        javadoc.setAttribute("author", "true");
        javadoc.setAttribute("version", "true");
        javadoc.setAttribute("windowtitle", "${project.name}");
        javadoc.setAttribute("use", "true");
        javadoc.setAttribute("public", "true");
        javadoc.setAttribute("source", "${javacSource}");
        element.appendChild(javadoc);
        Element classpath = this.doc.createElement("classpath");
        classpath.setAttribute("refid", String.valueOf(this.projectName) + ".classpath");
        javadoc.appendChild(classpath);
        Element doctitle = this.doc.createElement("doctitle");
        javadoc.appendChild(doctitle);
        CDATASection data = this.doc.createCDATASection("<h1>${project.name}</h1");
        doctitle.appendChild(data);
        Element link = this.doc.createElement("link");
        link.setAttribute("href", "http://java.sun.com/j2se/1.4.2/docs/api/");
        javadoc.appendChild(link);
        this.root.appendChild(element);
        c = this.doc.createComment(" ======================================== ");
        this.root.appendChild(c);
        element = this.doc.createElement("target");
        element.setAttribute("name", "-postjavadoc");
        Element zip = this.doc.createElement("zip");
        zip.setAttribute("destfile", "${build.file.name}_${project.version}_javadoc.zip");
        zip.setAttribute("basedir", "${build.dir.doc}");
        zip.setAttribute("update", "true");
        element.appendChild(zip);
        this.root.appendChild(element);
    }

    protected void createClean() {
        Comment c = this.doc.createComment(" Cleans build folder of the project ");
        this.root.appendChild(c);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "clean");
        Element deleteElement = this.doc.createElement("delete");
        deleteElement.setAttribute("failonerror", "false");
        Element filesetElement = this.doc.createElement("fileset");
        filesetElement.setAttribute("dir", "${build.dir}");
        deleteElement.appendChild(filesetElement);
        deleteElement.setAttribute("includeemptydirs", "true");
        element.appendChild(deleteElement);
        this.root.appendChild(element);
    }

    protected void createCleanAll() throws JavaModelException {
        Comment c = this.doc.createComment(" Cleans build folders of dependency projects ");
        this.root.appendChild(c);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "cleanall");
        element.setAttribute("depends", "clean");
        List subProjects = projectManager.getClasspathProjectsRecursive((Object)this.javaProject);
        Iterator iterator = subProjects.iterator();
        while (iterator.hasNext()) {
            IJavaProject subProject = (IJavaProject)iterator.next();
            String targetName = "clean";
            Element antElement = this.doc.createElement("ant");
            antElement.setAttribute("dir", "${" + subProject.getProject().getName() + ".location}");
            antElement.setAttribute("antfile", BuildCreator.getBUILD_XML());
            antElement.setAttribute("target", targetName);
            antElement.setAttribute("inheritAll", "false");
            element.appendChild(antElement);
        }
        this.root.appendChild(element);
    }

    protected void createBuild(List srcDirs, List classDirs, List inclusionLists, List exclusionLists) throws JavaModelException {
        Comment c = this.doc.createComment(" Builds the source code ");
        this.root.appendChild(c);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "build");
        element.setAttribute("depends", "-build-project");
        element.setAttribute("unless", "build.properties." + this.projectName + ".build.done");
        this.createCopyResources(srcDirs, classDirs, element);
        Element property = this.doc.createElement("property");
        property.setAttribute("name", "build.properties." + this.projectName + ".build.done");
        property.setAttribute("value", "true");
        Element antcall = this.doc.createElement("antcall");
        antcall.setAttribute("target", "-save.build.properties");
        element.appendChild(property);
        element.appendChild(antcall);
        this.root.appendChild(element);
    }

    protected void createBuildProject(List srcDirs, List classDirs, List inclusionLists, List exclusionLists) throws JavaModelException {
        Comment c = this.doc.createComment(" Compiles the source code of the project ");
        this.root.appendChild(c);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "-build-project");
        element.setAttribute("depends", "-init, -override, -build-subprojects");
        element.setAttribute("unless", "build.properties." + this.projectName + ".build.done");
        if (srcDirs.size() > 0) {
            Element javac = this.doc.createElement("javac");
            javac.setAttribute("destdir", "${build.dir.bin}");
            javac.setAttribute("debug", "${javacDebugInfo}");
            javac.setAttribute("source", "${javacSource}");
            javac.setAttribute("target", "${javacTarget}");
            javac.setAttribute("verbose", "${javacVerbose}");
            javac.setAttribute("excludes", "${build.src.excludes}");
            Element src = this.doc.createElement("src");
            src.setAttribute("refid", "project.source");
            javac.appendChild(src);
            int i = 0;
            while (i < srcDirs.size()) {
                String srcDir = (String)srcDirs.get(i);
                if (!EclipseClasspath.isReference((String)srcDir)) {
                    List inclusions = (List)inclusionLists.get(i);
                    List exclusions = (List)exclusionLists.get(i);
                    Iterator iter = inclusions.iterator();
                    while (iter.hasNext()) {
                        String inclusion = (String)iter.next();
                        Element includeElement = this.doc.createElement("include");
                        includeElement.setAttribute("name", inclusion);
                        javac.appendChild(includeElement);
                    }
                    iter = exclusions.iterator();
                    while (iter.hasNext()) {
                        String exclusion = (String)iter.next();
                        Element excludeElement = this.doc.createElement("exclude");
                        excludeElement.setAttribute("name", exclusion);
                        javac.appendChild(excludeElement);
                    }
                }
                ++i;
            }
            Element classpath = this.doc.createElement("classpath");
            classpath.setAttribute("refid", String.valueOf(this.projectName) + ".classpath");
            javac.appendChild(classpath);
            element.appendChild(javac);
        }
        this.root.appendChild(element);
    }

    protected void createBuildSubprojects(List srcDirs, List classDirs, List inclusionLists, List exclusionLists) throws JavaModelException {
        Comment c = this.doc.createComment(" Compiles the source code of the subprojects ");
        this.root.appendChild(c);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "-build-subprojects");
        element.setAttribute("depends", "-init, -override");
        element.setAttribute("unless", "build.properties." + this.projectName + ".build.done");
        List subProjects = projectManager.getClasspathProjectsRecursive((Object)this.javaProject);
        Iterator iterator = subProjects.iterator();
        while (iterator.hasNext()) {
            IJavaProject subProject = (IJavaProject)iterator.next();
            Element antElement = this.doc.createElement("ant");
            antElement.setAttribute("dir", "${" + subProject.getProject().getName() + ".location}");
            antElement.setAttribute("antfile", BuildCreator.getBUILD_XML());
            antElement.setAttribute("target", "build");
            antElement.setAttribute("inheritAll", "false");
            Element propertyset = this.doc.createElement("propertyset");
            propertyset.setAttribute("refid", "build.properties");
            antElement.appendChild(propertyset);
            element.appendChild(antElement);
        }
        this.root.appendChild(element);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getRootPackageName(String dir, IClasspathEntry entry) {
        String name = "*";
        try {
            IPackageFragmentRoot[] r = this.javaProject.findPackageFragmentRoots(entry);
            int i = 0;
            while (true) {
                if (i >= r.length) {
                    return name;
                }
                IPackageFragment prev = null;
                IPackageFragment root = null;
                IJavaElement[] e = r[i].getChildren();
                int j = 0;
                while (j < e.length) {
                    block11: {
                        IPackageFragment pf;
                        if (e[j] instanceof IPackageFragment && !(pf = (IPackageFragment)e[j]).isDefaultPackage()) {
                            if (pf.containsJavaResources()) {
                                if (root == null) {
                                    root = pf;
                                    break block11;
                                } else {
                                    IPath p1 = pf.getPath();
                                    IPath p2 = root.getPath();
                                    if (p2.segmentCount() != p1.segmentCount() || p2.matchingFirstSegments(p1) != p1.segmentCount() - 1) break;
                                    root = prev;
                                    break;
                                }
                            }
                            if (root == null) {
                                prev = pf;
                            }
                        }
                    }
                    ++j;
                }
                if (root != null) {
                    name = String.valueOf(root.getElementName()) + ".*";
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    protected void createPropertyM() {
        boolean source = "generate".equals(this.javaProject.getOption("org.eclipse.jdt.core.compiler.debug.sourceFile", true));
        boolean lines = "generate".equals(this.javaProject.getOption("org.eclipse.jdt.core.compiler.debug.lineNumber", true));
        boolean vars = "generate".equals(this.javaProject.getOption("org.eclipse.jdt.core.compiler.debug.localVariable", true));
        ArrayList<String> debuglevel = new ArrayList<String>();
        if (source) {
            debuglevel.add("source");
        }
        if (lines) {
            debuglevel.add("lines");
        }
        if (vars) {
            debuglevel.add("vars");
        }
        if (debuglevel.size() == 0) {
            debuglevel.add("none");
        }
        this.variable2valueMap.put("debuglevel", ExportUtil.toString(debuglevel, (String)","));
        String target = this.javaProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true);
        this.variable2valueMap.put("target", target);
        String sourceLevel = this.javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        this.variable2valueMap.put("source", sourceLevel);
        boolean first = true;
        Node node = this.root.getFirstChild();
        Iterator iterator = this.variable2valueMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)this.variable2valueMap.get(key);
            Element prop = this.doc.createElement("property");
            prop.setAttribute("name", key);
            prop.setAttribute("value", value);
            if (first) {
                first = false;
            } else {
                node = node.getNextSibling();
            }
            node = this.root.insertBefore(prop, node);
        }
        Element env = this.doc.createElement("property");
        env.setAttribute("environment", "env");
        this.root.insertBefore(env, this.root.getFirstChild());
        IPath home = JavaCore.getClasspathVariable((String)"ECLIPSE_HOME");
        String home_ecl = home.toString();
        Element ecl = this.doc.createElement("property");
        ecl.setAttribute("name", "ECLIPSE_HOME");
        ecl.setAttribute("value", home_ecl);
        this.root.insertBefore(ecl, this.root.getFirstChild());
    }

    protected void createImports() {
        File dir = new File(this.projectRoot);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File acceptDir, String name) {
                return name.endsWith(".xml") && !name.endsWith(BuildCreator.getBUILD_XML());
            }
        };
        File[] files = dir.listFiles(filter);
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            try {
                Document docCandidate = ExportUtil.parseXmlFile((File)file);
                Node node = docCandidate.getFirstChild();
                if (node instanceof ProcessingInstruction && "eclipse.ant.import".equals(((ProcessingInstruction)node).getTarget().trim())) {
                    Element element = this.doc.createElement("import");
                    element.setAttribute("file", file.getName());
                    this.root.appendChild(element);
                }
            }
            catch (ParserConfigurationException e) {
                Higgins2AntCorePlugin.log("invalid XML file not imported: " + file.getAbsolutePath(), e);
            }
            catch (SAXException e) {
                Higgins2AntCorePlugin.log("invalid XML file not imported: " + file.getAbsolutePath(), e);
            }
            catch (IOException e) {
                Higgins2AntCorePlugin.log("invalid XML file not imported: " + file.getAbsolutePath(), e);
            }
            ++i;
        }
    }

    private void createClasspaths(EclipseClasspath classpath) throws JavaModelException {
        this.createClasspathsM(null, this.javaProject, classpath);
    }

    private void createClasspathsM(String pathId, IJavaProject currentProject, EclipseClasspath classpath) throws JavaModelException {
        if (currentProject == null) {
            Higgins2AntCorePlugin.log("project is not loaded in workspace: " + pathId, null);
            return;
        }
        boolean isMain = false;
        Element element = this.doc.createElement("path");
        if (pathId == null) {
            pathId = String.valueOf(currentProject.getProject().getName()) + ".classpath";
            isMain = true;
        }
        element.setAttribute("id", pathId);
        this.visited.add(pathId);
        this.variable2valueMap.putAll(classpath.getVariable2valueMap());
        Iterator iter = ExportUtil.removeDuplicates((List)classpath.getRawClassPathEntries()).iterator();
        while (iter.hasNext()) {
            String currentProjectRoot;
            String entry = (String)iter.next();
            if (EclipseClasspath.isProjectReference((String)entry)) {
                Element pathElement = this.doc.createElement("path");
                IJavaProject referencedProject = EclipseClasspath.resolveProjectReference((String)entry);
                if (referencedProject == null) {
                    Higgins2AntCorePlugin.log("project is not loaded in workspace: " + pathId, null);
                    continue;
                }
                String refPathId = String.valueOf(referencedProject.getProject().getName()) + ".classpath";
                pathElement.setAttribute("refid", refPathId);
                element.appendChild(pathElement);
                if (!this.visited.add(refPathId)) continue;
                this.createClasspathsM(refPathId, referencedProject, new EclipseClasspath(referencedProject));
                continue;
            }
            if (EclipseClasspath.isUserLibraryReference((String)entry) || EclipseClasspath.isUserSystemLibraryReference((String)entry) || EclipseClasspath.isLibraryReference((String)entry)) {
                if (!isMain) continue;
                this.addUserLibraryM(classpath, element, entry);
                continue;
            }
            String prefix = "";
            if (!(entry.startsWith("${") || this.projectName.equals(currentProject.getProject().getName()) || new Path(entry = ExportUtil.getRelativePath((String)entry, (String)(currentProjectRoot = projectManager.getProjectRoot((Object)currentProject)))).isAbsolute())) {
                prefix = "${" + currentProject.getProject().getName() + ".location}/";
            }
            Element pathElement = this.doc.createElement("pathelement");
            String path = ExportUtil.getRelativePath((String)(String.valueOf(prefix) + entry), (String)this.projectRoot);
            pathElement.setAttribute("location", path);
            element.appendChild(pathElement);
        }
        this.addToClasspathBlockM(element);
    }

    private void addUserLibraryM(EclipseClasspath classpath, Element element, String entry) {
        Element pathElement = this.doc.createElement("path");
        IClasspathContainer container = classpath.resolveUserLibraryReference(entry);
        String name = ExportUtil.removePrefixAndSuffix((String)entry, (String)"${", (String)"}");
        pathElement.setAttribute("refid", name);
        if (!EclipseClasspath.isUserSystemLibraryReference((String)entry)) {
            element.appendChild(pathElement);
        }
        if (this.visited.add(entry) && !name.equals("Plug-in Dependencies.libraryclasspath")) {
            Element userElement = this.doc.createElement("path");
            userElement.setAttribute("id", name);
            Element filesetElement = null;
            IClasspathEntry[] entries = container.getClasspathEntries();
            int i = 0;
            while (i < entries.length) {
                String jarFile = entries[i].getPath().toString();
                boolean addPathElement = true;
                if (EclipseClasspath.isLibraryReference((String)entry)) {
                    IPath home = JavaCore.getClasspathVariable((String)"ECLIPSE_HOME");
                    if (home.isPrefixOf(entries[i].getPath())) {
                        this.variable2valueMap.put("ECLIPSE_HOME", home.toString());
                        if (filesetElement == null) {
                            filesetElement = this.doc.createElement("fileset");
                            filesetElement.setAttribute("dir", "${ECLIPSE_HOME}/plugins");
                            userElement.appendChild(filesetElement);
                        }
                        jarFile = "${ECLIPSE_HOME}" + jarFile.substring(home.toString().length());
                        Pattern p = Pattern.compile("(\\$\\{ECLIPSE_HOME}/plugins/)([^_]*)_([^/]*)(.*).jar");
                        Matcher m = p.matcher(jarFile);
                        if (m.matches()) {
                            String jname = m.replaceAll("$2_*$4.jar");
                            Element includeElement = this.doc.createElement("include");
                            includeElement.setAttribute("name", jname);
                            filesetElement.appendChild(includeElement);
                            addPathElement = false;
                        }
                    } else if (!new File(jarFile).exists() && jarFile.startsWith(String.valueOf('/') + this.projectName) && new File(this.projectRoot, jarFile.substring((String.valueOf('/') + this.projectName).length())).exists()) {
                        jarFile = jarFile.substring((String.valueOf('/') + this.projectName).length() + 1);
                    } else {
                        String projectName = ExportUtil.removePrefix((String)entries[i].getPath().toString(), (String)"/");
                        IJavaProject project = projectManager.getJavaProjectByName(projectName);
                        if (project != null) {
                            jarFile = projectManager.getProjectRoot((Object)project);
                        }
                    }
                }
                if (addPathElement) {
                    jarFile = ExportUtil.getRelativePath((String)jarFile, (String)this.projectRoot);
                    Element userPathElement = this.doc.createElement("pathelement");
                    userPathElement.setAttribute("location", jarFile);
                    userElement.appendChild(userPathElement);
                }
                ++i;
            }
            this.addToClasspathBlockM(userElement);
        }
    }

    private void addToClasspathBlockM(Element element) {
        if (this.classpathNode == null) {
            this.classpathNode = this.root.appendChild(element);
        } else {
            this.classpathNode = this.classpathNode.getNextSibling();
            this.classpathNode = this.root.insertBefore(element, this.classpathNode);
        }
    }

    protected void createLoadProperties() {
        Comment c = this.doc.createComment(" Loads build properties ");
        this.root.appendChild(c);
        Element target = this.doc.createElement("target");
        target.setAttribute("name", "-load.build.properties");
        target.setAttribute("if", "build.properties.file");
        Element property = this.doc.createElement("property");
        property.setAttribute("file", "${build.properties.file}");
        target.appendChild(property);
        this.root.appendChild(target);
    }

    protected void createSaveProperties() {
        Comment c = this.doc.createComment(" Saves build properties ");
        this.root.appendChild(c);
        Element target = this.doc.createElement("target");
        target.setAttribute("name", "-save.build.properties");
        target.setAttribute("if", "build.properties.file");
        Element echoproperties = this.doc.createElement("echoproperties");
        echoproperties.setAttribute("destfile", "${build.properties.file}");
        echoproperties.setAttribute("prefix", "build.properties");
        target.appendChild(echoproperties);
        this.root.appendChild(target);
    }

    protected void createInit(List srcDirs, List classDirs) {
        Comment c = this.doc.createComment(" Initializes build directories ");
        this.root.appendChild(c);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "-init");
        element.setAttribute("depends", "-version,-load.build.properties");
        Element mkdir = this.doc.createElement("mkdir");
        mkdir.setAttribute("dir", "${build.dir}");
        element.appendChild(mkdir);
        mkdir = this.doc.createElement("mkdir");
        mkdir.setAttribute("dir", "${build.dir.bin}");
        element.appendChild(mkdir);
        mkdir = this.doc.createElement("mkdir");
        mkdir.setAttribute("dir", "${build.dir.lib}");
        element.appendChild(mkdir);
        mkdir = this.doc.createElement("mkdir");
        mkdir.setAttribute("dir", "${build.dir.doc}");
        element.appendChild(mkdir);
        this.root.appendChild(element);
    }

    private void createCopyResources(List srcDirs, List classDirs, Element element) {
        String filter = this.javaProject.getOption("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", true);
        StringTokenizer tokenizer = new StringTokenizer(filter, ",");
        ArrayList<Object> filters = Collections.list(tokenizer);
        filters.add("*.java");
        int i = 0;
        while (i < filters.size()) {
            String item = ((String)filters.get(i)).trim();
            if (item.equals("*")) {
                return;
            }
            filters.set(i, "**/" + item);
            ++i;
        }
        i = 0;
        while (i < srcDirs.size()) {
            String srcDir = (String)srcDirs.get(i);
            String classDir = (String)classDirs.get(i);
            if (!EclipseClasspath.isReference((String)classDir)) {
                Element copyElement = this.doc.createElement("copy");
                copyElement.setAttribute("todir", classDir);
                copyElement.setAttribute("includeemptydirs", "false");
                Element filesetElement = this.doc.createElement("fileset");
                filesetElement.setAttribute("dir", srcDir);
                filesetElement.setAttribute("excludes", ExportUtil.toString(filters, (String)", "));
                copyElement.appendChild(filesetElement);
                element.appendChild(copyElement);
            }
            ++i;
        }
    }

    protected boolean create(List projects, IProgressMonitor pm) throws Exception {
        this.createDoc();
        this.createRoot("build");
        this.createImports();
        this.createClasspaths(this.classpath);
        this.createVersion();
        this.createOverride(this.classpath);
        this.createInit(this.classpath.getSrcDirs(), this.classpath.getClassDirs());
        this.createLoadProperties();
        this.createSaveProperties();
        this.createBuild(this.classpath.getSrcDirs(), this.classpath.getClassDirs(), this.classpath.getInclusionLists(), this.classpath.getExclusionLists());
        this.createBuildProject(this.classpath.getSrcDirs(), this.classpath.getClassDirs(), this.classpath.getInclusionLists(), this.classpath.getExclusionLists());
        this.createBuildSubprojects(this.classpath.getSrcDirs(), this.classpath.getClassDirs(), this.classpath.getInclusionLists(), this.classpath.getExclusionLists());
        this.createJar(this.classpath.getSrcDirs());
        this.createJavadoc();
        this.createClean();
        this.createCopyLibraries(this.classpath);
        this.createCopyJar(this.classpath.getSrcDirs());
        this.createCopyDepJars();
        this.createCopyAllJars();
        this.createCleanAll();
        this.createFetch();
        this.createPlugin(this.classpath);
        this.addSubProperties(this.javaProject, this.classpath);
        this.createProperty(this.classpath);
        this.createPropertyM();
        return true;
    }
}

