/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ant.core;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.higgins.ant.core.DependenciesCreator;
import org.eclipse.higgins.ant.core.JavaProjectBuildFileCreator;
import org.eclipse.higgins.ant.core.PSFCreator;
import org.eclipse.higgins.ant.service.AbstractProjectManager;
import org.eclipse.higgins.ant.service.ICreator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectManager
extends AbstractProjectManager {
    public Set getBuildProjects(Iterator projects, boolean requiredProjects) throws JavaModelException {
        TreeSet<IJavaProject> res = new TreeSet<IJavaProject>(this.getProjectComparator());
        while (projects.hasNext()) {
            IProject project = (IProject)projects.next();
            if (!this.isJavaProject(project)) continue;
            IJavaProject javaProject = this.getJavaProject(project);
            if (requiredProjects) {
                res.addAll(this.getClasspathProjectsRecursive(javaProject));
            }
            res.add(javaProject);
        }
        return res;
    }

    public IProject getProject(Object o) {
        IProject p = null;
        if (o instanceof IProject) {
            p = (IProject)o;
        } else if (o instanceof IJavaProject) {
            p = ProjectManager.getProject((IJavaProject)o);
        } else if (o instanceof String) {
            p = this.getProject((String)o);
        }
        return p;
    }

    private static IProject getProject(IJavaProject p) {
        return p.getProject();
    }

    public ICreator getBuildFileCreator(Object project) throws Exception {
        JavaProjectBuildFileCreator creator = null;
        if (project instanceof IJavaProject) {
            creator = new JavaProjectBuildFileCreator((IJavaProject)project);
        }
        return creator;
    }

    public ICreator getDependenciesCreator(Object project) throws Exception {
        DependenciesCreator creator = null;
        if (project instanceof IProject) {
            creator = new DependenciesCreator((IProject)project);
        }
        return creator;
    }

    public ICreator getPSFCreator(Object project) throws Exception {
        PSFCreator creator = null;
        if (project instanceof IProject) {
            creator = new PSFCreator((IProject)project);
        }
        return creator;
    }

    public ICreator getProjectBuildFileCreator(Object project) throws Exception {
        JavaProjectBuildFileCreator creator = null;
        if (project instanceof IJavaProject) {
            creator = new JavaProjectBuildFileCreator((IJavaProject)project);
        }
        return creator;
    }
}

