/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ant.pde;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.higgins.ant.pde.ProjectManager;
import org.eclipse.higgins.ant.service.AbstractBuildFileCreator;
import org.eclipse.higgins.ant.service.ExportUtil;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SiteBuildFileCreator
extends AbstractBuildFileCreator {
    protected final String PROPERTY = "property";
    protected final String TARGET = "target";
    protected final String NAME = "name";
    protected final String VALUE = "value";
    protected final String MKDIR = "mkdir";
    protected final String DIR = "dir";
    protected final String COPY = "copy";
    protected final String FILESET = "fileset";
    protected final String UNZIP = "unzip";
    protected final String ANT = "ant";
    protected final String ANTCALL = "antcall";
    protected final String DELETE = "delete";
    protected final String TARGET_CLEAN = "-clean";
    protected final String TARGET_SITE = "site";
    protected final String TARGET_UNZIP_FEATURES = "-unzipFeatures";
    protected final String TARGET_BUILD_FEATURES = "-buildFeatures";
    protected final String TARGET_COPY_DEP_PROJECTS = "-copyDepProjects";
    protected final String TARGET_INIT_SITE_BASE = "-initSiteBase";
    protected final String TARGET_MAKE_FOLDERS = "-makeFolders";
    protected IFeatureModel[] featureModels;

    public SiteBuildFileCreator() {
        System.out.println("SiteBuildFileCreator");
    }

    public SiteBuildFileCreator(IProject project) {
        super(projectManager.getProject((Object)project));
    }

    protected void Init(IProject project) {
        super.Init(project);
        this.featureModels = this.getFeatureModels();
    }

    protected IFeatureModel[] getFeatureModels() {
        IFeatureModel[] models = new IFeatureModel[]{};
        if (projectManager instanceof ProjectManager) {
            models = ((ProjectManager)projectManager).getFeatureModels(this.project);
        }
        return models;
    }

    private Element createElement(String name) {
        Element element = this.doc.createElement(name);
        return element;
    }

    private Element createElement(String eName, String attrName, String attrValue) {
        Element element = this.doc.createElement(eName);
        element.setAttribute(attrName, attrValue);
        return element;
    }

    private Element createElement(String eName, String attrName1, String attrValue1, String attrName2, String attrValue2) {
        Element element = this.createElement(eName, attrName1, attrValue1);
        element.setAttribute(attrName2, attrValue2);
        return element;
    }

    private void setAttribute(Element element, String name, String value) {
        if (value != null && !value.equals("")) {
            element.setAttribute(name, value);
        }
    }

    private Element createTarget(String name, String depends, String unless) {
        Element element = this.createElement("target", "name", name);
        this.setAttribute(element, "unless", unless);
        this.setAttribute(element, "depends", depends);
        return element;
    }

    private Element createAnt(String antfile, String dir, String target, String output, String inheritAll, String inheritRefs) {
        Element element = this.createElement("ant");
        this.setAttribute(element, "antfile", antfile);
        this.setAttribute(element, "dir", dir);
        this.setAttribute(element, "target", target);
        this.setAttribute(element, "output", output);
        this.setAttribute(element, "inheritall", inheritAll);
        this.setAttribute(element, "inheritrefs", inheritRefs);
        return element;
    }

    private Element createAntcall(String target, String inheritAll, String inheritRefs) {
        Element element = this.createElement("antcall");
        this.setAttribute(element, "target", target);
        this.setAttribute(element, "inheritAll", inheritAll);
        this.setAttribute(element, "inheritRefs", inheritRefs);
        return element;
    }

    private void appendElement(String eName, String attrName, String attrValue) {
        Element element = this.createElement(eName, attrName, attrValue);
        this.root.appendChild(element);
    }

    private void appendElement(String eName, String attrName1, String attrValue1, String attrName2, String attrValue2) {
        Element element = this.createElement(eName, attrName1, attrValue1, attrName2, attrValue2);
        this.root.appendChild(element);
    }

    private Element createProperty(String name, String value) {
        Element element = this.createElement("property", "name", name, "value", value);
        return element;
    }

    private Element createCopy(String encoding, String failOnError, String overWrite, String toDir) {
        Element copy = this.createElement("copy");
        this.setAttribute(copy, "encoding", encoding);
        this.setAttribute(copy, "failonerror", failOnError);
        this.setAttribute(copy, "overwrite", overWrite);
        this.setAttribute(copy, "todir", toDir);
        return copy;
    }

    private Element createCopy(String file, String tofile, String overwrite) {
        Element copy = this.createElement("copy");
        this.setAttribute(copy, "file", file);
        this.setAttribute(copy, "tofile", tofile);
        this.setAttribute(copy, "overwrite", overwrite);
        return copy;
    }

    private Element createFileset(String dir, String excludes) {
        Element fileset = this.createElement("fileset");
        this.setAttribute(fileset, "dir", dir);
        this.setAttribute(fileset, "excludes", excludes);
        return fileset;
    }

    private void appendProperty(String name, String value) {
        this.appendElement("property", "name", name, "value", value);
    }

    private void appendProperty(Element element, String name, String value) {
        Element property = this.createProperty(name, value);
        element.appendChild(property);
    }

    private void appendMkdir(Element element, String dir) {
        Element mkdir = this.createElement("mkdir", "dir", dir);
        element.appendChild(mkdir);
    }

    private void appendUnzip(Element element, String src, String dest, String overwrite) {
        Element unzip = this.createElement("unzip");
        this.setAttribute(unzip, "src", src);
        this.setAttribute(unzip, "dest", dest);
        this.setAttribute(unzip, "overwrite", overwrite);
        element.appendChild(unzip);
    }

    private void appendComment(String data) {
        Comment comment = this.doc.createComment(data);
        this.root.appendChild(comment);
    }

    private void appendDoc(String name) {
        Document tdoc = projectManager.getTemplate("higgins2ant.pde", name);
        Element troot = tdoc.getDocumentElement();
        NodeList nl = troot.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            Node n1 = this.doc.importNode(n, true);
            this.root.appendChild(n1);
            ++i;
        }
    }

    protected void createProperty() {
        IPath home = JavaCore.getClasspathVariable((String)"ECLIPSE_HOME");
        String home_ecl = home.toString();
        Element ecl = this.doc.createElement("property");
        ecl.setAttribute("name", "ECLIPSE_HOME");
        ecl.setAttribute("value", home_ecl);
        Node node = this.root.insertBefore(ecl, this.root.getFirstChild());
        String location = String.valueOf(this.projectName) + ".location";
        String relativePath = ExportUtil.getRelativePath((String)this.projectRoot, (String)this.projectRoot);
        List list = this.getSubProjects();
        Element element = this.createElement("property", "name", location, "value", relativePath);
        node = node.getNextSibling();
        node = this.root.insertBefore(element, node);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IProject subProject = projectManager.getProject(iterator.next());
            location = String.valueOf(projectManager.getProjectName((Object)subProject)) + ".location";
            String subProjectRoot = projectManager.getProjectRoot((Object)subProject);
            relativePath = ExportUtil.getRelativePath((String)subProjectRoot, (String)this.projectRoot);
            element = this.createElement("property", "name", location, "value", relativePath);
            node = node.getNextSibling();
            node = this.root.insertBefore(element, node);
        }
        try {
            Document tdoc = projectManager.getTemplate("higgins2ant.pde", "siteProperties");
            Element troot = tdoc.getDocumentElement();
            NodeList nl = troot.getChildNodes();
            int length = nl.getLength();
            int i = 0;
            while (i < length) {
                Node n = nl.item(i);
                Node n1 = this.doc.importNode(n, true);
                node = node.getNextSibling();
                node = this.root.insertBefore(n1, node);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Element createUnzipFeature(IFeatureModel model) {
        String name = projectManager.getProjectName((Object)model);
        Element unzip = this.createElement("unzip");
        this.setAttribute(unzip, "src", "${" + name + ".location}/build/features/" + name + "_" + model.getFeature().getVersion() + ".zip");
        this.setAttribute(unzip, "dest", "${build.dir}");
        this.setAttribute(unzip, "overwrite", "true");
        return unzip;
    }

    protected void createUnzipFeatures(Element target) {
        int i = 0;
        while (i < this.featureModels.length) {
            Element copy = this.createUnzipFeature(this.featureModels[i]);
            target.appendChild(copy);
            ++i;
        }
    }

    protected Element createBuildFeature(IFeatureModel model) {
        String name = projectManager.getProjectName((Object)model);
        Element ant = this.createAnt("build.xml", "${" + name + ".location}/", "feature", "", "", "");
        return ant;
    }

    protected void createBuildFeatures(Element target) {
        int i = 0;
        while (i < this.featureModels.length) {
            Element ant = this.createBuildFeature(this.featureModels[i]);
            target.appendChild(ant);
            ++i;
        }
    }

    protected void createUnzipFeatures() {
        this.appendComment(" ======================================== ");
        Element target = this.createTarget("-unzipFeatures", "-buildFeatures", "");
        int i = 0;
        while (i < this.featureModels.length) {
            IFeatureModel model = this.featureModels[i];
            String name = projectManager.getProjectName((Object)model);
            String src = "${temp.dir}/" + name + "/build/features/" + name + "_" + model.getFeature().getVersion() + ".zip";
            String dest = "${build.dir}";
            this.appendUnzip(target, src, dest, "true");
            ++i;
        }
        this.root.appendChild(target);
    }

    protected void createSite() {
        try {
            Document tdoc = projectManager.getTemplate("higgins2ant.pde", "siteBuilder");
            Element troot = tdoc.getDocumentElement();
            NodeList nl = troot.getChildNodes();
            int length = nl.getLength();
            int i = 0;
            while (i < length) {
                Node n = nl.item(i);
                Node n1 = this.doc.importNode(n, true);
                if (n1.getNodeType() == 1) {
                    Element e = (Element)n1;
                    if (e.getNodeName().equals("target") && e.getAttribute("name").equals("-buildFeatures")) {
                        this.createBuildFeatures(e);
                    } else if (e.getNodeName().equals("target") && e.getAttribute("name").equals("-unzipFeatures")) {
                        this.createUnzipFeatures(e);
                    }
                }
                this.root.appendChild(n1);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createClean() {
        this.appendComment(" ======================================== ");
        Element target = this.createTarget("-clean", "-initSiteBase", "");
        Element delete = this.createElement("delete", "dir", "${temp.dir}");
        target.appendChild(delete);
        this.root.appendChild(target);
    }

    protected boolean create(List projects, IProgressMonitor pm) throws Exception {
        this.createDoc();
        this.createRoot("site");
        this.createFetch();
        this.createProperty();
        this.createSite();
        return true;
    }
}

