/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ant.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.higgins.ant.Higgins2AntPlugin;
import org.eclipse.higgins.ant.internal.ui.DataTransferMessages;
import org.eclipse.higgins.ant.service.BuildCreator;
import org.eclipse.higgins.ant.service.ExportUtil;
import org.eclipse.higgins.ant.service.ExtensionManager;
import org.eclipse.higgins.ant.service.IProjectManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BuildfileExportPage
extends WizardPage {
    private CheckboxTableViewer fTableViewer;
    private List fSelectedJavaProjects = new ArrayList();
    private Button requiredProjectsCheckbox;
    private static IProjectManager projectManager = ExtensionManager.createProjectManager();

    public BuildfileExportPage() {
        super("ProjectExportWizardPage");
        this.setPageComplete(false);
        String messageDesc = String.valueOf(DataTransferMessages.AntBuildfileExportPage_1) + "\n" + DataTransferMessages.AntAUXBuildfileExportPage_1 + "\n" + DataTransferMessages.AntDependenciesExportPage_1 + "\n" + DataTransferMessages.PSFExportPage_1;
        String messageTitle = DataTransferMessages.BuildfileExportPage_0;
        this.setTitle(messageTitle);
        this.setDescription(messageDesc);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        Label title = new Label(workArea, 0);
        title.setText(DataTransferMessages.AntBuildfileExportPage_2);
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        Table table = new Table(listComposite, 2848);
        this.fTableViewer = new CheckboxTableViewer(table);
        table.setLayout((Layout)new TableLayout());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        table.setLayoutData((Object)data);
        this.fTableViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getElements(Object element) {
                if (element instanceof Object[]) {
                    return (Object[])element;
                }
                return null;
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fTableViewer.setSorter((ViewerSorter)new BaseSorter());
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    BuildfileExportPage.this.fSelectedJavaProjects.add(event.getElement());
                } else {
                    BuildfileExportPage.this.fSelectedJavaProjects.remove(event.getElement());
                }
                BuildfileExportPage.this.updateEnablement();
            }
        });
        this.initializeProjects();
        this.createSelectionButtons(listComposite);
        this.createCheckboxes(workArea);
        this.setControl((Control)workArea);
        this.updateEnablement();
        Dialog.applyDialogFont((Control)parent);
    }

    private void createSelectionButtons(Composite composite) {
        Composite buttonsComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(DataTransferMessages.AntBuildfileExportPage_11);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < BuildfileExportPage.this.fTableViewer.getTable().getItemCount()) {
                    BuildfileExportPage.this.fSelectedJavaProjects.add(BuildfileExportPage.this.fTableViewer.getElementAt(i));
                    ++i;
                }
                BuildfileExportPage.this.fTableViewer.setAllChecked(true);
                BuildfileExportPage.this.updateEnablement();
            }
        });
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(DataTransferMessages.AntBuildfileExportPage_12);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildfileExportPage.this.fSelectedJavaProjects.clear();
                BuildfileExportPage.this.fTableViewer.setAllChecked(false);
                BuildfileExportPage.this.updateEnablement();
            }
        });
        this.setButtonLayoutData(deselectAll);
    }

    private void createCheckboxes(Composite composite) {
        this.requiredProjectsCheckbox = new Button(composite, 32);
        this.requiredProjectsCheckbox.setSelection(BuildCreator.getCreateBuildFilesForDeps());
        this.requiredProjectsCheckbox.setText(DataTransferMessages.AntBuildfileExportPage_22);
    }

    private void initializeProjects() {
        List projects = projectManager.getWorkspaceProjects();
        IProject[] input = projects.toArray(new IProject[projects.size()]);
        this.fTableViewer.setInput((Object)input);
        if (this.fSelectedJavaProjects != null) {
            this.fTableViewer.setCheckedElements(this.fSelectedJavaProjects.toArray());
        }
    }

    private void updateEnablement() {
        boolean complete = true;
        if (this.fSelectedJavaProjects.size() == 0) {
            this.setErrorMessage(DataTransferMessages.AntBuildfileExportPage_18);
            complete = false;
        }
        if (complete) {
            this.setErrorMessage(null);
        }
        this.setPageComplete(complete);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fTableViewer.getTable().setFocus();
        }
    }

    protected void setSelectedProjects(List selectedJavaProjects) {
        this.fSelectedJavaProjects.clear();
        this.fSelectedJavaProjects.addAll(selectedJavaProjects);
    }

    public boolean generateBuildfiles() {
        Set projects;
        this.setErrorMessage(null);
        final ArrayList projectNames = new ArrayList();
        try {
            projects = this.getProjects();
        }
        catch (JavaModelException e) {
            Higgins2AntPlugin.log(e);
            this.setErrorMessage(MessageFormat.format(DataTransferMessages.AntBuildfileExportPage_10, e.toString()));
            return false;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InterruptedException {
                Exception problem = null;
                try {
                    projectNames.addAll(BuildCreator.createBuildFiles(projects, BuildfileExportPage.this.getShell(), pm));
                }
                catch (Exception e) {
                    problem = e;
                }
                if (problem != null) {
                    Higgins2AntPlugin.log(problem);
                    BuildfileExportPage.this.setErrorMessage(MessageFormat.format(DataTransferMessages.AntBuildfileExportPage_10, problem.toString()));
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            Higgins2AntPlugin.log(e);
            return false;
        }
        catch (InterruptedException e) {
            Higgins2AntPlugin.log(e);
            return false;
        }
        if (this.getErrorMessage() != null) {
            return false;
        }
        if (projectNames.size() > 0) {
            List cyclicProjects;
            String message = MessageFormat.format(String.valueOf(DataTransferMessages.AntBuildfileExportPage_5) + ExportUtil.NEWLINE, String.valueOf(ExportUtil.NEWLINE) + ExportUtil.toString(projectNames, ExportUtil.NEWLINE));
            MessageDialog.openInformation((Shell)this.getShell(), (String)DataTransferMessages.AntBuildfileExportPage_0, (String)message);
            try {
                cyclicProjects = this.getCyclicProjects(projects);
            }
            catch (CoreException e) {
                Higgins2AntPlugin.log(e);
                this.setErrorMessage(MessageFormat.format(DataTransferMessages.AntBuildfileExportPage_10, e.toString()));
                return false;
            }
            if (cyclicProjects.size() > 0) {
                String warningMessage = MessageFormat.format(String.valueOf(DataTransferMessages.AntBuildfileExportPage_6) + ExportUtil.NEWLINE + ExportUtil.NEWLINE + DataTransferMessages.AntBuildfileExportPage_7 + " " + DataTransferMessages.AntBuildfileExportPage_8, String.valueOf(ExportUtil.NEWLINE) + ExportUtil.toString(cyclicProjects, ExportUtil.NEWLINE));
                MessageDialog.openWarning((Shell)this.getShell(), (String)DataTransferMessages.AntBuildfileExportPage_9, (String)warningMessage);
            }
        }
        return true;
    }

    private Set getProjects() throws JavaModelException {
        String message;
        Set projects = projectManager.getBuildProjects(this.fSelectedJavaProjects.iterator(), this.requiredProjectsCheckbox.getSelection());
        List confirmOverwrite = this.getConfirmOverwriteSet(projects);
        if (confirmOverwrite.size() > 0 && !ExportUtil.confirm(message = String.valueOf(DataTransferMessages.AntBuildfileExportPage_3) + ExportUtil.NEWLINE + ExportUtil.toString(confirmOverwrite, ExportUtil.NEWLINE), this.getShell())) {
            return new TreeSet(ExtensionManager.createProjectManager().getProjectComparator());
        }
        return projects;
    }

    private List getCyclicProjects(Set projects) throws CoreException {
        ArrayList<String> cyclicProjects = new ArrayList<String>();
        Iterator iter = projects.iterator();
        while (iter.hasNext()) {
            IJavaProject javaProject = (IJavaProject)iter.next();
            if (!ExportUtil.hasCyclicDependency(javaProject)) continue;
            cyclicProjects.add(javaProject.getProject().getName());
        }
        return cyclicProjects;
    }

    private List getConfirmOverwriteSet(Set javaProjects) {
        ArrayList<String> result = new ArrayList<String>(javaProjects.size());
        Iterator iter = javaProjects.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            String projectRoot = ExtensionManager.createProjectManager().getProjectRoot(o);
            if (!ExportUtil.existsUserFile(String.valueOf(projectRoot) + '/' + BuildCreator.getBUILD_XML())) continue;
            result.add(ExtensionManager.createProjectManager().getProjectName(o));
        }
        return result;
    }

    static class BaseSorter
    extends NameSorter {
        BaseSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int result = 0;
            String name1 = projectManager.getProjectName(e1);
            String name2 = projectManager.getProjectName(e2);
            if (name1 != null && name2 != null) {
                result = this.collator.compare(name1, name2);
            }
            return result != 0 ? result : super.compare(viewer, e1, e2);
        }
    }

    static class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }

        public boolean isSorterProperty(Object element, Object propertyId) {
            return propertyId.equals("org.eclipse.jface.text");
        }
    }
}

