/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ant.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.higgins.ant.service.AbstractCreator;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.w3c.dom.Element;

public abstract class AbstractPSFCreator
extends AbstractCreator {
    protected static Set notSublipse = new TreeSet(projectManager.getProjectComparator());

    public AbstractPSFCreator() {
    }

    public AbstractPSFCreator(IProject project) {
        super(project);
    }

    protected void Init(IProject project) {
        super.Init(project);
    }

    protected boolean create(List projects, IProgressMonitor pm) throws Exception {
        boolean allowOverwrite = false;
        HashMap<String, TreeSet<IProject>> byProvider = new HashMap<String, TreeSet<IProject>>();
        int i = 0;
        while (i < projects.size()) {
            IProject p = projectManager.getProject(projects.get(i));
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)p);
            if (provider != null) {
                String id = provider.getID();
                if ("org.eclipse.team.cvs.core.cvsnature".equalsIgnoreCase(id) || "org.tigris.subversion.subclipse.core.svnnature".equalsIgnoreCase(id) || "org.eclipse.team.svn.core.svnnature".equalsIgnoreCase(id)) {
                    TreeSet<IProject> list = (TreeSet<IProject>)byProvider.get(id);
                    if (list == null) {
                        list = new TreeSet<IProject>(projectManager.getProjectComparator());
                        byProvider.put(id, list);
                    }
                    list.add(p);
                    if ("org.tigris.subversion.subclipse.core.svnnature".equalsIgnoreCase(id) || "org.eclipse.team.svn.core.svnnature".equalsIgnoreCase(id)) {
                        allowOverwrite = true;
                    }
                } else {
                    notSublipse.add(p);
                }
            } else {
                notSublipse.add(p);
            }
            ++i;
        }
        if (allowOverwrite) {
            this.createDoc();
            Element psf = this.doc.createElement("psf");
            psf.setAttribute("version", "2.0");
            this.doc.appendChild(psf);
            Iterator providersIt = byProvider.keySet().iterator();
            while (providersIt.hasNext()) {
                String id = (String)providersIt.next();
                Set list = (Set)byProvider.get(id);
                IProject[] projectArray = list.toArray(new IProject[list.size()]);
                RepositoryProviderType providerType = RepositoryProviderType.getProviderType((String)id);
                ProjectSetCapability capability = providerType.getProjectSetCapability();
                ProjectSetCapability.ensureBackwardsCompatible((RepositoryProviderType)providerType, (ProjectSetCapability)capability);
                String[] references = null;
                if (capability != null) {
                    NullProgressMonitor spm = null;
                    spm = new NullProgressMonitor();
                    references = capability.asReference(projectArray, new ProjectSetSerializationContext(), (IProgressMonitor)spm);
                }
                if (references == null) continue;
                Element psfProvider = this.doc.createElement("provider");
                psfProvider.setAttribute("id", id);
                int i2 = 0;
                while (i2 < references.length) {
                    Element project = this.doc.createElement("project");
                    project.setAttribute("reference", references[i2]);
                    psfProvider.appendChild(project);
                    ++i2;
                }
                psf.appendChild(psfProvider);
            }
        }
        return allowOverwrite;
    }
}

