/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ant.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.higgins.ant.Higgins2AntPlugin;
import org.eclipse.higgins.ant.internal.ui.DataTransferMessages;
import org.eclipse.higgins.ant.service.AbstractProjectManager;
import org.eclipse.higgins.ant.service.ExportUtil;
import org.eclipse.higgins.ant.service.ICreator;
import org.eclipse.higgins.ant.service.IProjectManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class BuildCreator {
    protected static IPreferenceStore preferenceStore = null;
    protected static final String WARNING = " WARNING: Eclipse auto-generated file." + ExportUtil.NEWLINE + "              Any modifications will be overwritten.";
    protected static IProjectManager projectManager = AbstractProjectManager.getInstance();

    /*
     * Exception decompiling
     */
    public static List createBuildFiles(Set projects, Shell shell, IProgressMonitor pm) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 40->43)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void createBuildFilesLoop(Set projects, Shell shell, IProgressMonitor pm, List res) throws Exception {
        ArrayList<IFile> files = new ArrayList<IFile>();
        Iterator iter = projects.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            IFile file = BuildCreator.getBuildFile(object);
            if (file != null) {
                files.add(file);
            }
            if ((file = BuildCreator.getDependenciesFile(object)) != null) {
                files.add(file);
            }
            if ((file = BuildCreator.getPSFFile(object)) != null) {
                files.add(file);
            }
            if ((file = BuildCreator.getPSFWithDepsFile(object)) == null) continue;
            files.add(file);
        }
        Map validator2files = ExportUtil.getFileModificationValidator(files);
        Set confirmedFiles = ExportUtil.validateEdit(shell, validator2files);
        if (pm != null) {
            pm.beginTask(DataTransferMessages.AntBuildfileExportPage_0, confirmedFiles.size());
        }
        Iterator iter2 = projects.iterator();
        while (iter2.hasNext()) {
            Object object = iter2.next();
            BuildCreator.createBuildFile(object, confirmedFiles, pm);
            if (BuildCreator.getCreateDependenciesFiles()) {
                BuildCreator.createDependenciesFile(object, confirmedFiles, pm);
            }
            if (BuildCreator.getCreatePSFFiles()) {
                BuildCreator.createPSFFile(object, confirmedFiles, pm);
            }
            if (!BuildCreator.getCreateDeepPSFFiles()) continue;
            BuildCreator.createPSFWithDepsFile(object, confirmedFiles, pm);
        }
    }

    protected static void createPSFFile(Object object, Set confirmedFiles, IProgressMonitor pm) throws Exception {
        IProject p = projectManager.getProject(object);
        IFile file = BuildCreator.getPSFFile(p);
        if (confirmedFiles.contains(file)) {
            if (pm != null) {
                pm.subTask("Creating " + p.getName() + "/" + file.getName());
            }
            ICreator creator = null;
            IProject project = projectManager.getProject(object);
            if (project != null) {
                creator = projectManager.getPSFCreator(project);
            }
            if (creator != null) {
                BuildCreator.writeFile(file, creator.create(true, false, pm));
            }
            if (pm != null) {
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        }
    }

    protected static void createPSFWithDepsFile(Object object, Set confirmedFiles, IProgressMonitor pm) throws Exception {
        IProject p = projectManager.getProject(object);
        IFile file = BuildCreator.getPSFWithDepsFile(p);
        if (confirmedFiles.contains(file)) {
            if (pm != null) {
                pm.subTask("Creating " + p.getName() + "/" + file.getName());
            }
            ICreator creator = null;
            IProject project = projectManager.getProject(object);
            if (project != null) {
                creator = projectManager.getPSFCreator(project);
            }
            if (creator != null) {
                BuildCreator.writeFile(file, creator.create(true, true, pm));
            }
            if (pm != null) {
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        }
    }

    protected static void createDependenciesFile(Object object, Set confirmedFiles, IProgressMonitor pm) throws Exception {
        IProject p = projectManager.getProject(object);
        IFile file = BuildCreator.getDependenciesFile(p);
        if (confirmedFiles.contains(file)) {
            ICreator creator;
            if (pm != null) {
                pm.subTask("Creating " + p.getName() + "/" + file.getName());
            }
            if ((creator = projectManager.getDependenciesCreator(p)) != null) {
                ByteArrayInputStream is = creator.create(false, true, pm);
                BuildCreator.writeFile(file, is);
            }
            if (pm != null) {
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        }
    }

    protected static void createBuildFile(Object object, Set confirmedFiles, IProgressMonitor pm) throws Exception {
        IProject p = projectManager.getProject(object);
        IFile file = BuildCreator.getBuildFile(p);
        if (confirmedFiles.contains(file)) {
            ICreator creator;
            if (pm != null) {
                pm.subTask("Creating " + p.getName() + "/" + file.getName());
            }
            if ((creator = projectManager.getBuildFileCreator(object)) != null && !projectManager.getProjectName(p).equals("org.eclipse.higgins.auto")) {
                ByteArrayInputStream is = creator.create(false, false, pm);
                BuildCreator.writeFile(file, is);
            }
            if (pm != null) {
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        }
    }

    protected static void writeFile(IFile file, ByteArrayInputStream is) throws CoreException {
        if (is != null) {
            if (file.exists()) {
                if (!ExportUtil.isIdentical(file, is)) {
                    file.setContents((InputStream)is, true, true, null);
                }
            } else {
                file.create((InputStream)is, true, null);
            }
        }
    }

    public static IFile getBuildFile(Object o) {
        IFile f = null;
        IProject p = projectManager.getProject(o);
        if (p != null) {
            f = p.getFile(BuildCreator.getBUILD_XML());
        }
        return f;
    }

    public static IFile getDependenciesFile(Object o) {
        IFile f = null;
        IProject p = projectManager.getProject(o);
        if (p != null) {
            f = p.getFile(BuildCreator.getDEP_XML());
        }
        return f;
    }

    public static IFile getPSFFile(Object o) {
        IFile f = null;
        IProject p = projectManager.getProject(o);
        if (p != null) {
            f = p.getFile(BuildCreator.getPSF_XML());
        }
        return f;
    }

    public static IFile getPSFWithDepsFile(Object o) {
        IFile f = null;
        IProject p = projectManager.getProject(o);
        if (p != null) {
            f = p.getFile(BuildCreator.getPSF_DEP_XML());
        }
        return f;
    }

    public static IPreferenceStore getPreferenceStore() {
        if (preferenceStore == null) {
            preferenceStore = Higgins2AntPlugin.getDefault().getPreferenceStore();
        }
        return preferenceStore;
    }

    public static String getBUILD_XML() {
        IPreferenceStore store = BuildCreator.getPreferenceStore();
        return store.getString("higgins2ant.general.fileNameBuild");
    }

    public static String getDEP_XML() {
        IPreferenceStore store = BuildCreator.getPreferenceStore();
        return store.getString("higgins2ant.general.fileNameDependencies");
    }

    public static String getPSF_XML() {
        IPreferenceStore store = BuildCreator.getPreferenceStore();
        return store.getString("higgins2ant.general.fileNamePSF");
    }

    public static String getPSF_DEP_XML() {
        IPreferenceStore store = BuildCreator.getPreferenceStore();
        return store.getString("higgins2ant.general.fileNameDeepPSF");
    }

    public static boolean getCreateBuildFilesForDeps() {
        IPreferenceStore store = BuildCreator.getPreferenceStore();
        return store.getBoolean("higgins2ant.general.createBuildFilesForDependencies");
    }

    public static boolean getCreateDependenciesFiles() {
        IPreferenceStore store = BuildCreator.getPreferenceStore();
        return store.getBoolean("higgins2ant.general.createDependenciesFile");
    }

    public static boolean getCreatePSFFiles() {
        IPreferenceStore store = BuildCreator.getPreferenceStore();
        return store.getBoolean("higgins2ant.general.createPSFFile");
    }

    public static boolean getCreateDeepPSFFiles() {
        IPreferenceStore store = BuildCreator.getPreferenceStore();
        return store.getBoolean("higgins2ant.general.createDeepPSFFile");
    }

    public static boolean getAutorunAtStartUp() {
        IPreferenceStore store = BuildCreator.getPreferenceStore();
        return store.getBoolean("higgins2ant.autorun.atStartUp");
    }

    public static boolean getAutorunMonitorFileChanges() {
        IPreferenceStore store = BuildCreator.getPreferenceStore();
        return store.getBoolean("higgins2ant.autorun.monitorFileChanges");
    }

    public static String getAutorunMonitorFileNames() {
        IPreferenceStore store = BuildCreator.getPreferenceStore();
        return store.getString("higgins2ant.autorun.monitorFileNames");
    }
}

