/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.ant.service;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.higgins.ant.service.IProjectManager;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ExtensionManager {
    private static final String XP_NAME = "higgins2ant.higgins2ant";
    private static final String ELEMENT_PROJECT = "projectManager";
    private static IProjectManager projectManager = null;
    private static final String CLASS_ATTRIBUTE = "class";

    private static IConfigurationElement[] getElements(String extensionPoint, String elementName) {
        IConfigurationElement[] elements = null;
        IPluginRegistry registry = Platform.getPluginRegistry();
        IExtensionPoint xp = registry.getExtensionPoint(extensionPoint);
        IConfigurationElement[] members = xp.getConfigurationElements();
        LinkedList<IConfigurationElement> list = new LinkedList<IConfigurationElement>();
        int i = 0;
        while (i < members.length) {
            String name = members[i].getName();
            if (name.equals(elementName)) {
                list.add(members[i]);
            }
            ++i;
        }
        Object[] objects = list.toArray();
        elements = new IConfigurationElement[objects.length];
        int i2 = 0;
        while (i2 < objects.length) {
            elements[i2] = (IConfigurationElement)objects[i2];
            ++i2;
        }
        return elements;
    }

    private static Object getExecutableExtension(IConfigurationElement element) throws CoreException {
        Object extension = null;
        extension = element.createExecutableExtension(CLASS_ATTRIBUTE);
        return extension;
    }

    private static List getDependencies(IConfigurationElement element) {
        LinkedList<String> dependencies = new LinkedList<String>();
        Plugin plugin = Platform.getPlugin((String)element.getNamespaceIdentifier());
        Bundle bundle = plugin.getBundle();
        String requires = (String)bundle.getHeaders().get("Require-Bundle");
        try {
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Require-Bundle", (String)requires);
            int i = 0;
            while (i < elements.length) {
                dependencies.add(elements[i].getValue());
                ++i;
            }
        }
        catch (BundleException e) {
            e.printStackTrace();
        }
        return dependencies;
    }

    private static List getModelNamespaces() {
        String[] namespaces = Platform.getExtensionRegistry().getNamespaces();
        return Arrays.asList(namespaces);
    }

    private static IConfigurationElement getProperElement(String elementName) {
        IConfigurationElement element = null;
        IConfigurationElement[] members = ExtensionManager.getElements(XP_NAME, elementName);
        int maxDependencies = -1;
        int i = 0;
        while (i < members.length) {
            List dependencies;
            List modelNamespaces = ExtensionManager.getModelNamespaces();
            boolean isAvailable = modelNamespaces.containsAll(dependencies = ExtensionManager.getDependencies(members[i]));
            if (isAvailable && maxDependencies < dependencies.size()) {
                maxDependencies = dependencies.size();
                element = members[i];
            }
            ++i;
        }
        return element;
    }

    public static IProjectManager createProjectManager() {
        if (projectManager != null) {
            return projectManager;
        }
        IConfigurationElement member = ExtensionManager.getProperElement(ELEMENT_PROJECT);
        try {
            projectManager = (IProjectManager)ExtensionManager.getExecutableExtension(member);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return projectManager;
    }
}

