/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.common;

import java.util.List;
import org.eclipse.higgins.icard.ITemplateValue;
import org.eclipse.higgins.icard.IUIDescriptor;
import org.eclipse.higgins.icard.common.TemplateElement;
import org.eclipse.higgins.icard.common.UIDescriptor;

public class TemplateValue
extends TemplateElement
implements ITemplateValue {
    protected String value_;
    protected boolean isValueRequired_ = false;
    protected IUIDescriptor descriptor_;

    public static TemplateValue createTextFieldTemplate(String id, String defaultValue, String regExpPattern, String description, String displayName, String inputMask, boolean isValueRequired) {
        TemplateValue newValue = new TemplateValue();
        newValue.setID(id);
        newValue.setDescription(description);
        newValue.setDisplayName(displayName);
        newValue.setIsValueRequired(isValueRequired);
        newValue.setValue(defaultValue);
        newValue.setUIDescriptor(UIDescriptor.createTextFieldDescriptor(regExpPattern, inputMask));
        return newValue;
    }

    public static TemplateValue createTextAreaTemplate(String id, String defaultValue, String regExpPattern, String description, String displayName, boolean isValueRequired) {
        TemplateValue newValue = new TemplateValue();
        newValue.setID(id);
        newValue.setValue(defaultValue);
        newValue.setDescription(description);
        newValue.setDisplayName(displayName);
        newValue.setIsValueRequired(isValueRequired);
        newValue.setUIDescriptor(UIDescriptor.createTextAreaDescriptor(regExpPattern));
        return newValue;
    }

    public static TemplateValue createFileTemplate(String id, String defaultValue, String description, String displayName, boolean isValueRequired) {
        TemplateValue newValue = new TemplateValue();
        newValue.setID(id);
        newValue.setValue(defaultValue);
        newValue.setDescription(description);
        newValue.setDisplayName(displayName);
        newValue.setIsValueRequired(isValueRequired);
        newValue.setUIDescriptor(UIDescriptor.createFileDescriptor());
        return newValue;
    }

    public static TemplateValue createCheckBoxTemplate(String id, String defaultValue, List optionalValues, String description, String displayName, boolean isValueRequired) {
        TemplateValue newValue = new TemplateValue();
        newValue.setID(id);
        newValue.setValue(defaultValue);
        newValue.setDescription(description);
        newValue.setDisplayName(displayName);
        newValue.setIsValueRequired(isValueRequired);
        newValue.setUIDescriptor(UIDescriptor.createCheckBoxDescriptor(optionalValues));
        return newValue;
    }

    public static TemplateValue createComboBoxTemplate(String id, String defaultValue, List optionalValues, String description, String displayName, boolean isValueRequired) {
        TemplateValue newValue = new TemplateValue();
        newValue.setID(id);
        newValue.setValue(defaultValue);
        newValue.setDescription(description);
        newValue.setDisplayName(displayName);
        newValue.setIsValueRequired(isValueRequired);
        newValue.setUIDescriptor(UIDescriptor.createComboBoxDescriptor(optionalValues));
        return newValue;
    }

    public static TemplateValue createDateTimeTemplate(String id, String defaultValue, String regExpPattern, String description, String displayName, String inputMask, boolean isValueRequired) {
        TemplateValue newValue = new TemplateValue();
        newValue.setID(id);
        newValue.setDescription(description);
        newValue.setDisplayName(displayName);
        newValue.setIsValueRequired(isValueRequired);
        newValue.setValue(defaultValue);
        newValue.setUIDescriptor(UIDescriptor.createDateTimeDescriptor(inputMask, regExpPattern));
        return newValue;
    }

    public String getValue() {
        return this.value_;
    }

    public void setValue(String value) {
        this.value_ = value;
    }

    public boolean isValueRequired() {
        return this.isValueRequired_;
    }

    public void setIsValueRequired(boolean isValueRequired) {
        this.isValueRequired_ = isValueRequired;
    }

    public IUIDescriptor getUIDescriptor() {
        return this.descriptor_;
    }

    public void setUIDescriptor(IUIDescriptor descriptor) {
        this.descriptor_ = descriptor;
    }
}

