/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.common.auth;

import java.net.URI;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import org.eclipse.higgins.icard.auth.IKerberosV5Credential;
import org.eclipse.higgins.icard.auth.ITSKerberosV5Credential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;

public class TSKerberosV5Credential
implements ITSKerberosV5Credential {
    ITokenServiceCredential tsc;
    IKerberosV5Credential kv5c;

    public TSKerberosV5Credential(ITokenServiceCredential tsc, IKerberosV5Credential kv5c) {
        this.tsc = tsc;
        this.kv5c = kv5c;
    }

    public URI getAddress() {
        return this.tsc.getAddress();
    }

    public X509Certificate getCertificate() {
        return this.tsc.getCertificate();
    }

    public URI getMetadataAddress() {
        return this.tsc.getMetadataAddress();
    }

    public Callback[] getCallbacks() {
        Callback[] cts = this.tsc.getCallbacks();
        Callback[] ckv5 = this.kv5c.getCallbacks();
        Callback[] c = new Callback[cts.length + ckv5.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = i < cts.length ? cts[i] : ckv5[i - cts.length];
        }
        return c;
    }
}

